---
title: Andika - Versions and Changes
fontversion: 7.000
---

## Announcement list

If you would like stay informed of updates to Andika and other SIL fonts, please subscribe to the [SIL Font News Announcement List](https://groups.google.com/a/groups.sil.org/forum/#!forum/sil-font-news). For more information see [About](about.md).

Our font announcements are also available through X (formerly Twitter) [\@silfonts](https://x.com/silfonts).

## Current versions

The latest version of the fonts is always available from the [Andika download page](https://software.sil.org/andika/download/) as a .zip archive for all major platforms.

Andika is also available through the [TypeTuner Web](https://typetunerweb.languagetechnology.org/ttw/fonts2go.cgi) service, which allows you to choose among the smart font features and download a font with those features preset. This enables them to work in many applications that do not fully support OpenType. **Please note that the version 7 fonts available through TypeTuner Web no longer offer line spacing alternatives (Normal, Tight, Loose). If you need Tight or Loose variants the version 6.200 fonts remain available and support line spacing alternatives.**

## Andika Six

The changes in Andika version 7 could have a significant effect on line, paragraph, and page lengths due to added kerning. Because of this we have released a font that reproduces the exact metrics and behavior of Andika v6.200—*Andika Six*—that can be installed at the same time as the newest Andika (v7 and beyond). Andika v7 is still the best font for most people to use. But if you have documents prepared with Andika v6.200 and need to preserve the spacing, you can install Andika Six, change the doc to use it instead of Andika, and avoid any issues with reflow. Then you can use Andika v7 for new documents and benefit from the many improvements in this and future versions. See the [Andika Six announcement](https://software.sil.org/andika/andika-six-release-6-210-a-renamed-version-of-andika-6-200/) for more details on downloading and using Andika Six.

## Other Andika variants and versions

There are many font families based on the Andika design, as summarized in this table. Current versions are in **bold**. Additional information is provided in later sections.

Font Family | Versions | Status and use
----------- | -------- | ---------------------
**Andika**|**7.000**|**Current**—recommended for all uses and users
**Andika Six**|**6.210**|**Current**—provided for users who need to preserve the spacing and behavior of Andika 6.200
Andika|1.000–6.200|No longer recommended—please use current version
Andika Compact|1.000–6.200|Fonts with reduced default line spacing—no longer recommended
Andika *special variant*|5.000–6.200|Modified versions for special purposes (AmArea, Mali, Tat)—no longer recommended
Andika *region subset*|5.000|Subsets for particular regions (Afr, Am, APac, Cyr, CyrE, Eur, Phon, Viet)—no longer recommended
Andika New Basic|5.500|Limited-character-set version of Andika, based on version 5—no longer recommended
Andika Basic|1.000|Early limited-character-set version of Andika—no longer recommended

There are also font families named ‘Andika *something*’ that were created using [TypeTuner Web](https://scripts.sil.org/ttw/fonts2go.cgi). We have no record or archive of most of these ‘tuned’ fonts, but if you are desperate to find them contact us. We may be able to point you to the distributors of those that we know about.

### *Compact* versions

The Andika version 7 fonts do not have *Compact* variants. Most users should use the version 7 fonts and adjust line spacing explicitly within the application if necessary. If your application does not allow control over line spacing, you can use the [version 6.200 Andika Compact fonts](https://software.sil.org/lcgfonts/download/), which remain available. **If you need any of the new version 7 features or characters, but also need them supported in a compact version please [contact us](https://software.sil.org/andika/about/contact/).**

### Special-purpose modified variants

[Modified versions of the Andika version 6.200 fonts](https://software.sil.org/lcgfonts/download/) are available that have been ‘tuned’ to turn on certain features by default. These are available for some regions. **These remain at version 6.200 and have not been updated to Andika version 7. If you need any of the new features or characters in this version, but also need them supported in the special-purpose modified fonts please [contact us](https://software.sil.org/andika/about/contact/).**

### Version 5 subsets

In the past, special *subset* versions of Andika version 5 were created for specific uses. Those fonts still work and [remain available](https://software.sil.org/lcgfonts/font-subsets/). These are limited versions of the fonts that support only the characters needed for a particular area or use. Subsets are available for Africa, Americas, Asia/Pacific, Europe/Eurasia, Vietnam, Phonetic, Cyrillic (Basic) and Cyrillic Extended. With the exception of the Phonetic font, the font subsets are intended for orthographic use only. We have not put anything in the other subsets for phonetic, transliteration, or transcription use. For those purposes, use the Phonetic subset. We do not intend to update these fonts, however they may still work. **We do not, however, recommend their use. In almost all cases the standard fonts are a better choice. Font size is less of a concern than it was years ago, particularly with improved compression technologies such as woff2.**

## Previous versions archive

Previous versions remain available from our [Previous versions archive](https://software.sil.org/andika/download/previous-versions).

## Change history

A detailed list of changes for each version of the fonts is on the [Version history page](history.md).
