---
title: Awami Nastaliq Developer Documentation
fontversion: 3.300
---

# Images of Principal Interfaces

### default (no suffix)

Connects to alef, lam, kaf, dal.

![](images/interfaces/default.png)

### .ai

Connects to ain.

![](images/interfaces/ai.png)

### .be

Connects to some beh forms.

![](images/interfaces/be.png)

### .beM1

Connects to high-tooth behs.

![](images/interfaces/beM1.png)

### .beM2

Connects to low-tooth behs.

![](images/interfaces/beM2.png)

Several initials (beh, feh, kaf, and lam) connect to an alternate form of the final beh using a low-tooth interface.

![](images/interfaces/beM2_beF.png)

### .benn

Connects to beh that occurs before a final noon.

![](images/interfaces/benn.png)

###  .behg

Connects to beh that occurs before a final heh-goal.

![](images/interfaces/behg.png)

###  .bere

Connects to beh that occurs before a final reh.

![](images/interfaces/bere.png)

###  .beF

Connects to standard final beh.

![](images/interfaces/beF.png)

(There is an alternate form of the final beh that essentially implements the low-tooth interface before a handful of initials (beh, feh, kaf, and lam). The initials use .beM2.)

### .by

Connects to bariyeh (final).

![](images/interfaces/by.png)

### .ch

Connects to final chotiyeh.

There are essentially two different interfaces; the second is used following kaf, lam, initial feh, and initial beh.

![](images/interfaces/ch.png)

### .fe

Connects to feh and medial qaf.

![](images/interfaces/fe.png)

### .hd

Connects to heh-doachaschmee.

![](images/interfaces/hd.png)

### .hgM

Connects to medial heh-goal.

![](images/interfaces/hgM.png)

### .hgF

Connects to final heh-goal

![](images/interfaces/hgF.png)

### .jm

Connects to jeem.

![](images/interfaces/jm.png)

### .mm

Connects to the standard meem.

![](images/interfaces/mm.png)

### .mmX

Connects to the alternate medial meem (round form).

![](images/interfaces/mmX.png)

### .nn

Connects to final noon.

![](images/interfaces/nn.png)

### .qf

Connects to final qaf and waw.

Implementationally there are two different interfaces, with the second used following seen, tah, heh doachashmee, and medial feh. However, since the shapes of the final forms are not signficantly different, possibly the two interfaces could be merged.

![](images/interfaces/qf.png)

### .re

Connects to reh (final).

There are essentially two different interfaces; the second is used following jeem, kaf, lam, and initial beh.

![](images/interfaces/re.png)

### .sd

Connects to sad as well as the rounded form of kaf that occurs before a lam and alef.

![](images/interfaces/sd.png)

### .sn

Connects to the standard seen.

![](images/interfaces/sn.png)

### .snsn

Connects to the flat “kashida”-style seen that occurs before another seen.

![](images/interfaces/snsn.png)

### .ta

Connects to tah.

![](images/interfaces/ta.png)


Back to discussion of [Glyph Interfaces](dev03_interfaces.md)

<!-- PRODUCT SITE ONLY
[font id='awami' face='AwamiNastaliq-Regular' size='150%' rtl=1]
[font id='awamiL' face='AwamiNastaliq-Regular' size='150%' ltr=1]
-->
