---
title: Awami Nastaliq - Version History
fontversion: 3.400
---

### 2025-Oct-17 (SIL WSTech team) Awami Nastaliq Version 3.400

#### Improved

- Fixed issues with kerning and collisions.

#### New

- Added support for Malay hamza forms.
- Added 5 characters:
  - U+0682 ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE
  - U+06A8 ARABIC LETTER QAF WITH THREE DOTS ABOVE
  - U+0754 ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE
  - U+FD4F ARABIC LIGATURE RAHIMAHUM ALLAAH
  - U+FDFF ARABIC LIGATURE AZZA WA JALL

### 2024-Oct-09 (SIL WSTech team) Awami Nastaliq Version 3.300

#### Improved
- Fixed issue with wasla collisions

#### New
- Added support for Kashmiri language
- Added support for Gojri language
- Added 15 characters:
  - U+08F7 ARABIC LEFT ARROWHEAD ABOVE (for Burushaski)
  - U+FBC6 ARABIC LIGATURE RAHMATU ALLAAHI ALAYHIM (this character is not officially in Unicode, 
    it is in the pipeline for a future version of the Unicode Standard)
  - U+FBC7 ARABIC LIGATURE RAHMATU ALLAAHI ALAYHIMAA (this character is not officially in Unicode, 
    it is in the pipeline for a future version of the Unicode Standard)
  - U+FD40 ARABIC LIGATURE RAHIMAHU ALLAAH
  - U+FD41 ARABIC LIGATURE RADI ALLAAHU ANH
  - U+FD42 ARABIC LIGATURE RADI ALLAAHU ANHAA
  - U+FD43 ARABIC LIGATURE RADI ALLAAHU ANHUM
  - U+FD44 ARABIC LIGATURE RADI ALLAAHU ANHUMAA
  - U+FD45 ARABIC LIGATURE RADI ALLAAHU ANHUNNA
  - U+FD48 ARABIC LIGATURE ALAYHIM AS-SALAAM
  - U+FD49 ARABIC LIGATURE ALAYHIMAA AS-SALAAM
  - U+FD4D ARABIC LIGATURE ALAYHAA AS-SALAAM
  - U+FD90 ARABIC LIGATURE RAHMATU ALLAAHI ALAYH (this character is not officially in Unicode, 
    it is in the pipeline for a future version of the Unicode Standard)
  - U+FD91 ARABIC LIGATURE RAHMATU ALLAAHI ALAYHAA (this character is not officially in Unicode, 
    it is in the pipeline for a future version of the Unicode Standard)
  - U+FDFE ARABIC LIGATURE SUBHAANAHU WA TAAALAA

### 2023-Oct-23 (SIL WSTech team) Awami Nastaliq Version 3.200

#### Improved
- Fixed bug in dot removal for YEH followed by COMBINING Hamza (U+064A U+0654)
- Fixed some minor kerning/collision/spacing bugs
- Changed shape of mark on 06C7 (Arabic U) to look like a comma instead of a pesh
- Created bold forms of the honorifics
- Changed PUA codepoint U+E003 to U+FD47 ARABIC LIGATURE ALAYHI AS-SALAAM
- Corrected weight class of Medium, SemiBold, and ExtraBold fonts

#### New
- Added six characters:
  - U+06A0 ARABIC LETTER AIN WITH THREE DOTS ABOVE
  - U+06AD ARABIC LETTER NG
  - U+06BD ARABIC LETTER NOON WITH THREE DOTS ABOVE
  - U+0762 ARABIC LETTER KEHEH WITH DOT ABOVE
  - U+FDCF ARABIC LIGATURE SALAAMUHU ALAYNAA
  - U+10ED0 ARABIC BIBLICAL END OF VERSE (this character is not officially in Unicode, it is in the pipeline for a future version of the Unicode Standard)

### 2023-Jan-30 (SIL WSTech team) Awami Nastaliq Version 3.100

#### Improved
- Fixed a bug that manifested as disappearing glyphs
- Fixed some minor kerning/collision/spacing bugs

### 2022-Sep-20 (SIL WSTech team) Awami Nastaliq Version 3.000

#### New
- Added 4 weights -- Medium, SemiBold, Bold, and ExtraBold
- Added three characters:
	- U+08C8 ARABIC LETTER GRAF
	- U+069B ARABIC LETTER SEEN WITH THREE DOTS BELOW
	- U+069C ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE

#### Improved
- Modified rules for forming the Allah ligature
- Fixed a bug affecting the right margin
- Fixed a problem with the behavior of the yeh with hamza
- Added a short version of the final sad
- Various improvements to beh forms
- Collision fixes
- Changed the default value of the short forms feature to use all short forms
- Added a special form of khah+zabar+meem+jeem+heh-doachashmee to avoid excessive height
- Flattened a couple of special ligatures
- Changed dopesh to use 69 form consistently

#### Removed
- Removed "Small nuqtas" feature

### 2021-Apr-29 (SIL WSTech team) Awami Nastaliq Version 2.200
- Improved spacing and kerning involving punctuation
- Corrected nuqtas in dul character
- Fixed collision bug that manifested itself in Paratext
- Fixed other obscure bugs

### 2021-Jan-18 (SIL WSTech team) Awami Nastaliq Version 2.100
- Added four honorific ligatures
	- U+FDFA ARABIC LIGATURE SALLALLAHOU ALAYHEWASALLAM
	- U+FDFB ARABIC LIGATURE JALLAJALALOUHOU
	- U+FDFD ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM
	- U+E003 ALAYHI AS-SALAAM
- Added U+075A DAL WITH INVERTED SMALL V BELOW
- Adjusted shapes of lam + alef combination, certain reh forms, medial heh goal + reh
- Adjusted position of honorific diacritics
- Adjusted position of superscript-alef on lam
- Added special ligature forms for three words
- Added short forms of jeem+bariyeh, beh+qaf/waw, final jeem, final ain
- Added wider form of jeem+kaf combination where needed
- Improved alignment of kafs, alef, and bariyeh with the right margin
- Increased spacing when sequences overlap
- Improved kerning of punctuation
- Improved kerning for rehs and other final forms
- Improved connections with medial/final fehs

### 2019-Jun-19 (SIL WSTech team) Awami Nastaliq Version 2.000
- Ten new characters - U+06C8, U+06CA, U+06CB, U+06CF, U+077E, U+077F, U+0695, U+06A4, U+08C7, U+221A
- Adjust behavior of nuqtas over sequences of beh/teh/theh/peh/etc.
- Changed shape of beh+seen and beh+sad before sad, tah, ain, feh, qaf, and final noon.
- Improved glyph-shape approximations for automatic collision fixing
- Adjusted diagonal cluster fitting involving short sequences
- Adjusted shape of meem heads
- Adjusted behavior of final-reh + zer
- Added and tweaked anchors
- Added smaller flat nukta for certain cases
- Adjusted shape of pre-jeem medial lam, keheh and gaf
- Adjusted position of salaam ulena ligature
- Adjusted position of Arabic zero characters
- Reduced size of U+060E
- Fixed bugs in bariyeh attachments
- Removed "Show invisible characters" feature
- Fixed bug in "Hamza" feature (Arabic style setting)
- Adjusted design of U+06BA (noon ghunna) to match Unicode recommendations
- Tweaked glyph shapes and sizes

### 2018-Apr-24 (SIL NRSI team) Awami Nastaliq Version 1.101
- Fixed bug in positioning of final reh

### 2018-Apr-03 (SIL NRSI team) Awami Nastaliq Version 1.100
- Added characters: U+0604, U+0609, U+060A, U+060B, U+061C, U+0649, U+0659, U+066E, U+066F, U+0671, U+068E, U+069E, U+06A1, U+06B7, U+06C9, U+06E0, U+06E1, U+06EA, U+06ED, U+0763, U+0772, U+0773, U+0774, U+0775, U+0776, U+0777, U+0778, U+0779,	U+077A, U+077B, U+077C, U+077D, U+FDFC
- Adjusted shapes of sad, heh-doachashmee, some jeem forms, initial ains, and alternate-height kafs and gafs
- Improved shape of shadda
- Fixed right side-bearing problems with kafs, gafs, seens, and bariyeh
- Made bariyeh right-joining only
- Made many small glyph shape improvements
- Improved collision handling for special cases 
- Added an omitted feature to TypeTuner capability
- Redesigned salaam ulena ligature
- Improved punctuation kerning
- Include auto-hinting for Latin characters
- Fixed bug in noon-ring implementation
- Fixed positioning problems in end of ayah

### 2017-Jul-17 (SIL NRSI team) Awami Nastaliq Version 1.000
- Adjusted spacing issues between some characters
- Adjusted anchors on many glyphs
- Adjusted digit kerning
- Adjusted design of Kafs/Gafs/Lams/Meems
- Fixed font compression problems on OSX
- Changed design of U+061B
- Improved design of initial and medial U+067C (teh ring)
- Removed U+FEFB (lam/alef ligature)
- Tweaked positioning of some character combinations

### 2017-Apr-11 (SIL NRSI team) Awami Nastaliq Beta3
- Changed angle of vertical strokes on alef, lam, kaf, gaf, and tah forms
- Increased the line height by 20%
- Changed shapes of a number of letter forms: tah, bariyeh, feh (head shape), dal, reh, some meems, some heh-goals, isolate kaf/gaf, some initial jeems, pesh, dopesh, name marker
- Added Arabic style punctuation; cleaned up behavior of Arabic vs. Latin style punctuation
- Added visible versions of invisible characters such as directional markers, directional embedding, no-break spaces, etc.
- Added features: Full stop alternate (dash vs. dot) and Punctuation (default, Arabic, or Latin)
- Added 06CE - yeh with small V; 06D5 - Ae
- Adjust size of spaces to match rescaling that happened in beta-2 version
- Fixed bugs in hamza feature
- Cleaned up positions of diacritics

### 2016-Dec-7 (SIL NRSI team) Awami Nastaliq Beta2
- Increased font size by 15%
- Redesigned seen forms
- Redesigned nuqtas, made a them little smaller and closer together
- Implemented feature to allow shorter kafs/gafs and some final forms (noon, seen, chotiyeh, bariyeh, qaf, meem, lam) when the sequences get very high
- Added feature to allow alternate position of V over lam
- Added Arabic style quote marks at a higher position than Latin
- Scaled subtending marks more appropriately
- Hand-tweaked some combinations to make more readable
- Added U+06B0 GAF WITH RING
- Added "salaam ulena" ligature
- Redesigned initial beh before meem
- Made nuqta positions on seens and sads more consistent
- Reworked ain connections
- Fixed shape of Arabic 4 and 5
- Adjusted various letter shapes

### 2016-Aug-1 (SIL NRSI team) Awami Nastaliq Beta1
- Beta1 release based on Alpha2 feedback
- Additional characters and features added

### 2016-May-16 (SIL NRSI team) Awami Nastaliq Alpha2
- Alpha2 release based on Alpha1 feedback
- Additional characters and features added

### 2015-Dec-04 (SIL NRSI team) Awami Nastaliq Alpha1
- Preliminary design font for initial feedback

### 2014-Sep-10 (SIL NRSI team) Awami Nastaliq Preliminary work
- Preliminary design of isolate characters


