---
title: Awami Nastaliq - Honorific ligatures
fontversion: 3.400
---

Unicode has a number of honorific ligatures. The below chart should aid in understanding in what context they should be used. As new characters, applications may have problems with rendering them in right-to-left text. In some cases, you can correct reading order problems by inserting U+200F RIGHT-TO-LEFT MARK after the honorific ligature.

Unicode Name</br>ARABIC LIGATURE ... (for prophets) | USV | Glyph | Meaning
------------- | --- | --- | ------------- 
ALAYHI AS-SALAAM | FD47 | <span class='awami-R normal'>&#xFD47;</span>  | Peace be upon him.</br>(The normal honorific used after a prophet's or an Archangel's name.)
ALAYHIM AS-SALAAM | FD48 | <span class='awami-R normal'>&#xFD48;</span>  | Peace be upon them (masculine plural).</br>(Used for two or more prophets.)
ALAYHIMAA AS-SALAAM | FD49 | <span class='awami-R normal'>&#xFD49;</span>  | Peace be upon them (both).</br>(Used for prophets and angels.)
ALAYHAA AS-SALAAM | FD4D | <span class='awami-R normal'>&#xFD4D;</span>  | Peace be upon her.</br>(Used after the name of a woman who was the mother of a prophet.)

## 

Unicode Name</br>ARABIC LIGATURE ... (for companions) | USV | Glyph | Meaning
------------- | --- | --- | ------------- 
RADI ALLAAHU ANH | FD41 | <span class='awami-R normal'>&#xFD41;</span>  | May God be pleased with him.</br>(Used for companions of the prophet.)
RADI ALLAAHU ANHAA | FD42 | <span class='awami-R normal'>&#xFD42;</span>  | May God be pleased with her.</br>(Used for companions of the prophet, and in some regions for others such as Mary or Jesus’ apostles.)
RADI ALLAAHU ANHUM | FD43 | <span class='awami-R normal'>&#xFD43;</span> | May God be pleased with them (masculine plural, but can be used for a mixed group of men and women).</br>(Used for companions of the prophet.)
RADI ALLAAHU ANHUMAA | FD44 | <span class='awami-R normal'>&#xFD44;</span> | May God be pleased with them (both).</br>(Used for companions of the prophet.)
RADI ALLAAHU ANHUNNA | FD45 | <span class='awami-R normal'>&#xFD45;</span>  | May God be pleased with them (feminine).</br>(Used for companions of the prophet.)

## 

Unicode Name</br>ARABIC LIGATURE ... | USV | Glyph | Meaning
------------- | --- | --- | ------------- 
RAHMATU ALLAAHI ALAYHIM | FBC6 | <span class='awami-R normal'>&#xFBC6; </span>  | May God’s mercy be upon them (masculine plural).</br>(Used for relatives or students of companions of the prophet.)
RAHMATU ALLAAHI ALAYHIMAA | FBC7 | <span class='awami-R normal'>&#xFBC7;</span> | May God’s mercy be upon them (masculine and feminine plural).</br>(Used for relatives or students of companions of the prophet.)
RAHIMAHU ALLAAH | FD40 | <span class='awami-R normal'>&#xFD40;</span>  | May God’s mercy be upon him.</br>(Used for relative(s) or student(s) of companions of the prophet. Can be for any believer who has passed away.)
RAHIMAHUM ALLAAH | FD4F | <span class='awami-R normal'>﵏ </span>  | God have mercy upon them (masculine).</br>(Used for widely recognized scholars. Also used for ordinary believers.)
RAHMATU ALLAAHI ALAYH | FD90 | <span class='awami-R normal'>&#xFD90;</span> | May God’s mercy be upon him (masculine singular).</br>(Used for relative or student of companions of the prophet.)
RAHMATU ALLAAHI ALAYHAA | FD91 | <span class='awami-R normal'>&#xFD91;</span> | May God’s mercy be upon her (feminine singular).</br>(Used for relative or student of companions of the prophet.)
SALLALLAHOU ALAYHE WASALLAM | FDFA | <span class='awami-R normal'>&#xFDFA;</span> | The blessings and peace of God be upon him. </br>(Used after the name of a major prophet, especially the prophet of Islam.)
JALLAJALALOUHOU | FDFB | <span class='awami-R normal'>&#xFDFB;</span> | May His glory be glorified.</br>(Used after the name of God.)
BISMILLAH AR-RAHMAN AR-RAHEEM | FDFD | <span class='awami-R normal'>&#xFDFD;</span> | In the name of God, the most merciful, the most compassionate.</br>(Used as the opening of each action in order to receive blessing from God.)
SUBHAANAHU WA TAAALAA | FDFE | <span class='awami-R normal'>&#xFDFE;</span> | May He be praised and exalted (Glorified and Lofty).</br>(The most common honorific for God.)
AZZA WA JALL | FDFF | <span class='awami-R normal'>﷿ </span> | The Glorified/Exalted/Mighty and Sublime (Prestigious and Majestic).</br>(The second most common honorific for God.)


<!-- PRODUCT SITE ONLY
[font id='awami' face='AwamiNastaliq-Regular' bold='AwamiNastaliq-Bold' size='180%' lineheight='210%' rtl=1]
[font id='awamiL' face='AwamiNastaliq-Regular' bold='AwamiNastaliq-Bold' size='150%' ltr=1]
-->
