---
title: BJCree - Resources
fontversion: 7.000
---

## Requirements

These fonts are supported by all major operating systems (macOS, Windows, Linux-based, iOS, and Android), however the extent of that support depends on the individual OS and application.

## Installation

Install the fonts by decompressing the .zip archive and installing the fonts using the standard font installation process for .ttf (TrueType/OpenType) fonts for your platform. For additional tips see the help page on [Font installation](https://software.sil.org/fonts/installation).

## Keyboarding and character set support

These fonts do not include keyboards or other software for entering text. To type the symbols in these fonts use the keyboarding systems provided in your OS or use a separate utility. SIL’s [Keyman](https://keyman.com/) provides keyboards for over 2000 languages and works on all major desktop and mobile platforms. 

Some available Keyman keyboards:

- [BJ-OjiCree (Kingfisher)](https://keyman.com/keyboards/bj_oji_cree)
- [BJCreeUNI (east)](https://keyman.com/keyboards/bj_cree_east)
- [CreeBoard](https://keyman.com/keyboards/bj_cree_east_james_bay)
- [Naskapi (Classic)](https://keyman.com/keyboards/bj_naskapi_classic)
- [Naskapi (Common)](https://keyman.com/keyboards/bj_naskapi_common)
- [Swampy Cree (Tataskweyak)](https://keyman.com/keyboards/bj_mista_wasaha_cree)
- [Western Cree (TH-Woods)](https://keyman.com/keyboards/bj_cree_woods)


For information on other keyboarding options see the overview at [Other Input Methods](https://writingsystems.info/topics/input/other-input-methods/).

See [Character set support](charset.md) for details of the Unicode characters supported by these fonts.

## Rendering and application support

These fonts will work normally like any other fonts in most applications. 

## Web fonts

Web font versions of these fonts (in WOFF and WOFF2 formats) are available in the `web` folder. These can be copied to a web server and used as fonts on web pages. A very basic HTML/CSS demo page is also included. For more information on the options and techniques available for using these fonts on web pages see [Using SIL Fonts on Web Pages](http://software.sil.org/fonts/webfonts).

## Text conversion

These fonts are encoded according to [The Unicode Standard](https://unicode.org). If you have text that uses a legacy, non-Unicode encoding there are tools that can help you convert that text for use with Unicode fonts. See [Encoding Conversion](https://writingsystems.info/topics/encoding/encoding-conversion/), and review the resources section on that page.
