# Attachment Point Analysis

This document describes each of the attachment points.

| AP Name | Description                                          |
| ------- | ---------------------------------------------------- |
| LR      | Below right aligned base                             |
| LN      | Below centred base, only for those centring coengs   |
| LC      | Below centred base for centring wide coengs          |
| LX      | Mark attachment right aligned. Corresponds to LR     |
| LA      | Mark attachment centred. Corresponds to LC           |
| UR      | Above right aligned base                             |
| UC      | Above centred base                                   |
| UX      | Mark attachment right aligned. Corresponds to UR     |
| UA      | Mark attachment centred. Corresponds to UC           |
| LR\_1   | Below right aligned first ligature component         |
| LR\_2   | Below right aligned second ligature component        |
| LC\_1   | Below centred first ligature component               |
| LC\_2   | Below centred second ligature component              |
| UR\_1   | Above right aligned first ligature component         |
| UR\_2   | Above right aligned second ligature component        |
| UC\_1   | Above centred first ligature component               |
| UC\_2   | Above centred second ligature component              |
| \_LR    | Mark attachment to base: LR, LR\_1, LR\_2            |
| \_LC    | Mark attachment to base: LC, LN, LC\_1, LC\_2        |
| \_LA    | Mark attachment to mark: LA                          |
| \_LX    | Mark attachment to mark: LX                          |
| \_UR    | Mark attachment to base: UR, UR\_1, UR\_2            |
| \_UC    | Mark attachment to base: UC, UC\_1, UC\_2            |
| \_UA    | Mark attachment to mark: UA                          |
| \_UX    | Mark attachment to mark: UX                          |
| LH      | Latin cedilla alignment                              |
| LL      | Latin below base                                     |
| LU      | Latin above base                                     |
| \_LH    | Mark attachment to mark: LH                          |
| \_LL    | Mark attachment to mark: LL                          |
| \_LU    | Mark attachment to mark: LU                          |
