---
title: Busra - Character Set Support
fontversion: 9.200
---

This font supports over 500 characters from [The Unicode Standard](https://unicode.org/) as well as basic Latin and some [Private Use Area (PUA)](https://github.com/silnrsi/unicode-resources/blob/main/sil-pua/docs/pua-assignments.md) characters.

## Supported characters

The following character ranges are supported by this font:

Unicode block | Busra support
------------- | ---------------
C0 Controls and Basic Latin|U+0020..U+007E
C1 Controls and Latin-1 Supplement|U+00A0..U+00FF
Latin Extended-A|U+0102. U+0103, U+0110, U+0111, U+0128, U+0129, U+0131, U+0152, U+0153, U+0160, U+0161, U+0168, U+0169, U+0178, U+017D, U+017E
Latin Extended-B|U+0192, U+01A0, U+01A1, U+01AF, U+01B0
Spacing Modifier Letters|U+02C6, U+02C7, U+02D8.U+02DD
Combining Diacritical Marks|U+0300..U+0304, U+0306..U+030A, U+030C, U+031B, U+0323, U+0327, U+034F
Greek and Coptic|U+03C0
Khmer|U1780..U+17DD, U+17E0..U+17E9, U+17F0..U+17F9
Khmer Symbols|19E0..U+19FF
Latin Extended Additional|U+1EA0..U+1EF9
General Punctuation|U+2000..U+200D, U+2010..U+2015, U+2018..U+201A, U+201C..U+201E, U+2020..U+2022, U+2026..U+2029, U+202F, U+2030, U+2039, U+203A, U+2044, U+2060
Superscripts and Subscripts|U+2074
Currently Symbols|U+20AB, U+20AC
Letterlike Symbols|U+2122, U+2126
Mathematical Operators|U+2202, U+2206, U+220F, U+2211, U+2212, U+2215, U+2219, U+221A, U+221F, U+222B, U+2248, U+2260, U+2264, U+2265
Miscellaneous Technical|U+2308..U+2309
Control Pictures|U+2423
Geometric Shapes|U+25CA, U+25CC
PUA: Khmer Ornaments|U+EF00..U+EF09
PUA: Typograhic Marks|U+F130..U+F131
Alphabetic Presentation Forms|U+FB01, U+FB02
Variation Selectors|U+FE00..U+FE0F
Arabic Presentation Forms-B|U+FEFF (zero-width no-break space)
Specials|U+FFFC, U+FFFD

## Private-use (PUA) characters

There is a small number of private-use characters that are supported in this font. These conform to [SIL Global’s corporate registry](https://github.com/silnrsi/unicode-resources/tree/main/sil-pua) for usage of the Unicode private-use areas. Characters which are not yet in Unicode are shown below. 

### Khmer Ornaments

These are intended to be used as paragraph separators. They are not part of Unicode and there is no expectation that they will ever be included in the standard. Other fonts will not display them properly.

- U+EF00
- U+EF01
- U+EF02
- U+EF03
- U+EF04
- U+EF05
- U+EF06
- U+EF07
- U+EF08
- U+EF09

### Typographic Marks

- U+F130  FONT BASELINE AND SIDE-BEARING MARKER LEFT
- U+F131  FONT BASELINE AND SIDE-BEARING MARKER RIGHT
