
## Requirements

This font is supported by all major desktop operating systems (macOS, Windows, and Linux-based). However, it will have limited support on mobile devices such as iOS and Android. The extent of that support depends on the individual OS and application.

## Installation

Install the font by decompressing the .zip archive and installing the font using the standard font installation process for .ttf (TrueType/OpenType) fonts for your platform. For additional tips see the help page on [Font installation](https://software.sil.org/fonts/installation).

## Keyboarding and character set support

This font package does not include keyboards or other software for entering text. To type the symbols in this font, use the keyboarding systems provided in your OS or use a separate utility. [Keyman](https://keyman.com/) is a cross-platform keyboarding system; here are Khmer keyboards that are available:

- [Khmer Angkor Keyboard](https://keyman.com/keyboards/khmer_angkor)

- [Khmer SIL Keyboard](https://keyman.com/keyboards/sil_khmer)

See [Character set support](charset) for details of the Unicode characters supported by this font.

## Rendering and application support

These fonts will work normally like any other fonts in most applications. The application/OS will need to support OpenType in order to handle the many complexities of Khmer script.

These fonts also include OpenType features for variant forms and alternate character positioning. For information on the specific features available in these fonts see [Font features](features). 

If special font features are to be activated the application will need to provide a way to turn on the feature or choose the feature setting. Details of current application support, and specific techniques for activating features, are on the [Using Font Features](https://software.sil.org/fonts/features) help page.

Although the current font supports only OpenType, previous versions provided support for Graphite and AAT (Apple Advanced Typography) technologies. These older versions remain available from the [Mondulkiri package webpage](https://software.sil.org/mondulkiri).

## Web fonts

Web font versions of this font (in WOFF and WOFF2 formats) are available in the `web` folder. These can be copied to a web server and used as fonts on web pages. A very basic HTML/CSS demo page is also included. For more information on the options and techniques available for using these fonts on web pages see [Using SIL Fonts on Web Pages](https://software.sil.org/fonts/webfonts).


