---
title: Padauk - Resources
fontversion: 6.000
---

## Requirements

These fonts are supported by all major operating systems (macOS, Windows, Linux-based, iOS, and Android), however the extent of that support depends on the individual OS and application.

## Installation

Install the fonts by decompressing the .zip archive and installing the fonts using the standard font installation process for .ttf (TrueType/OpenType) fonts for your platform. For additional tips see the help page on [Font installation](https://software.sil.org/fonts/installation).

## Keyboarding and character set support

These fonts do not include keyboards or other software for entering text. To type the symbols in these fonts use the keyboarding systems provided in your OS or use a separate utility. SIL’s [Keyman](https://keyman.com/) provides keyboards for over 2000 languages and works on all major desktop and mobile platforms. One keyboard for for this font is the [Keyman Myanmar3 (SIL) keyboard](https://keyman.com/keyboards/sil_myanmar_my3). For information on other keyboarding options see the overview at [Keyboard and Tools (Writing Systems Technical Resources)](https://writingsystems.info/topics/input/keyboards-and-tools/).

See [Character set support](charset.md) for details of the Unicode characters supported by these fonts.

## Rendering and application support

Complex typographic issues such as the placement of combining marks or the formation of conjuncts and ligatures are handled by the font, provided you are running an application that provides an adequate level of support for OpenType shaping.

These fonts also include extensive OpenType features for character alternates and language-specific preferences. For information on the specific features available in these fonts see [Font features](features.md).

If special font features are to be activated the application will need to provide a way to turn on the feature or choose the feature setting. Details of current application support, and specific techniques for activating features, are on the [Using Font Features](https://software.sil.org/fonts/features) help page.

Although the current fonts support only OpenType, previous versions provided support for Graphite technologies. Graphite was supported through version 5.100. These older versions remain available from our [Previous Versions archive](https://software.sil.org/padauk/download/previous-versions).

## Web fonts

Web font versions of these fonts (in WOFF and WOFF2 formats) are available in the `web` folder. These can be copied to a web server and used as fonts on web pages. A very basic HTML/CSS demo page is also included. For more information on the options and techniques available for using these fonts on web pages see [Using SIL Fonts on Web Pages](https://software.sil.org/fonts/webfonts).

## Text conversion

These fonts are encoded according to [The Unicode Standard](https://unicode.org). If you have text that uses a legacy, non-Unicode encoding there are tools that can help you convert that text for use with Unicode fonts. See [Introduction to Text Conversion and Transliteration](https://scriptsource.org/entry/xlzd6n5aqt).
