<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:saxon="http://icl.com/saxon">
    <xsl:output method="html" version="4.0" encoding="utf-8"/>
    <!-- ===========================================================
      Parameters
      ========================================================= -->
    <!--
    The default is AfterFirstLine (immediately after the last item in the first line)
    The other possibilities are AfterFree (immediately after the free translation, on the same line)
       and UnderFree (on the line immediately after the free translation)
    -->
    <xsl:param name="sInterlinearSourceStyle">AfterFirstLine</xsl:param>
    <xsl:include href="XLingPapCommon.xsl"/>
    <xsl:include href="XLingPapCannedCommon.xsl"/>
    <!-- ===========================================================
      Global variables
      =========================================================== -->
    <xsl:variable name="sExampleCellPadding">padding-left: .25em</xsl:variable>
    <xsl:variable name="bAutomaticallyWrapInterlinears" select="//lingPaper/@automaticallywrapinterlinears"/>
    <xsl:variable name="sLdquo">&#8220;</xsl:variable>
    <xsl:variable name="sRdquo">&#8221;</xsl:variable>
    <xsl:variable name="bEndnoteRefIsDirectLinkToEndnote" select="'Y'"/>
    <!-- Following are now in the common transform; we put them here for that reason even though we do not use them. -->
    <xsl:param name="sPageWidth" select="'6in'"/>
    <xsl:param name="sPageHeight" select="'9in'"/>
    <xsl:param name="sPageInsideMargin" select="'1in'"/>
    <xsl:param name="sPageOutsideMargin" select="'.5in'"/>
    <xsl:variable name="pageLayoutInfo"/>
    <xsl:variable name="documentLayoutInfo"/>
    <!-- ===========================================================
      MAIN BODY
      =========================================================== -->
    <xsl:template match="//lingPaper">
        <html>
            <head>
                <!--                <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>-->
                <xsl:comment> generated by XLingPap1.xsl Version <xsl:value-of select="$sVersion"/>&#x20;</xsl:comment>
                <title>
                    <xsl:apply-templates select="$lingPaper/frontMatter/title/child::node()[name()!='endnote' and name()!='comment']" mode="contentOnly"/>
                </title>
                <style type="text/css">
               <xsl:text>.interblock { display: -moz-inline-box; display:inline-block; vertical-align: top; } </xsl:text>
                    <xsl:if test="$hasInterlinears='Y' and $lingPaper/@automaticallywrapinterlinears='yes'">
                    <xsl:text>
.itxwrap {
    display: flex;
    flex-wrap: wrap;
    gap: 0.25em;
}
.itxitem {
    display: grid;
    grid-template-rows: auto auto auto;
}
.ltr {
    text-align:left;
}
.rtl {
    direction:rtl;;
    unicode-bidi: bidi-override;
}
/* Thinking about just using the gap value
    .itxitem div {
    padding: 0 0.5em;
}*/
</xsl:text>
                    </xsl:if>
                </style>
                <xsl:call-template name="SetMetadata"/>
            </head>
            <body>
                <xsl:apply-templates select="frontMatter"/>
                <xsl:apply-templates select="*[name()!='frontMatter' and name()!='publishingInfo']"/>
            </body>
        </html>
    </xsl:template>
    <!-- ===========================================================
      FRONTMATTER
      =========================================================== -->
    <!--
        frontMatter
    -->
    <xsl:template match="frontMatter">
        <xsl:apply-templates select="title | subtitle | author | affiliation | emailAddress | presentedAt | date | version | ../publishingInfo/publishingBlurb"/>
        <xsl:apply-templates select="authorContactInfo | contents | acknowledgements | abstract | keywordsShownHere | preface"/>
    </xsl:template>
        <!--
      title
    -->
    <xsl:template match="title[ancestor::chapterInCollection]" mode="showChapterInCollectionTitle">
        <span>
            <xsl:apply-templates/>
        </span>
    </xsl:template>
    <xsl:template match="title[ancestor::chapterInCollection]" mode="showChapterInCollectionTitleContents">
        <span>
            <xsl:apply-templates mode="contents"/>
        </span>
    </xsl:template>
    <xsl:template match="title[ancestor::chapterInCollection]">
        <!-- do nothing -->
    </xsl:template>
    <xsl:template match="title">
        <center>
            <b>
                <big>
                    <big>
                        <big>
                            <!--              <xsl:value-of select="."/> -->
                            <xsl:apply-templates/>
                        </big>
                    </big>
                </big>
            </b>
        </center>
    </xsl:template>
    <xsl:template match="subtitle">
        <center>
            <b>
                <big>
                    <big>
                        <xsl:apply-templates/>
                    </big>
                </big>
            </b>
        </center>
    </xsl:template>
    <!--
      author
      -->
    <xsl:template match="author[ancestor::chapterInCollection]">
        <div>
            <i>
                <xsl:text>&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;</xsl:text>
                <xsl:apply-templates/>
            </i>
        </div>
    </xsl:template>
    <xsl:template match="author">
        <xsl:if test="position()=1">
            <br/>
        </xsl:if>
        <center>
            <i>
                <xsl:apply-templates/>
            </i>
        </center>
    </xsl:template>
    <!--
      affiliation
      -->
    <xsl:template match="affiliation[ancestor::chapterInCollection]">
        <div>
            <i>
                <xsl:text>&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;</xsl:text>
                <xsl:apply-templates/>
            </i>
        </div>
    </xsl:template>
    <xsl:template match="affiliation">
        <xsl:if test="position()=1">
            <br/>
        </xsl:if>
        <center>
            <i>
                <xsl:value-of select="."/>
            </i>
        </center>
    </xsl:template>
    <!--
        emailAddress
    -->
    <xsl:template match="emailAddress[ancestor::chapterInCollection]">
        <div>
            <i>
                <xsl:text>&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;</xsl:text>
                <xsl:apply-templates/>
            </i>
        </div>
    </xsl:template>
    <xsl:template match="emailAddress">
        <xsl:if test="position()=1">
            <br/>
        </xsl:if>
        <center>
            <i>
                <xsl:value-of select="."/>
            </i>
        </center>
    </xsl:template>
    <!--
      date or presentedAt
      -->
    <xsl:template match="date[ancestor::chapterInCollection] | presentedAt[ancestor::chapterInCollection]">
        <div>
            <i>
                <xsl:text>&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;</xsl:text>
                <xsl:apply-templates/>
            </i>
        </div>
    </xsl:template>
    <xsl:template match="date | presentedAt">
        <br/>
        <center>
            <small>
                <xsl:apply-templates/>
            </small>
        </center>
    </xsl:template>
    <!--
        version
    -->
    <xsl:template match="version[ancestor::chapterInCollection]">
        <div>
            <i>
                <xsl:text>&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;</xsl:text>
                <xsl:apply-templates/>
            </i>
        </div>
    </xsl:template>
    <xsl:template match="version">
        <center>
            <small>Version: <xsl:apply-templates/>
            </small>
        </center>
    </xsl:template>
    <!--
        publishingBlurb
    -->
    <xsl:template match="publishingInfo/publishingBlurb">
        <hr/>
        <div>
            <small>
                <xsl:apply-templates/>
            </small>
        </div>
    </xsl:template>
    <!--
        contents
    -->
    <xsl:template match="contents[not(ancestor::chapterInCollection)]">
        <hr/>
        <div>
            <center>
                <big>
                    <big>
                        <b>
                            <xsl:call-template name="OutputContentsLabel"/>
                        </b>
                    </big>
                </big>
            </center>
            <xsl:variable name="nLevel">
                <xsl:value-of select="number(@showLevel)"/>
            </xsl:variable>
            <ul>
                <xsl:choose>
                    <xsl:when test="$volumes and $publishingInfo/@showVolumeInContents='yes'">
                        <xsl:variable name="precedingVolume" select="preceding-sibling::*[1][name()='volume']"/>
                        <xsl:if test="$precedingVolume">
                            <xsl:call-template name="OutputVolumeInContents">
                                <xsl:with-param name="volume" select="$precedingVolume"/>
                            </xsl:call-template>
                        </xsl:if>
                        <xsl:if test="$publishingInfo/@whichVolumeToShowInContents='all'">
                            <xsl:call-template name="OutputContentsFrontMatter"/>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="OutputContentsFrontMatter"/>
                    </xsl:otherwise>
                </xsl:choose>
                <!-- part -->
                <xsl:if test="//part">
                    <xsl:for-each select="//part">
                        <xsl:choose>
                            <xsl:when test="$volumes and $publishingInfo/@showVolumeInContents='yes'">
                                <xsl:choose>
                                    <xsl:when test="$publishingInfo/@whichVolumeToShowInContents='all'">
                                        <xsl:call-template name="OutputContentsPart">
                                            <xsl:with-param name="nLevel" select="$nLevel"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="$publishingInfo/@whichVolumeToShowInContents=count(preceding-sibling::volume)+1">
                                        <xsl:call-template name="OutputContentsPart">
                                            <xsl:with-param name="nLevel" select="$nLevel"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="OutputContentsPart">
                                    <xsl:with-param name="nLevel" select="$nLevel"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:if>
                <xsl:if test="not(//part) and //chapter or not(//part) and //chapterInCollection">
                    <xsl:for-each select="//chapter | //chapterInCollection">
                        <xsl:choose>
                            <xsl:when test="$volumes and $publishingInfo/@showVolumeInContents='yes'">
                                <xsl:choose>
                                    <xsl:when test="$publishingInfo/@whichVolumeToShowInContents='all'">
                                        <xsl:call-template name="OutputAllChapterTOC">
                                            <xsl:with-param name="nLevel" select="$nLevel"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="$publishingInfo/@whichVolumeToShowInContents=count(preceding-sibling::volume)+1">
                                        <xsl:call-template name="OutputAllChapterTOC">
                                            <xsl:with-param name="nLevel" select="$nLevel"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="OutputAllChapterTOC">
                                    <xsl:with-param name="nLevel" select="$nLevel"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:if>
                <!-- section -->
                <xsl:if test="not(//part) and not(//chapter) and not(//chapterInCollection)">
                    <xsl:call-template name="OutputAllSectionTOC">
                        <xsl:with-param name="nLevel">
                            <xsl:value-of select="$nLevel"/>
                        </xsl:with-param>
                        <xsl:with-param name="nodesSection1" select="//section1[not(parent::appendix)]"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="$volumes and $publishingInfo/@showVolumeInContents='yes'">
                        <xsl:choose>
                            <xsl:when test="$publishingInfo/@whichVolumeToShowInContents='all'">
                                <xsl:call-template name="OutputContentsBackMatter">
                                    <xsl:with-param name="nLevel" select="$nLevel"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:when test="$publishingInfo/@whichVolumeToShowInContents=count($volumes)">
                                <xsl:call-template name="OutputContentsBackMatter">
                                    <xsl:with-param name="nLevel" select="$nLevel"/>
                                </xsl:call-template>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="OutputContentsBackMatter">
                            <xsl:with-param name="nLevel" select="$nLevel"/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </ul>
        </div>
    </xsl:template>
    <xsl:template match="contents[ancestor::chapterInCollection]">
        <hr/>
        <div>
            <center>
                <big>
                    <big>
                        <b>
                            <xsl:call-template name="OutputContentsLabel"/>
                        </b>
                    </big>
                </big>
            </center>
            <xsl:variable name="nLevel">
                <xsl:value-of select="number(@showLevel)"/>
            </xsl:variable>
            <ul>
                <xsl:for-each select="ancestor::chapterInCollection">
                    <xsl:apply-templates select="frontMatter/abstract | frontMatter/acknowledgements | frontMatter/preface" mode="contents"/>
                    <xsl:call-template name="OutputAllSectionTOC">
                        <xsl:with-param name="nLevel">
                            <xsl:value-of select="$nLevel"/>
                        </xsl:with-param>
                        <xsl:with-param name="nodesSection1" select="section1"/>
                    </xsl:call-template>
                    <xsl:call-template name="OutputChapterInCollectionBackMatterContents">
                        <xsl:with-param name="nLevel" select="$nLevel"/>
                    </xsl:call-template>
                </xsl:for-each>
            </ul>
        </div>
        <xsl:if test="count(following-sibling::*)=0">
            <hr/>
        </xsl:if>
    </xsl:template>
    <!--
      abstract and acknowledgements, preface and glossary
      -->
    <xsl:template match="abstract | acknowledgements | preface | glossary">
        <br/>
        <xsl:if test="not(name(preceding-sibling::*) = 'contents')">
            <hr/>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="parent::frontMatter">
                <center>
                    <b>
                        <big>
                            <big>
                                <xsl:choose>
                                    <xsl:when test="name(.)='abstract'">
                                        <xsl:variable name="sId">
                                            <xsl:call-template name="GetIdToUse">
                                                <xsl:with-param name="sBaseId" select="concat($sAbstractID,count(preceding-sibling::abstract))"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <a name="{$sId}">
                                            <xsl:call-template name="OutputAbstractLabel"/>
                                        </a>
                                    </xsl:when>
                                    <xsl:when test="name(.)='preface'">
                                        <xsl:variable name="sId">
                                            <xsl:call-template name="GetIdToUse">
                                                <xsl:with-param name="sBaseId" select="concat($sPrefaceID,count(preceding-sibling::preface))"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <a name="{$sId}">
                                            <xsl:call-template name="OutputPrefaceLabel"/>
                                        </a>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:variable name="sId">
                                            <xsl:call-template name="GetIdToUse">
                                                <xsl:with-param name="sBaseId" select="$sAcknowledgementsID"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <a name="{$sId}">
                                            <xsl:call-template name="OutputAcknowledgementsLabel"/>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </big>
                        </big>
                    </b>
                </center>
            </xsl:when>
            <xsl:when test="name(.)='glossary'">
                <xsl:variable name="iPos" select="count(preceding-sibling::glossary) + 1"/>
                <xsl:variable name="sId">
                    <xsl:call-template name="GetIdToUse">
                        <xsl:with-param name="sBaseId" select="concat($sGlossaryID,$iPos)"/>
                    </xsl:call-template>
                </xsl:variable>
                <a name="{$sId}"/>
                <xsl:call-template name="OutputChapTitle">
                    <xsl:with-param name="sTitle">
                        <xsl:call-template name="OutputGlossaryLabel"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- assume it is acknowledgments -->
                <xsl:variable name="sId">
                    <xsl:call-template name="GetIdToUse">
                        <xsl:with-param name="sBaseId" select="$sAcknowledgementsID"/>
                    </xsl:call-template>
                </xsl:variable>
                <a name="{$sId}"/>
                <xsl:call-template name="OutputChapTitle">
                    <xsl:with-param name="sTitle">
                        <xsl:call-template name="OutputAcknowledgementsLabel"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        <div style="margin-left: 0.5in; margin-right: 0.5in">
            <xsl:apply-templates/>
        </div>
        <xsl:if test="position() = last()">
            <hr/>
        </xsl:if>
    </xsl:template>
    <xsl:template match="abstract" mode="contents">
        <li>
            <xsl:variable name="sId">
                <xsl:call-template name="GetIdToUse">
                    <xsl:with-param name="sBaseId" select="concat($sAbstractID,count(preceding-sibling::abstract))"/>
                </xsl:call-template>
            </xsl:variable>
            <a href="#{$sId}">
                <xsl:call-template name="OutputAbstractLabel"/>
            </a>
        </li>
    </xsl:template>
    <xsl:template match="acknowledgements" mode="contents">
        <li>
            <xsl:variable name="sId">
                <xsl:call-template name="GetIdToUse">
                    <xsl:with-param name="sBaseId" select="$sAcknowledgementsID"/>
                </xsl:call-template>
            </xsl:variable>
            <a href="#{$sId}">
                <xsl:call-template name="OutputAcknowledgementsLabel"/>
            </a>
        </li>
    </xsl:template>
    <xsl:template match="preface" mode="contents">
        <li>
            <xsl:variable name="sId">
                <xsl:call-template name="GetIdToUse">
                    <xsl:with-param name="sBaseId" select="concat($sPrefaceID,count(preceding-sibling::preface))"/>
                </xsl:call-template>
            </xsl:variable>
            <a href="#{$sId}">
                <xsl:call-template name="OutputPrefaceLabel"/>
            </a>
        </li>
    </xsl:template>
    <xsl:template match="keywordsShownHere">
        <xsl:choose>
            <xsl:when test="parent::frontMatter">
                <div style="padding-top:12pt">
                    <xsl:attribute name="align">
                        <xsl:choose>
                            <xsl:when test="ancestor::chapterInCollection">
                                <xsl:text>left</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>center</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <xsl:variable name="sId">
                        <xsl:call-template name="GetKeywordsID"/>
                    </xsl:variable>
                    <a name="{$sId}"/>
                    <xsl:call-template name="OutputKeywordsLabel"/>
                    <xsl:call-template name="OutputKeywordsShownHere"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <hr size="3"/>
                <xsl:variable name="sId">
                    <xsl:call-template name="GetKeywordsID"/>
                </xsl:variable>
                <a name="{$sId}"/>
                <xsl:call-template name="OutputChapTitle">
                    <xsl:with-param name="sTitle">
                        <xsl:call-template name="OutputKeywordsLabel"/>
                    </xsl:with-param>
                </xsl:call-template>
                <div style="padding-top:12pt">
                    <xsl:call-template name="OutputKeywordsShownHere"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
      index
      -->
    <xsl:template match="index">
        <hr/>
        <!-- force line break so we can more effectively use a line-oriented differences tool -->
        <xsl:text>&#xA;</xsl:text>
        <a>
            <xsl:attribute name="name">
                <xsl:call-template name="CreateIndexID"/>
            </xsl:attribute>
        </a>
        <xsl:apply-templates/>
        <xsl:call-template name="OutputChapTitle">
            <xsl:with-param name="sTitle">
                <xsl:call-template name="OutputIndexLabel"/>
            </xsl:with-param>
        </xsl:call-template>
        <!-- process any paragraphs, etc. that may be at the beginning -->
        <xsl:apply-templates/>
        <!-- now process the contents of this index -->
        <xsl:variable name="sIndexKind">
            <xsl:choose>
                <xsl:when test="@kind">
                    <xsl:value-of select="@kind"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>common</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="OutputIndexTerms">
            <xsl:with-param name="sIndexKind" select="$sIndexKind"/>
            <xsl:with-param name="lang" select="$indexLang"/>
            <xsl:with-param name="terms" select="//lingPaper/indexTerms"/>
        </xsl:call-template>
    </xsl:template>
    <!--
      indexedItem or indexedRangeBegin
      -->
    <xsl:template match="indexedItem[not(ancestor::comment)] | indexedRangeBegin[not(ancestor::comment)]">
        <xsl:variable name="sTermId" select="@term"/>
        <a>
            <xsl:attribute name="name">
                <xsl:call-template name="CreateIndexedItemID">
                    <xsl:with-param name="sTermId" select="@term"/>
                </xsl:call-template>
            </xsl:attribute>
        </a>
    </xsl:template>
    <!--
      indexedRangeEnd
      -->
    <xsl:template match="indexedRangeEnd[not(ancestor::comment)]">
        <a>
            <xsl:attribute name="name">
                <xsl:call-template name="CreateIndexedItemID">
                    <xsl:with-param name="sTermId" select="@begin"/>
                </xsl:call-template>
            </xsl:attribute>
        </a>
    </xsl:template>
    <!--
      term
      -->
    <xsl:template match="term" mode="InIndex">
        <xsl:apply-templates/>
    </xsl:template>
    <!-- ===========================================================
      PARTS, CHAPTERS, SECTIONS, and APPENDICES
      =========================================================== -->
    <!--
      Part
      -->
    <xsl:template match="part">
        <hr size="3"/>
        <p>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <center>
                <big>
                    <big>
                        <big>
                            <big>
                                <big>
                                    <b>
                                        <xsl:element name="a">
                                            <xsl:attribute name="name">
                                                <xsl:value-of select="@id"/>
                                            </xsl:attribute>
                                            <xsl:apply-templates select="." mode="numberPart"/>
                                            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                                            <xsl:apply-templates select="secTitle"/>
                                        </xsl:element>
                                    </b>
                                </big>
                            </big>
                        </big>
                    </big>
                </big>
            </center>
        </p>
        <hr size="3"/>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <!--
      Chapter
      -->
    <xsl:template match="chapter | chapterBeforePart | chapterInCollection">
        <xsl:if test="name()='chapterInCollection' and not(preceding-sibling::*[1][name()='frontMatter'][preface]) and not(preceding-sibling::*[1][name()='secTitle'])">
            <hr size="3"/>
        </xsl:if>
        <xsl:call-template name="OutputChapTitle">
            <xsl:with-param name="sNumber">
                <xsl:call-template name="OutputChapterNumber"/>
            </xsl:with-param>
            <xsl:with-param name="sTitle">
                <xsl:choose>
                    <xsl:when test="name()='chapterInCollection'">
                        <xsl:apply-templates select="frontMatter/title" mode="showChapterInCollectionTitle"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="secTitle"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
            <xsl:with-param name="fSecTitleApplyTemplates" select="'Y'"/>
        </xsl:call-template>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <!--
        Sections
    -->
    <xsl:template match="section1">
        <h1>
            <xsl:call-template name="OutputSection"/>
        </h1>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section2">
       <xsl:call-template name="HandleOutputSection">
           <xsl:with-param name="sLevel" select="'h2'"/>
       </xsl:call-template>
       <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section3">
        <xsl:call-template name="HandleOutputSection">
            <xsl:with-param name="sLevel" select="'h3'"/>
        </xsl:call-template>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section4">
        <xsl:call-template name="HandleOutputSection">
            <xsl:with-param name="sLevel" select="'h4'"/>
        </xsl:call-template>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section5">
        <xsl:call-template name="HandleOutputSection">
            <xsl:with-param name="sLevel" select="'h5'"/>
            <xsl:with-param name="sFontSize" select="'100%'"/>
        </xsl:call-template>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section6">
        <xsl:call-template name="HandleOutputSection">
            <xsl:with-param name="sLevel" select="'h6'"/>
            <xsl:with-param name="sFontSize" select="'100%'"/>
        </xsl:call-template>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <!--
      Appendix
      -->
    <xsl:template match="appendix">
        <xsl:if test="not(ancestor::chapterInCollection)">
            <hr size="3"/>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="//chapter | //chapterInCollection">
                <xsl:call-template name="OutputChapTitle">
                    <xsl:with-param name="sNumber">
                        <xsl:for-each select="ancestor::chapterInCollection">
                            <xsl:apply-templates select="." mode="numberChapter"/>
                            <xsl:text>.</xsl:text>
                        </xsl:for-each>
                        <xsl:apply-templates select="." mode="numberAppendix"/>
                    </xsl:with-param>
                    <xsl:with-param name="sTitle">
                        <xsl:apply-templates select="secTitle"/>
                    </xsl:with-param>
                    <xsl:with-param name="fSecTitleApplyTemplates" select="'Y'"/>
                </xsl:call-template>
                <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
            </xsl:when>
            <xsl:otherwise>
                <h1>
                    <xsl:call-template name="OutputSection"/>
                </h1>
                <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        secTitle
    -->
    <xsl:template match="secTitle">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="secTitle" mode="contents">
        <xsl:apply-templates select="child::node()[name()!='endnote']" mode="contents"/>
    </xsl:template>
    <!--
        sectionRef
    -->
    <xsl:template match="sectionRef">
        <xsl:call-template name="OutputAnyTextBeforeSectionRef"/>
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showTitle"/>
        </xsl:call-template>
        <a href="#{@sec}">
            <xsl:call-template name="DoSectionRef"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showTitle"/>
        </xsl:call-template>
    </xsl:template>
    <!--
        appendixRef
    -->
    <xsl:template match="appendixRef">
        <xsl:call-template name="OutputAnyTextBeforeAppendixRef"/>
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showTitle"/>
        </xsl:call-template>
        <a href="#{@app}">
            <xsl:call-template name="DoAppendixRef"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showTitle"/>
        </xsl:call-template>
    </xsl:template>
    <!--
        genericRef
    -->
    <xsl:template match="genericRef">
        <xsl:element name="a">
            <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
                <xsl:value-of select="@gref"/>
            </xsl:attribute>
            <xsl:call-template name="OutputGenericRef"/>
        </xsl:element>
    </xsl:template>
    <!--
      genericTarget
   -->
    <xsl:template match="genericTarget">
        <a name="{@id}"/>
    </xsl:template>
    <!--
      link
      -->
    <xsl:template match="link">
        <xsl:element name="a">
            <xsl:attribute name="href">
                <xsl:value-of select="@href"/>
            </xsl:attribute>
            <xsl:if test="@openInNewTab='yes'">
                <xsl:attribute name="target">
                    <xsl:text>_blank</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <!-- ===========================================================
      PARAGRAPH
      =========================================================== -->
    <xsl:template match="p | pc">
        <!--    <xsl:if test="parent::endnote and not(position()=1)">
      <tr>
        <td/>
        <td>
          <p>
            <xsl:apply-templates/>
          </p>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="not(parent::endnote) or position()=1">
    -->
        <p>
            <xsl:if test="name(.)='pc'">
                <xsl:attribute name="class">pc</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </p>
        <!--    </xsl:if> -->
    </xsl:template>
    <!-- ===========================================================
        Hanging indent paragraph
        =========================================================== -->
    <xsl:template match="hangingIndent">
        <xsl:variable name="sThisInitialIndent" select="normalize-space(@initialIndent)"/>
        <xsl:variable name="sThisHangingIndent" select="normalize-space(@hangingIndent)"/>
        <p>
            <xsl:attribute name="style">
                <xsl:call-template name="OutputCssSpecial">
                    <xsl:with-param name="fDoStyleAttribute" select="'N'"/>
                </xsl:call-template>
                <xsl:text>; padding-left:</xsl:text>
                <xsl:choose>
                    <xsl:when test="string-length($sThisHangingIndent) &gt; 0">
                        <xsl:value-of select="$sThisHangingIndent"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>1em</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>; text-indent:-</xsl:text>
                <xsl:choose>
                    <xsl:when test="string-length($sThisInitialIndent) &gt; 0">
                        <xsl:value-of select="$sThisInitialIndent"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="string-length($sThisHangingIndent) &gt; 0">
                                <xsl:value-of select="$sThisHangingIndent"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>1em</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    <!-- ===========================================================
        Annotation reference (part of an annotated bibliography)
        =========================================================== -->
    <xsl:template match="annotationRef">
        <div style="padding-left:0.25in">
            <xsl:for-each select="key('RefWorkID',@citation)">
                <xsl:call-template name="DoRefWork">
                    <xsl:with-param name="works" select="."/>
                    <xsl:with-param name="bDoTarget" select="'N'"/>
                </xsl:call-template>
            </xsl:for-each>
        </div>
        <xsl:call-template name="DoNestedAnnotations">
            <xsl:with-param name="sList" select="@annotation"/>
        </xsl:call-template>
    </xsl:template>
    <!-- ===========================================================
      QUOTES
      =========================================================== -->
    <xsl:template match="q">"<xsl:apply-templates/>"</xsl:template>
    <xsl:template match="blockquote">
        <div style="margin-left:.5in;margin-right:.5in">
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!-- ===========================================================
        PROSE TEXT
        =========================================================== -->
    <xsl:template match="prose-text">
        <div>
            <xsl:attribute name="style">
                <xsl:text>margin-left:.5in;margin-right:.5in;</xsl:text>
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!-- ===========================================================
      LISTS
      =========================================================== -->
    <xsl:template match="ol">
        <xsl:variable name="NestingLevel">
            <xsl:choose>
                <xsl:when test="ancestor::endnote">
                    <xsl:value-of select="count(ancestor::ol[not(descendant::endnote)])"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="count(ancestor::ol)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:element name="ol">
            <xsl:attribute name="style">
                <xsl:text>list-style-type:</xsl:text>
                <xsl:variable name="sNumberFormat" select="@numberFormat"/>
                <xsl:choose>
                    <xsl:when test="string-length($sNumberFormat) &gt; 0">
                        <xsl:choose>
                            <xsl:when test="$sNumberFormat='1'">
                                <xsl:text>decimal</xsl:text>
                            </xsl:when>
                            <xsl:when test="$sNumberFormat='A'">
                                <xsl:text>upper-alpha</xsl:text>
                            </xsl:when>
                            <xsl:when test="$sNumberFormat='a'">
                                <xsl:text>lower-alpha</xsl:text>
                            </xsl:when>
                            <xsl:when test="$sNumberFormat='I'">
                                <xsl:text>upper-roman</xsl:text>
                            </xsl:when>
                            <xsl:when test="$sNumberFormat='i'">
                                <xsl:text>lower-roman</xsl:text>
                            </xsl:when>
                            <xsl:when test="$sNumberFormat='01'">
                                <xsl:text>decimal-leading-zero</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>decimal</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="($NestingLevel mod 3)=0">
                                <xsl:text>decimal</xsl:text>
                            </xsl:when>
                            <xsl:when test="($NestingLevel mod 3)=1">
                                <xsl:text>lower-alpha</xsl:text>
                            </xsl:when>
                            <xsl:when test="($NestingLevel mod 3)=2">
                                <xsl:text>lower-roman</xsl:text>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>; </xsl:text>
                <xsl:call-template name="DoType"/>
                <xsl:call-template name="OutputCssSpecial">
                    <xsl:with-param name="fDoStyleAttribute" select="'N'"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <xsl:template match="ul">
        <ul>
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </ul>
    </xsl:template>
    <xsl:template match="li">
        <li>
            <xsl:if test="@id">
                <a name="{@id}"/>
            </xsl:if>
            <xsl:apply-templates/>
        </li>
    </xsl:template>
    <xsl:template match="dl">
        <dl>
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </dl>
    </xsl:template>
    <xsl:template match="dt">
        <dt>
            <xsl:apply-templates/>
        </dt>
    </xsl:template>
    <xsl:template match="dd">
        <dd>
            <xsl:if test="example">
                <xsl:attribute name="style">
                    <xsl:text>margin-left:0.0pt</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </dd>
    </xsl:template>
    <!-- ===========================================================
      EXAMPLES
      =========================================================== -->
    <xsl:template match="example">
        <div>
            <xsl:choose>
                <xsl:when test="ancestor::table[@border &gt; 0]">
                    <xsl:attribute name="style">
                        <xsl:text>margin-left: 0.175in; margin-right: 0.175in</xsl:text>
                    </xsl:attribute>
                </xsl:when>
                <xsl:when test="ancestor::table">
                    <xsl:attribute name="style">
                        <xsl:text>margin-left: 0.2in; margin-right: 0.175in</xsl:text>
                    </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="style">
                        <xsl:text>margin-left: 0.25in; margin-right: 0.25in</xsl:text>
                        <xsl:if test="preceding-sibling::*[1][name()='example']">
                            <!-- add extra space between this example and the previous one -->
                            <xsl:text>; margin-top:.2in</xsl:text>
                        </xsl:if>
                    </xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <table>
                <tr>
                    <xsl:variable name="bListsShareSameCode">
                        <xsl:call-template name="DetermineIfListsShareSameISOCode"/>
                    </xsl:variable>
                    <td valign="top">
                        <xsl:element name="a">
                            <xsl:attribute name="name">
                                <xsl:value-of select="@num"/>
                            </xsl:attribute>
                            <xsl:call-template name="AddAnyTitleAttribute">
                                <xsl:with-param name="sId" select="@num"/>
                            </xsl:call-template>
                            <xsl:text>(</xsl:text>
                            <xsl:call-template name="GetExampleNumber">
                                <xsl:with-param name="example" select="."/>
                            </xsl:call-template>
                            <xsl:text>)</xsl:text>
                            <xsl:if test="not(listDefinition) and not(definition)">
                                <xsl:call-template name="OutputExampleLevelISOCode">
                                    <xsl:with-param name="bListsShareSameCode" select="$bListsShareSameCode"/>
                                    <xsl:with-param name="sIsoCode">
                                        <xsl:call-template name="GetISOCode">
                                            <xsl:with-param name="originalContext" select="."/>
                                        </xsl:call-template>
                                    </xsl:with-param>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:element>
                    </td>
                    <td>
                        <xsl:variable name="myFirstChild" select="child::*[position()=1]"/>
                        <xsl:choose>
                            <xsl:when test="name($myFirstChild) = 'exampleHeading' and substring(name(child::*[position()=2]), 1, 4)='list'">
                                <xsl:apply-templates select="exampleHeading" mode="noInitialSpace"/>
                                <table cellpadding="0pt" cellspacing="0pt">
                                    <xsl:apply-templates select="listInterlinear | listWord | listSingle | listDefinition">
                                        <xsl:with-param name="bListsShareSameCode" select="$bListsShareSameCode"/>
                                    </xsl:apply-templates>
                                </table>
                            </xsl:when>
                            <xsl:when test="name($myFirstChild) = 'exampleHeading' and name(child::*[position()=2])='table'">
                                <xsl:apply-templates select="exampleHeading"/>
                                <xsl:apply-templates select="table"/>
                            </xsl:when>
                            <xsl:when test="substring(name($myFirstChild), 1, 4)='list'">
                                <table cellpadding="0pt" cellspacing="0pt">
                                    <xsl:apply-templates>
                                        <xsl:with-param name="bListsShareSameCode" select="$bListsShareSameCode"/>
                                    </xsl:apply-templates>
                                </table>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:apply-templates/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                </tr>
            </table>
        </div>
    </xsl:template>
    <!--
      word
      -->
    <xsl:template match="word">
        <table cellpadding="0pt" cellspacing="0pt">
            <tr>
                <xsl:for-each select="(langData | gloss)">
                    <td>
                        <xsl:apply-templates select="."/>
                    </td>
                </xsl:for-each>
            </tr>
            <xsl:apply-templates select="word"/>
        </table>
    </xsl:template>
    <xsl:template match="word[ancestor::listWord]">
        <xsl:param name="bListsShareSameCode"/>
        <tr>
            <td>
                <!-- letter column -->
            </td>
            <xsl:if test="contains($bListsShareSameCode,'N')">
                <td>
                    <!-- ISO code -->
                </td>
            </xsl:if>
            <xsl:call-template name="HandleListWordLangDataOrGloss"/>
        </tr>
        <xsl:apply-templates select="word">
            <xsl:with-param name="bListsShareSameCode" select="$bListsShareSameCode"/>
        </xsl:apply-templates>
    </xsl:template>
    <xsl:template match="word[parent::word and not(ancestor::listWord)]">
        <tr>
            <xsl:for-each select="(langData | gloss)">
                <td>
                    <xsl:apply-templates select="."/>
                </td>
            </xsl:for-each>
        </tr>
        <xsl:apply-templates select="word"/>
    </xsl:template>
    <!--
      listWord
      -->
    <xsl:template match="listWord">
        <xsl:param name="bListsShareSameCode"/>
        <!--    <table> -->
        <tr>
            <td>
                <xsl:element name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="@letter"/>
                    </xsl:attribute>
                    <xsl:call-template name="AddAnyTitleAttribute">
                        <xsl:with-param name="sId" select="@letter"/>
                    </xsl:call-template>
                    <xsl:apply-templates select="." mode="letter"/>.</xsl:element>
            </td>
            <xsl:call-template name="HandleListWordLangDataOrGloss">
                <xsl:with-param name="bListsShareSameCode" select="$bListsShareSameCode"/>
            </xsl:call-template>
        </tr>
        <xsl:apply-templates select="word">
            <xsl:with-param name="bListsShareSameCode" select="$bListsShareSameCode"/>
        </xsl:apply-templates>
        <!--    </table> -->
    </xsl:template>
    <!--
      single
      -->
    <xsl:template match="single">
        <table cellpadding="0pt" cellspacing="0pt">
            <tr>
                <td>
                    <xsl:apply-templates/>
                </td>
            </tr>
        </table>
    </xsl:template>
    <!--
      listSingle
      -->
    <xsl:template match="listSingle">
        <xsl:param name="bListsShareSameCode"/>
        <!--        <table cellpadding="0pt" cellspacing="0pt"> -->
        <tr>
            <td valign="top">
                <xsl:element name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="@letter"/>
                    </xsl:attribute>
                    <xsl:call-template name="AddAnyTitleAttribute">
                        <xsl:with-param name="sId" select="@letter"/>
                    </xsl:call-template>
                    <xsl:apply-templates select="." mode="letter"/>.</xsl:element>
            </td>
            <xsl:if test="$lingPaper/@showiso639-3codeininterlinear='yes' or ancestor-or-self::example/@showiso639-3codes='yes'">
                <xsl:if test="contains($bListsShareSameCode,'N')">
                    <td>
                        <xsl:call-template name="OutputISOCodeInExample">
                            <xsl:with-param name="bOutputBreak" select="'N'"/>
                        </xsl:call-template>
                    </td>
                </xsl:if>
            </xsl:if>
            <td>
                <xsl:attribute name="style">
                    <xsl:value-of select="$sExampleCellPadding"/>
                </xsl:attribute>
                <xsl:for-each select="(langData | gloss | interlinearSource)">
                    <xsl:apply-templates select="."/>
                    <xsl:if test="position()!=last()">
                        <xsl:text>&#xa0;&#xa0;</xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </td>
        </tr>
        <!--        </table> -->
    </xsl:template>
    <!--
      interlinear
      -->
    <xsl:template match="interlinear">
        <xsl:choose>
            <xsl:when test="parent::interlinear-text">
                <div id="{@text}" style="font-size:smaller;font-weight:bold">
                    <xsl:call-template name="GetInterlinearTextShortTitleAndNumber"/>
                </div>
                <div style="margin-left:0.125in">
                    <xsl:call-template name="OutputInterlinear">
                        <xsl:with-param name="mode" select="'NoTextRef'"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="OutputInterlinear"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        interlinearRef
    -->
    <xsl:template match="interlinearRef">
        <xsl:variable name="originalContext" select="."/>
        <xsl:for-each select="key('InterlinearReferenceID',@textref)[1]">
            <xsl:apply-templates>
                <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:apply-templates>
        </xsl:for-each>
    </xsl:template>
    <!--
        interlinearRef with endnote(s) for backmatter
    -->
    <xsl:template match="interlinearRef" mode="backMatter">
        <xsl:variable name="originalContext" select="."/>
        <xsl:for-each select="key('InterlinearReferenceID',@textref)[1]">
            <xsl:apply-templates select="descendant::endnote" mode="backMatter">
                <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:apply-templates>
        </xsl:for-each>
    </xsl:template>
    <!--
        interlinearRefCitation
    -->
    <xsl:template match="interlinearRefCitation[@showTitleOnly='short' or @showTitleOnly='full']">
        <!-- we do not show any brackets when these options are set -->
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showTitleOnly"/>
        </xsl:call-template>
        <a>
            <xsl:call-template name="DoInterlinearTextReferenceLink">
                <xsl:with-param name="sRef" select="@textref"/>
                <xsl:with-param name="sExtension" select="'htm'"/>
            </xsl:call-template>
            <xsl:call-template name="DoInterlinearRefCitationShowTitleOnly"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showTitleOnly"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="interlinearRefCitation">
        <xsl:if test="not(@bracket) or @bracket='both' or @bracket='initial'">
            <xsl:text>[</xsl:text>
        </xsl:if>
        <xsl:variable name="interlinear" select="key('InterlinearReferenceID',@textref)"/>
        <xsl:choose>
            <xsl:when test="name($interlinear)='interlinear-text'">
                <a>
                    <xsl:call-template name="DoInterlinearTextReferenceLink">
                        <xsl:with-param name="sRef" select="@textref"/>
                        <xsl:with-param name="sExtension" select="'htm'"/>
                    </xsl:call-template>
                    <xsl:choose>
                        <xsl:when test="$interlinear/textInfo/shortTitle and string-length($interlinear/textInfo/shortTitle) &gt; 0">
                            <xsl:apply-templates select="$interlinear/textInfo/shortTitle/child::node()[name()!='endnote']"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="$interlinear/textInfo/textTitle/child::node()[name()!='endnote']"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="DoInterlinearRefCitation">
                    <xsl:with-param name="sRef" select="@textref"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not(@bracket) or @bracket='both' or @bracket='final'">
            <xsl:text>]</xsl:text>
        </xsl:if>
    </xsl:template>
    <!--
      lineGroup
      -->
    <xsl:template match="lineGroup">
        <xsl:param name="originalContext"/>
        <xsl:choose>
            <xsl:when test="$bAutomaticallyWrapInterlinears='yes'">
                <xsl:call-template name="DoWrappableInterlinearLineGroup">
                    <xsl:with-param name="originalContext" select="$originalContext"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="DoInterlinearLineGroup">
                    <xsl:with-param name="originalContext" select="$originalContext"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="lineGroup" mode="NoTextRef">
        <xsl:choose>
            <xsl:when test="$bAutomaticallyWrapInterlinears='yes'">
                <xsl:call-template name="DoWrappableInterlinearLineGroup">
                    <xsl:with-param name="mode" select="'NoTextRef'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="DoInterlinearLineGroup">
                    <xsl:with-param name="mode" select="'NoTextRef'"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
      line
      -->
    <xsl:template match="line">
        <xsl:param name="originalContext"/>
        <tr>
            <xsl:call-template name="DoInterlinearLine">
                <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:call-template>
            <xsl:if test="count(preceding-sibling::line) = 0 and not(parent::lineGroup[preceding-sibling::*[1][name(.)='lineGroup']])">
                <xsl:if test="$sInterlinearSourceStyle='AfterFirstLine'">
                    <xsl:call-template name="OutputInterlinearTextReference">
                        <xsl:with-param name="sRef" select="../../@textref"/>
                        <xsl:with-param name="sSource" select="../../interlinearSource"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:if>
        </tr>
    </xsl:template>
    <xsl:template match="line" mode="NoTextRef">
        <tr>
            <xsl:call-template name="DoInterlinearLine"/>
        </tr>
    </xsl:template>
    <!--
      conflatedLine
      -->
    <xsl:template match="conflatedLine">
        <tr style="line-height:87.5%">
            <td valign="top">
                <xsl:if test="name(..)='interlinear' and position()=1">
                    <xsl:call-template name="OutputExampleNumber"/>
                </xsl:if>
            </td>
            <xsl:apply-templates/>
        </tr>
    </xsl:template>
    <!--
      lineSet
      -->
    <xsl:template match="lineSet">
        <xsl:choose>
            <xsl:when test="name(..)='conflation'">
                <tr>
                    <xsl:if test="@letter">
                        <td valign="top">
                            <xsl:element name="a">
                                <xsl:attribute name="name">
                                    <xsl:value-of select="@letter"/>
                                </xsl:attribute>
                                <xsl:apply-templates select="." mode="letter"/>.</xsl:element>
                        </td>
                    </xsl:if>
                    <td>
                        <table>
                            <xsl:apply-templates/>
                        </table>
                    </td>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <td>
                    <table>
                        <xsl:apply-templates/>
                    </table>
                </td>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
      conflation
      -->
    <xsl:template match="conflation">
        <xsl:variable name="sCount" select="count(descendant::*[lineSetRow])"/>
        <!--  sCount = <xsl:value-of select="$sCount"/> -->
        <td>
            <img align="middle">
                <xsl:attribute name="src">
                    <xsl:text>LeftBrace</xsl:text>
                    <xsl:value-of select="$sCount"/>
                    <xsl:text>.png</xsl:text>
                </xsl:attribute>
            </img>
        </td>
        <td>
            <table>
                <xsl:apply-templates/>
            </table>
        </td>
        <td>
            <img align="middle">
                <xsl:attribute name="src">
                    <xsl:text>RightBrace</xsl:text>
                    <xsl:value-of select="$sCount"/>
                    <xsl:text>.png</xsl:text>
                </xsl:attribute>
            </img>
        </td>
    </xsl:template>
    <!--
      lineSetRow
      -->
    <xsl:template match="lineSetRow">
        <tr style="line-height:87.5%">
            <xsl:for-each select="wrd">
                <xsl:element name="td">
                    <xsl:attribute name="class">
                        <xsl:value-of select="@lang"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </xsl:element>
            </xsl:for-each>
        </tr>
    </xsl:template>
    <!--
      free
      -->
    <xsl:template match="free">
        <xsl:param name="originalContext"/>
        <xsl:call-template name="DoInterlinearFree">
            <xsl:with-param name="originalContext" select="$originalContext"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="free" mode="NoTextRef">
        <xsl:call-template name="DoInterlinearFree"/>
    </xsl:template>
    <!--
        literal
    -->
    <xsl:template match="literal">
        <xsl:param name="originalContext"/>
        <xsl:call-template name="DoInterlinearFree">
            <xsl:with-param name="originalContext" select="$originalContext"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="literal" mode="NoTextRef">
        <xsl:call-template name="DoInterlinearFree"/>
    </xsl:template>
    <!--
        listInterlinear
    -->
    <xsl:template match="listInterlinear">
        <xsl:param name="bListsShareSameCode"/>
        <xsl:if test="preceding-sibling::listInterlinear">
            <tr>
                <td>&#xa0;</td>
            </tr>
        </xsl:if>
        <tr>
            <td>
                <table cellpadding="0pt" cellspacing="0pt">
                    <tr>
                        <td valign="top">
                            <xsl:element name="a">
                                <xsl:attribute name="name">
                                    <xsl:value-of select="@letter"/>
                                </xsl:attribute>
                                <xsl:call-template name="AddAnyTitleAttribute">
                                    <xsl:with-param name="sId" select="@letter"/>
                                </xsl:call-template>
                                <xsl:apply-templates select="." mode="letter"/>
                                <xsl:text>.</xsl:text>
                            </xsl:element>
                        </td>
                        <xsl:if test="$lingPaper/@showiso639-3codeininterlinear='yes' or ancestor-or-self::example/@showiso639-3codes='yes'">
                            <xsl:if test="contains($bListsShareSameCode,'N')">
                                <td>
                                    <xsl:call-template name="OutputISOCodeInExample">
                                        <xsl:with-param name="bOutputBreak" select="'N'"/>
                                    </xsl:call-template>
                                </td>
                            </xsl:if>
                        </xsl:if>
                        <td>
                            <xsl:apply-templates/>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </xsl:template>
    <!--
        definition
    -->
    <xsl:template match="example/definition">
        <table cellpadding="0pt" cellspacing="0pt">
            <tr>
                <xsl:call-template name="DoDefinition"/>
            </tr>
        </table>
    </xsl:template>
    <xsl:template match="definition[not(parent::example)]">
        <span>
            <xsl:choose>
                <xsl:when test="@type">
                    <xsl:element name="div">
                        <xsl:attribute name="style">
                            <xsl:call-template name="DoType"/>
                        </xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="child::ol | child::ul | child::dl | child::img | child::object | child::br">
                                <xsl:apply-templates/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="." disable-output-escaping="yes"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                    <!--                <xsl:value-of select="." disable-output-escaping="yes"/> -->
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    <!--
        listDefinition
    -->
    <xsl:template match="listDefinition">
        <tr>
            <td valign="top">
                <xsl:element name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="@letter"/>
                    </xsl:attribute>
                    <xsl:call-template name="AddAnyTitleAttribute">
                        <xsl:with-param name="sId" select="@letter"/>
                    </xsl:call-template>
                    <xsl:apply-templates select="." mode="letter"/>.</xsl:element>
            </td>
            <xsl:for-each select="definition">
                <xsl:call-template name="DoDefinition"/>
            </xsl:for-each>
        </tr>
        <!--        </table> -->
    </xsl:template>
    <!--
      chart
      -->
    <xsl:template match="chart">
        <xsl:if test="name(..)='example'">
            <table>
                <tr>
                    <td>
                        <xsl:choose>
                            <xsl:when test="@type">
                                <xsl:element name="div">
                                    <xsl:attribute name="style">
                                        <xsl:call-template name="DoType"/>
                                    </xsl:attribute>
                                    <xsl:choose>
                                        <xsl:when test="child::ol | child::ul | child::dl | child::img | child::object | child::br">
                                            <xsl:apply-templates/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="." disable-output-escaping="yes"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:apply-templates/>
                                <!--                <xsl:value-of select="." disable-output-escaping="yes"/> -->
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                </tr>
            </table>
        </xsl:if>
        <xsl:if test="name(..)!='example'">
            <xsl:if test="parent::endnote and not(position()=1)">
                <table>
                    <tr>
                        <tr>
                            <td/>
                            <td>
                                <div>
                                    <xsl:choose>
                                        <xsl:when test="child::ol | child::ul | child::dl | child::img | child::object | child::br">
                                            <xsl:apply-templates/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="." disable-output-escaping="yes"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>
                            </td>
                        </tr>
                    </tr>
                </table>
            </xsl:if>
            <xsl:if test="not(parent::endnote) or position()=1">
                <div>
                    <xsl:call-template name="OutputCssSpecial">
                        <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
                    </xsl:call-template>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </div>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <!--
        figure
    -->
    <xsl:template match="figure">
        <div id="{@id}" align="{@align}">
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <xsl:if test="$lingPaper/@figureLabelAndCaptionLocation='before'">
                <p>
                    <xsl:call-template name="OutputFigureLabelAndCaption"/>
                </p>
            </xsl:if>
            <xsl:apply-templates select="*[name()!='caption' and name()!='shortCaption']"/>
            <xsl:if test="$lingPaper/@figureLabelAndCaptionLocation='after'">
                <p>
                    <xsl:call-template name="OutputFigureLabelAndCaption"/>
                </p>
            </xsl:if>
        </div>
    </xsl:template>
    <!--
        figureRef
    -->
    <xsl:template match="figureRef">
        <xsl:call-template name="OutputAnyTextBeforeFigureRef"/>
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showCaption"/>
        </xsl:call-template>
        <a href="#{@figure}">
            <xsl:call-template name="DoFigureRef"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showCaption"/>
        </xsl:call-template>
    </xsl:template>
    <!--
        listOfFiguresShownHere
    -->
    <xsl:template match="listOfFiguresShownHere">
        <div>
            <ul>
                <xsl:for-each select="//figure[not(ancestor::endnote or ancestor::framedUnit)]">
                    <li>
                        <a href="#{@id}">
                            <xsl:call-template name="OutputFigureLabelAndCaption">
                                <xsl:with-param name="bDoBold" select="'N'"/>
                                <xsl:with-param name="bDoStyles" select="'N'"/>
                            </xsl:call-template>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </div>
    </xsl:template>
    <!--
        tablenumbered
    -->
    <xsl:template match="tablenumbered">
        <div id="{@id}" align="{table/@align}">
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <xsl:if test="$lingPaper/@tablenumberedLabelAndCaptionLocation='before'">
                <p>
                    <xsl:call-template name="OutputTableNumberedLabelAndCaption"/>
                </p>
            </xsl:if>
            <xsl:apply-templates select="*[name()!='shortCaption']"/>
            <xsl:if test="$lingPaper/@tablenumberedLabelAndCaptionLocation='after'">
                <p>
                    <xsl:call-template name="OutputTableNumberedLabelAndCaption"/>
                </p>
            </xsl:if>
        </div>
    </xsl:template>
    <!--
        tablenumberedRef
    -->
    <xsl:template match="tablenumberedRef">
        <xsl:call-template name="OutputAnyTextBeforeTablenumberedRef"/>
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showCaption"/>
        </xsl:call-template>
        <a href="#{@table}">
            <xsl:call-template name="DoTablenumberedRef"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showCaption"/>
        </xsl:call-template>
    </xsl:template>
    <!--
        listOfTablesShownHere
    -->
    <xsl:template match="listOfTablesShownHere">
        <div>
            <ul>
                <xsl:for-each select="//tablenumbered[not(ancestor::endnote or ancestor::framedUnit)]">
                    <li>
                        <a href="#{@id}">
                            <xsl:call-template name="OutputTableNumberedLabelAndCaption">
                                <xsl:with-param name="bDoBold" select="'N'"/>
                                <xsl:with-param name="bDoStyles" select="'N'"/>
                            </xsl:call-template>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </div>
    </xsl:template>
    <!--
        tree
    -->
    <xsl:template match="tree">
        <xsl:choose>
            <xsl:when test="img">
                <xsl:choose>
                    <xsl:when test="name(..)='example'">
                        <table>
                            <tr>
                                <td valign="top">
                                    <xsl:apply-templates/>
                                </td>
                            </tr>
                        </table>
                    </xsl:when>
                    <xsl:otherwise>
                        <p style="margin-left: 0.25in">
                            <xsl:apply-templates/>
                        </p>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <div>
                    <xsl:call-template name="OutputCssSpecial">
                        <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
                    </xsl:call-template>
                    <xsl:value-of select="." disable-output-escaping="yes"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        table
    -->
    <xsl:template match="table">
        <xsl:choose>
            <xsl:when test="name(..)='example'">
                <xsl:choose>
                    <xsl:when test="preceding-sibling::exampleHeading">
                        <br style="line-height:5pt"/>
                        <xsl:call-template name="OutputTable"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <td>
                            <xsl:attribute name="style">
                                <xsl:value-of select="$sExampleCellPadding"/>
                            </xsl:attribute>
                            <xsl:call-template name="OutputTable"/>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <div>
                    <xsl:if test="string-length(normalize-space(@align)) &gt; 0">
                        <xsl:attribute name="align">
                            <xsl:value-of select="@align"/>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:call-template name="OutputCssSpecial">
                        <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
                        <xsl:with-param name="fDoBackgroundColor" select="'N'"/>
                    </xsl:call-template>
                    <xsl:call-template name="OutputTable"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        headerRow for a table
    -->
    <xsl:template match="headerRow">
        <tr>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
                <xsl:call-template name="OutputCssSpecial">
                    <xsl:with-param name="fDoStyleAttribute">N</xsl:with-param>
                </xsl:call-template>
                <xsl:if test="@direction">
                    <xsl:text>direction:</xsl:text>
                    <xsl:value-of select="@direction"/>
                    <xsl:text>; </xsl:text>
                </xsl:if>
                <xsl:call-template name="OutputBackgroundColor"/>
            </xsl:attribute>
            <xsl:apply-templates/>
        </tr>
    </xsl:template>
    <!--
        headerCol for a table
    -->
    <xsl:template match="headerCol | th">
        <xsl:element name="th">
            <xsl:call-template name="DoCellAttributes"/>
            <xsl:if test="not(@align)">
                <xsl:attribute name="align">left</xsl:attribute>
            </xsl:if>
            <xsl:if test="not(@valign)">
                <xsl:attribute name="valign">top</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
                <xsl:text>padding-left:.2em; </xsl:text>
                <xsl:call-template name="OutputBackgroundColor"/>
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <!--
        row for a table
    -->
    <xsl:template match="row | tr">
        <tr>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
                <xsl:call-template name="OutputCssSpecial">
                    <xsl:with-param name="fDoStyleAttribute">N</xsl:with-param>
                </xsl:call-template>
                <xsl:if test="@direction">
                    <xsl:text>direction:</xsl:text>
                    <xsl:value-of select="@direction"/>
                    <xsl:text>; </xsl:text>
                </xsl:if>
                <xsl:call-template name="OutputBackgroundColor"/>
            </xsl:attribute>
            <xsl:apply-templates/>
        </tr>
    </xsl:template>
    <!--
        col for a table
    -->
    <xsl:template match="col | td">
        <xsl:element name="td">
            <xsl:call-template name="DoCellAttributes"/>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
                <xsl:text>padding-left:.2em</xsl:text>
                <xsl:call-template name="OutputCssSpecial">
                    <xsl:with-param name="fDoStyleAttribute" select="'N'"/>
                </xsl:call-template>
                <xsl:call-template name="OutputDirection"/>
                <!--                <xsl:call-template name="OutputBackgroundColor"/>-->
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <xsl:template name="OutputDirection">
        <xsl:if test="@direction">
            <xsl:text>;direction:</xsl:text>
            <xsl:value-of select="@direction"/>
        </xsl:if>
    </xsl:template>
    <!--
        caption for a table
    -->
    <xsl:template match="caption"/>
    <xsl:template match="caption" mode="contents">
        <xsl:choose>
            <xsl:when test="following-sibling::shortCaption">
                <xsl:apply-templates select="following-sibling::shortCaption"/>
            </xsl:when>
            <xsl:when test="ancestor::tablenumbered/shortCaption">
                <xsl:apply-templates select="ancestor::tablenumbered/shortCaption"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="caption" mode="show">
        <xsl:choose>
            <xsl:when test="ancestor::tablenumbered or ancestor::figure">
                <span>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <td colspan="30">
                        <xsl:call-template name="DoCellAttributes"/>
                        <b>
                            <!-- default is bold -->
                            <xsl:apply-templates/>
                        </b>
                    </td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        endCaption for a table
    -->
    <xsl:template match="endCaption"/>
    <xsl:template match="endCaption" mode="contents">
        <xsl:choose>
            <xsl:when test="ancestor::tablenumbered/shortCaption">
                <xsl:apply-templates select="ancestor::tablenumbered/shortCaption"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="endCaption" mode="show">
        <xsl:choose>
            <xsl:when test="ancestor::tablenumbered or ancestor::figure">
                <span>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <td colspan="30">
                        <xsl:call-template name="DoCellAttributes"/>
                        <b>
                            <!-- default is bold -->
                            <xsl:apply-templates/>
                        </b>
                    </td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        exampleRef
    -->
    <xsl:template match="exampleRef">
        <a>
            <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
                <xsl:choose>
                    <xsl:when test="@letter and name(id(@letter))!='example'">
                        <xsl:value-of select="@letter"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="@num">
                            <xsl:value-of select="@num"/>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:call-template name="DoExampleRefContent"/>
        </a>
    </xsl:template>
    <!--
        iso639-3codeRef
    -->
    <xsl:template match="iso639-3codeRef">
        <a href="#{@lang}">
            <xsl:call-template name="DoISO639-3codeRefContent"/>
        </a>
    </xsl:template>
    <!-- following borrowed and modified from work by John Thomson -->
    <!--
        phrase
    -->
    <xsl:template match="phrase">
        <xsl:call-template name="DoPhrase"/>
    </xsl:template>
    <xsl:template match="phrase" mode="NoTextRef">
        <xsl:call-template name="DoPhrase"/>
    </xsl:template>
    <xsl:template name="DoPhrase">
        <xsl:choose>
            <xsl:when test="position() != 1">
                <br/>
                <!--                <span style="margin-left=.125in">  Should we indent here? -->
                <xsl:apply-templates/>
                <!--                </span>-->
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        phrase/item
    -->
    <xsl:template match="phrase/item">
        <xsl:choose>
            <xsl:when test="@type='txt'">
                <span>
                    <xsl:attribute name="style">
                        <xsl:call-template name="OutputFontAttributes">
                            <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </span>
                <br/>
            </xsl:when>
            <xsl:when test="@type='gls'">
                <br/>
                <xsl:choose>
                    <xsl:when test="count(../preceding-sibling::phrase) &gt; 0">
                        <!--                        <span style="margin-left=.125in"> Should we indent here? -->
                        <span>
                            <xsl:attribute name="style">
                                <xsl:call-template name="OutputFontAttributes">
                                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                                </xsl:call-template>
                            </xsl:attribute>
                            <xsl:apply-templates/>
                        </span>
                        <!--                        </span>-->
                    </xsl:when>
                    <xsl:otherwise>
                        <span>
                            <xsl:attribute name="style">
                                <xsl:call-template name="OutputFontAttributes">
                                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                                </xsl:call-template>
                            </xsl:attribute>
                            <xsl:apply-templates/>
                        </span>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="@type='note'">
                <div>
                    <xsl:text>Note: </xsl:text>
                    <span>
                        <xsl:attribute name="style">
                            <xsl:call-template name="OutputFontAttributes">
                                <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <xsl:apply-templates/>
                    </span>
                </div>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!--
        words
    -->
    <xsl:template match="words">
        <xsl:apply-templates/>
    </xsl:template>
    <!--
        iword
    -->
    <xsl:template match="iword">
        <span class="interblock">
            <table cellpadding="0" cellspacing="0">
                <xsl:apply-templates/>
            </table>
        </span>
    </xsl:template>
    <!--
        iword/item[@type='txt']
    -->
    <xsl:template match="iword/item[@type='txt']">
        <tr>
            <td>
                <xsl:attribute name="style">
                    <xsl:call-template name="OutputFontAttributes">
                        <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:apply-templates/>
                <xsl:text>&#160;</xsl:text>
            </td>
        </tr>
    </xsl:template>
    <!--
        iword/item[@type='gls']
    -->
    <xsl:template match="iword/item[@type='gls']">
        <tr>
            <td>
                <xsl:attribute name="style">
                    <xsl:call-template name="OutputFontAttributes">
                        <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:if test="string(.)">
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:if>
                <br/>
            </td>
        </tr>
    </xsl:template>
    <!--
        iword/item[@type='pos']
    -->
    <xsl:template match="iword/item[@type='pos']">
        <tr>
            <td>
                <xsl:if test="string(.)">
                    <xsl:apply-templates/>
                    <xsl:text>&#160;</xsl:text>
                </xsl:if>
                <br/>
            </td>
        </tr>
    </xsl:template>
    <!--
        morphemes
    -->
    <xsl:template match="morphemes">
        <tr>
            <td>
                <xsl:apply-templates/>
            </td>
        </tr>
    </xsl:template>
    <!--
        morphset
    -->
    <xsl:template match="morphset">
        <xsl:apply-templates/>
    </xsl:template>
    <!--
        morph
    -->
    <xsl:template match="morph">
        <span class="interblock">
            <table cellpadding="0" cellspacing="0">
                <xsl:apply-templates/>
            </table>
        </span>
    </xsl:template>
    <!--
        morph/item
    -->
    <xsl:template match="morph/item[@type!='hn' and @type!='cf']">
        <tr>
            <td>
                <xsl:attribute name="style">
                    <xsl:call-template name="OutputFontAttributes">
                        <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:apply-templates/>
                <xsl:text>&#160;</xsl:text>
            </td>
        </tr>
    </xsl:template>
    <!--
        morph/item[@type='hn']
    -->
    <!-- suppress homograph numbers, so they don't occupy an extra line-->
    <xsl:template match="morph/item[@type='hn']"/>
    <!-- This mode occurs within the 'cf' item to display the homograph number from the following item.-->
    <xsl:template match="morph/item[@type='hn']" mode="hn">
        <xsl:apply-templates/>
    </xsl:template>
    <!--
        morph/item[@type='cf']
    -->
    <xsl:template match="morph/item[@type='cf']">
        <tr>
            <td>
                <xsl:apply-templates/>
                <xsl:variable name="homographNumber" select="following-sibling::item[@type='hn']"/>
                <xsl:if test="$homographNumber">
                    <sub>
                        <xsl:apply-templates select="$homographNumber" mode="hn"/>
                    </sub>
                </xsl:if>
                <xsl:text>&#160;</xsl:text>
            </td>
        </tr>
    </xsl:template>
    <!-- preceding borrowed and modified from work by John Thomson -->
    <!-- ===========================================================
        ENDNOTES and ENDNOTEREFS
        =========================================================== -->
    <!--
        endnotes
    -->
    <xsl:template match="endnotes">
        <xsl:choose>
            <xsl:when test="ancestor::chapterInCollection">
                <xsl:call-template name="DoEndnotes">
                    <xsl:with-param name="endnotesToShow">
                        <xsl:for-each select="ancestor::chapterInCollection/descendant::endnote">
                            <xsl:text>X</xsl:text>
                        </xsl:for-each>
                        <xsl:for-each select="ancestor::chapterInCollection/descendant::interlinearRef">
                            <xsl:for-each select="key('InterlinearReferenceID',@textref)[1]">
                                <xsl:if test="descendant::endnote">
                                    <xsl:text>X</xsl:text>
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:with-param>
                    <xsl:with-param name="endnotesToUse" select="ancestor::chapterInCollection/descendant::endnote | ancestor::chapterInCollection/descendant::interlinearRef"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="DoEndnotes"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        endnote in flow of text
    -->
    <xsl:template match="endnote">
        <xsl:param name="originalContext"/>
        <xsl:choose>
            <xsl:when test="$originalContext and ancestor::interlinear-text">
                <!-- do nothing for an interlinearRef containing an endnote -->
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="OutputEndnoteNumber">
                    <xsl:with-param name="attr" select="@id"/>
                    <xsl:with-param name="originalContext" select="$originalContext"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        endnote in back matter
    -->
    <xsl:template match="endnote" mode="backMatter">
        <xsl:param name="originalContext"/>
        <xsl:choose>
            <xsl:when test="$lingPaper/@tablenumberedLabelAndCaptionLocation='after'">
                <xsl:choose>
                    <xsl:when test="ancestor::tablenumbered/table/descendant::endnote and ancestor::caption">
                        <!-- skip these for now -->
                    </xsl:when>
                    <xsl:when test="ancestor::tablenumbered/table/caption/descendant-or-self::endnote and ancestor::table">
                        <xsl:call-template name="HandleEndnoteInBackMatter">
                            <xsl:with-param name="originalContext" select="$originalContext"/>
                            <xsl:with-param name="iTablenumberedAdjust" select="-count(ancestor::tablenumbered/table/caption/descendant-or-self::endnote)"/>
                        </xsl:call-template>
                        <xsl:if test="ancestor::tablenumbered/table/descendant::endnote[position()=last()]=.">
                            <!-- this is the last endnote in the table; now handle all endnotes in the caption -->
                            <xsl:variable name="iTablenumberedAdjust" select="count(ancestor::tablenumbered/table/tr/descendant::endnote)"/>
                            <xsl:for-each select="ancestor::tablenumbered/table/caption/descendant-or-self::endnote">
                                <xsl:call-template name="HandleEndnoteInBackMatter">
                                    <xsl:with-param name="originalContext" select="$originalContext"/>
                                    <xsl:with-param name="iTablenumberedAdjust" select="$iTablenumberedAdjust"/>
                                </xsl:call-template>
                            </xsl:for-each>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="HandleEndnoteInBackMatter">
                            <xsl:with-param name="originalContext" select="$originalContext"/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="HandleEndnoteInBackMatter">
                    <xsl:with-param name="originalContext" select="$originalContext"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        endnoteRef
    -->
    <xsl:template match="endnoteRef">
        <xsl:choose>
            <xsl:when test="ancestor::endnote">
                <xsl:call-template name="DoEndnoteRefNumber"/>
            </xsl:when>
            <xsl:when test="@showNumberOnly='yes'">
                <xsl:call-template name="DoEndnoteRefNumber"/>
            </xsl:when>
            <xsl:otherwise>
                <span style="font-size:65%; vertical-align:super">
                    <xsl:call-template name="InsertCommaBetweenConsecutiveEndnotes"/>
                    <xsl:call-template name="DoEndnoteRefNumber"/>
                </span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- ===========================================================
        CITATIONS and REFERENCES 
        =========================================================== -->
    <!--
        citation
    -->
    <xsl:template match="citation" mode="contents">
        <xsl:call-template name="OutputCitationContents">
            <xsl:with-param name="refer" select="id(@ref)"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="//citation[not(parent::selectedBibliography)]">
        <xsl:variable name="refer" select="id(@ref)"/>
        <xsl:element name="a">
            <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
                <xsl:value-of select="@ref"/>
            </xsl:attribute>
            <xsl:call-template name="DoOutputCitationContents">
                <xsl:with-param name="refer" select="$refer"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>
    <!--
        references
    -->
    <xsl:template match="references">
        <xsl:variable name="refAuthors" select="//refAuthor"/>
        <xsl:variable name="gtAuthors" select="$refAuthors[refWork/@id=//citation[ancestor::glossaryTerm[key('GlossaryTermRefs',@id)]]/@ref]"/>
        <xsl:variable name="directlyCitedAuthors" select="$refAuthors[refWork/@id=//citation[not(ancestor::comment) and not(ancestor::annotation)]/@ref]"/>
        <xsl:variable name="directlyCitedAuthorsAnno" select="$refAuthors[refWork/@id=//citation[ancestor::annotation[@id=//annotationRef/@annotation]]/@ref]"/>
        <xsl:if test="$directlyCitedAuthors or $directlyCitedAuthorsAnno or $gtAuthors">
            <xsl:if test="not(ancestor::chapterInCollection)">
                <hr size="3"/>
            </xsl:if>
            <xsl:variable name="sId">
                <xsl:call-template name="GetIdToUse">
                    <xsl:with-param name="sBaseId" select="$sReferencesID"/>
                </xsl:call-template>
            </xsl:variable>
            <a name="{$sId}"/>
            <xsl:call-template name="OutputChapTitle">
                <xsl:with-param name="sTitle">
                    <xsl:call-template name="OutputReferencesLabel"/>
                </xsl:with-param>
            </xsl:call-template>
            <div style="margin-left:0.25in">
                <xsl:call-template name="HandleRefAuthors"/>
            </div>
        </xsl:if>
    </xsl:template>
    <!--
      refTitle
      -->
    <xsl:template match="refTitle">
        <xsl:variable name="sTitle" select="normalize-space(.)"/>
        <xsl:if test="string-length($sTitle) &gt; 0">
            <xsl:apply-templates/>
        </xsl:if>
    </xsl:template>
    <!--
        authorContactInfo
    -->
    <xsl:template match="authorContactInfo[count(preceding-sibling::authorContactInfo)=0]">
        <div style="padding-top:24pt">
            <table>
                <tr valign="top">
                    <xsl:call-template name="DoContactInfo">
                        <xsl:with-param name="authorInfo" select="key('AuthorContactID',@author)"/>
                    </xsl:call-template>
                    <xsl:for-each select="following-sibling::authorContactInfo">
                        <xsl:call-template name="DoContactInfo">
                            <xsl:with-param name="authorInfo" select="key('AuthorContactID',@author)"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </tr>
            </table>
        </div>
    </xsl:template>
    <!-- ===========================================================
      BR
      =========================================================== -->
    <xsl:template match="br">
        <br/>
    </xsl:template>
    <!-- ===========================================================
      GLOSS
      =========================================================== -->
    <xsl:template match="gloss">
        <xsl:param name="originalContext"/>
        <xsl:if test="ancestor::word and preceding-sibling::*[1][name()='langData']">
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        </xsl:if>
        <xsl:element name="span">
            <xsl:attribute name="style">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates>
                <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:apply-templates>
        </xsl:element>
    </xsl:template>
    <!-- ===========================================================
      ABBREVIATION
      =========================================================== -->
    <xsl:template match="abbrRef" mode="contents">
        <xsl:call-template name="OutputAbbrTerm">
            <xsl:with-param name="abbr" select="id(@abbr)"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="abbrRef">
        <xsl:choose>
            <xsl:when test="ancestor::genericRef">
                <xsl:call-template name="OutputAbbrTerm">
                    <xsl:with-param name="abbr" select="id(@abbr)"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <a href="#{@abbr}">
                    <xsl:if test="ancestor::gloss or parent::object">
                        <xsl:attribute name="style">
                            <xsl:text>; text-decoration:none; </xsl:text>
                            <xsl:for-each select="ancestor::gloss">
                                <xsl:sort order="descending"/>
                                <xsl:call-template name="OutputFontAttributes">
                                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                                </xsl:call-template>
                            </xsl:for-each>
                            <xsl:for-each select="ancestor::object">
                                <xsl:sort order="descending"/>
                                <xsl:call-template name="DoType">
                                    <xsl:with-param name="type" select="@type"/>
                                </xsl:call-template>
                            </xsl:for-each>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:call-template name="OutputAbbrTerm">
                        <xsl:with-param name="abbr" select="id(@abbr)"/>
                    </xsl:call-template>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="abbreviationsShownHere">
        <xsl:choose>
            <xsl:when test="ancestor::endnote">
                <xsl:choose>
                    <xsl:when test="parent::p">
                        <xsl:call-template name="HandleAbbreviationsInCommaSeparatedList"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <p>
                            <xsl:call-template name="HandleAbbreviationsInCommaSeparatedList"/>
                        </p>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="not(ancestor::p)">
                <!-- ignore any other abbreviationsShownHere in a p except when also in an endnote; everything else goes in a table -->
                <xsl:call-template name="HandleAbbreviationsInTable"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="abbrTerm | abbrDefinition"/>

    <!-- ===========================================================
        glossaryTerms
        =========================================================== -->
    <xsl:template match="glossaryTermRef">
        <xsl:choose>
            <xsl:when test="ancestor::genericRef">
                <xsl:call-template name="OutputGlossaryTerm">
                    <xsl:with-param name="glossaryTerm" select="id(@glossaryTerm)"/>
                    <xsl:with-param name="glossaryTermRef" select="."/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <a href="#{@glossaryTerm}">
                    <xsl:call-template name="OutputGlossaryTerm">
                        <xsl:with-param name="glossaryTerm" select="id(@glossaryTerm)"/>
                        <xsl:with-param name="glossaryTermRef" select="."/>
                    </xsl:call-template>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- ===========================================================
        keyTerm
        =========================================================== -->
    <xsl:template match="keyTerm">
        <xsl:element name="span">
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="."/>
                </xsl:call-template>
                <xsl:if test="not(@font-style) and not(key('TypeID',@type)/@font-style)">
                    <xsl:text>font-style:italic;</xsl:text>
                </xsl:if>
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <!-- ===========================================================
        exampleHeading
        =========================================================== -->
    <xsl:template match="exampleHeading">
        <table cellpadding="0pt" cellspacing="0pt">
            <tr>
                <td>&#xa0;<xsl:apply-templates/></td>
            </tr>
        </table>
    </xsl:template>
    <xsl:template match="exampleHeading" mode="noInitialSpace">
        <table cellpadding="0pt" cellspacing="0pt">
            <tr>
                <td>
                    <xsl:apply-templates/>
                </td>
            </tr>
        </table>
    </xsl:template>
    <!-- ===========================================================
      LANGDATA
      =========================================================== -->
    <xsl:template match="langData">
        <xsl:param name="originalContext"/>
        <xsl:element name="span">
            <xsl:attribute name="style">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates>
                <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:apply-templates>
        </xsl:element>
    </xsl:template>
    <!-- ===========================================================
      OBJECT
      =========================================================== -->
    <xsl:template match="object">
        <xsl:param name="originalContext"/>
        <xsl:element name="span">
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <xsl:for-each select="key('TypeID',@type)">
                <xsl:value-of select="@before"/>
            </xsl:for-each>
            <xsl:apply-templates>
                <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:apply-templates>
            <xsl:for-each select="key('TypeID',@type)">
                <xsl:value-of select="@after"/>
            </xsl:for-each>
        </xsl:element>
    </xsl:template>
    <xsl:template match="object" mode="Use">
        <xsl:apply-templates select="self::*"/>
    </xsl:template>
    <!-- ===========================================================
        MEDIAOBJECT
        =========================================================== -->
    <xsl:template match="mediaObject">
        <xsl:if test="//lingPaper/@includemediaobjects='yes'">
            <a href="{@src}" style="font-family:{$sMediaObjectFontFamily};">
                <xsl:attribute name="style">
                    <xsl:text>font-family:</xsl:text>
                    <xsl:value-of select="$sMediaObjectFontFamily"/>
                    <xsl:text>; </xsl:text>
                    <xsl:call-template name="OutputFontAttributes">
                        <xsl:with-param name="language" select="."/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:call-template name="GetMediaObjectIconCode">
                    <xsl:with-param name="mode" select="'html'"/>
                </xsl:call-template>
            </a>
        </xsl:if>
    </xsl:template>
    <!-- ===========================================================
        FRAMEDUNIT
        =========================================================== -->
    <xsl:template match="framedUnit">
        <div>
            <xsl:attribute name="style">
                <xsl:variable name="framedtype" select="key('FramedTypeID',@framedtype)"/>
                <xsl:text>background-color:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@backgroundcolor)"/>
                    <xsl:with-param name="sDefaultValue" select="'white'"/>
                </xsl:call-template>
                <xsl:text>;margin-top:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@spacebefore)"/>
                    <xsl:with-param name="sDefaultValue" select="'.125in'"/>
                </xsl:call-template>
                <xsl:text>;margin-bottom:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@spaceafter)"/>
                    <xsl:with-param name="sDefaultValue">.125in</xsl:with-param>
                </xsl:call-template>
                <xsl:text>;margin-left:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@indent-before)"/>
                    <xsl:with-param name="sDefaultValue">.125in</xsl:with-param>
                </xsl:call-template>
                <xsl:text>;margin-right:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@indent-after)"/>
                    <xsl:with-param name="sDefaultValue">.125in</xsl:with-param>
                </xsl:call-template>
                <xsl:text>;padding-top:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@innertopmargin)"/>
                    <xsl:with-param name="sDefaultValue">.125in</xsl:with-param>
                </xsl:call-template>
                <xsl:text>;padding-bottom:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@innerbottommargin)"/>
                    <xsl:with-param name="sDefaultValue">.125in</xsl:with-param>
                </xsl:call-template>
                <xsl:text>;padding-left:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@innerleftmargin)"/>
                    <xsl:with-param name="sDefaultValue">.125in</xsl:with-param>
                </xsl:call-template>
                <xsl:text>;padding-right:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@innerrightmargin)"/>
                    <xsl:with-param name="sDefaultValue">.125in</xsl:with-param>
                </xsl:call-template>
                <xsl:text>;text-align:</xsl:text>
                <xsl:call-template name="SetFramedTypeItem">
                    <xsl:with-param name="sAttributeValue" select="normalize-space($framedtype/@align)"/>
                    <xsl:with-param name="sDefaultValue">left</xsl:with-param>
                </xsl:call-template>
                <xsl:text>;border-width:.5pt;border-style:solid;border-color:black;</xsl:text>
            </xsl:attribute>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!-- ===========================================================
      IMG
      =========================================================== -->
    <xsl:template match="img">
        <xsl:variable name="sSrc" select="normalize-space(@src)"/>
        <xsl:choose>
            <xsl:when test="substring($sSrc,string-length($sSrc)-3) ='.mml'">
                <xsl:variable name="sSvg" select="concat(substring($sSrc,0,string-length($sSrc)-3),'.svg')"/>
                <embed src="{$sSvg}" type="image/svg+xml" pluginspage="http://www.adobe.com/svg/viewer/install/">
                    <xsl:call-template name="OutputCssSpecial"/>
                </embed>
            </xsl:when>
            <xsl:when test="substring($sSrc,string-length($sSrc)-3) ='.svg'">
                <embed src="{$sSrc}" type="image/svg+xml" pluginspage="http://www.adobe.com/svg/viewer/install/">
                    <xsl:call-template name="OutputCssSpecial"/>
                </embed>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="img">
                    <xsl:call-template name="OutputCssSpecial"/>
                    <xsl:if test="string-length(@alt) &gt; 0">
                        <xsl:attribute name="alt">
                            <xsl:value-of select="@alt"/>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:attribute name="src">
                        <xsl:value-of select="@src"/>
                    </xsl:attribute>
                    <xsl:if test="@description">
                        <xsl:attribute name="alt">
                            <xsl:value-of select="@description"/>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:if test="@borderaround='yes'">
                        <xsl:attribute name="border">
                            <xsl:text>1pt solid;</xsl:text>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="."/>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- ===========================================================
      INTERLINEAR TEXT
      =========================================================== -->
    <!--  
                  interlinear-text
-->
    <xsl:template match="interlinear-text">
        <div>
            <xsl:if test="string-length(@text) &gt; 0">
                <xsl:attribute name="id">
                    <xsl:value-of select="@text"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="preceding-sibling::p[1] or preceding-sibling::pc[1]">
                <xsl:attribute name="style">
                    <xsl:text>padding-top:12pt</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!--  
                  textInfo
-->
    <xsl:template match="textInfo">
        <xsl:apply-templates/>
    </xsl:template>
    <!--  
                  textTitle
-->
    <xsl:template match="textTitle">
        <div align="center" style="font-size:larger; font-weight:bold">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!--  
                  source
-->
    <xsl:template match="source">
        <div align="center" style="font-style:italic">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!-- ===========================================================
      NUMBERING PROCESSING 
      =========================================================== -->
    <!--  
                  sections
-->
    <xsl:template mode="number" match="*">
        <xsl:choose>
            <xsl:when test="ancestor-or-self::chapter">
                <xsl:apply-templates select="." mode="numberChapter"/>
                <xsl:if test="ancestor::chapter">
                    <xsl:text>.</xsl:text>
                </xsl:if>
            </xsl:when>
            <xsl:when test="ancestor-or-self::chapterInCollection">
                <xsl:apply-templates select="." mode="numberChapter"/>
                <xsl:if test="ancestor::chapterInCollection">
                    <xsl:text>.</xsl:text>
                </xsl:if>
            </xsl:when>
            <xsl:when test="ancestor-or-self::chapterBeforePart">
                <xsl:text>0</xsl:text>
                <xsl:if test="ancestor::chapterBeforePart">
                    <xsl:text>.</xsl:text>
                </xsl:if>
            </xsl:when>
        </xsl:choose>
        <!--
        <xsl:if test="//chapter">
            <xsl:apply-templates select="." mode="numberChapter"/>.</xsl:if>
      -->
        <xsl:number level="multiple" count="section1 | section2 | section3 | section4 | section5 | section6" format="1.1"/>
        <!--<xsl:variable name="numAt1">
         <xsl:number level="multiple" count="section1 | section2 | section3 | section4 | section5 | section6" format="1.1"/>
      </xsl:variable>
      -->
        <!--  adjust section1 number down by one to start with 0 -->
        <!--<xsl:variable name="num1" select="substring-before($numAt1,'.')"/>
      <xsl:variable name="numRest" select="substring-after($numAt1,'.')"/>
      <xsl:variable name="num1At0">
         <xsl:choose>
            <xsl:when test="$num1">
               <xsl:value-of select="number($num1)-1"/>
               <xsl:text>.</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="number($numAt1)-1"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:value-of select="$num1At0"/>
      <xsl:value-of select="$numRest"/>
  -->
    </xsl:template>
    <!--  
                  endnote
-->
    <xsl:template mode="endnote" match="endnote[parent::author]">
        <xsl:variable name="iAuthorPosition" select="count(parent::author/preceding-sibling::author[endnote]) + 1"/>
        <xsl:call-template name="OutputAuthorFootnoteSymbol">
            <xsl:with-param name="iAuthorPosition" select="$iAuthorPosition"/>
        </xsl:call-template>
    </xsl:template>
    <!--  
        figure
    -->
    <xsl:template mode="figure" match="*" priority="10">
        <xsl:choose>
            <xsl:when test="//chapter | //chapterInCollection">
                <xsl:for-each select="ancestor::chapter | ancestor::appendix | ancestor::chapterBeforePart | ancestor::chapterInCollection">
                    <xsl:call-template name="OutputChapterNumber">
                        <xsl:with-param name="fIgnoreTextAfterLetter" select="'Y'"/>
                    </xsl:call-template>
                </xsl:for-each>
                <xsl:text>.</xsl:text>
                <xsl:number level="any" count="figure[not(ancestor::endnote or ancestor::framedUnit)]" from="chapter | appendix | chapterBeforePart | chapterInCollection" format="1"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:number level="any" count="figure[not(ancestor::endnote or ancestor::framedUnit)]" format="1"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        tablenumbered
    -->
    <xsl:template mode="tablenumbered" match="*" priority="10">
        <xsl:choose>
            <xsl:when test="//chapter | //chapterInCollection">
                <xsl:for-each select="ancestor::chapter | ancestor::appendix | ancestor::chapterBeforePart | ancestor::chapterInCollection">
                    <xsl:call-template name="OutputChapterNumber">
                        <xsl:with-param name="fIgnoreTextAfterLetter" select="'Y'"/>
                    </xsl:call-template>
                </xsl:for-each>
                <xsl:text>.</xsl:text>
                <xsl:number level="any" count="tablenumbered[not(ancestor::endnote or ancestor::framedUnit)]" from="chapter | appendix | chapterBeforePart | chapterInCollection" format="1"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:number level="any" count="tablenumbered[not(ancestor::endnote or ancestor::framedUnit)]" format="1"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
                  letter
-->
    <xsl:template mode="letter" match="*">
        <xsl:number level="single" count="listWord | listSingle | listInterlinear | listDefinition | lineSet" format="a"/>
    </xsl:template>
    <!-- ===========================================================
        ELEMENTS TO IGNORE
        =========================================================== -->
    <xsl:template match="authorContacts"/>
    <xsl:template match="basicPointSize"/>
    <xsl:template match="blockQuoteIndent"/>
    <xsl:template match="citation[parent::selectedBibliography]"/>
    <xsl:template match="contentControlChoice"/>
    <xsl:template match="contentType"/>
    <xsl:template match="defaultFontFamily"/>
    <xsl:template match="fixedText"/>
    <xsl:template match="footerMargin"/>
    <xsl:template match="footnotePointSize"/>
    <xsl:template match="headerMargin"/>
    <xsl:template match="pageBottomMargin"/>
    <xsl:template match="pageHeight"/>
    <xsl:template match="pageInsideMargin"/>
    <xsl:template match="pageOutsideMargin"/>
    <xsl:template match="pageTopMargin"/>
    <xsl:template match="pageWidth"/>
    <xsl:template match="paragraphIndent"/>
    <xsl:template match="publisherStyleSheetName"/>
    <xsl:template match="publisherStyleSheetReferencesName"/>
    <xsl:template match="publisherStyleSheetReferencesVersion"/>
    <xsl:template match="publisherStyleSheetVersion"/>
    <xsl:template match="publishingBlurb"/>
    <xsl:template match="referencedInterlinearTexts"/>
    <!-- ===========================================================
      NAMED TEMPLATES
      =========================================================== -->
    <!--
      ApplyTemplatesPerTextRefMode
   -->
    <xsl:template name="ApplyTemplatesPerTextRefMode">
        <xsl:param name="mode"/>
        <xsl:param name="originalContext"/>
        <xsl:choose>
            <xsl:when test="$mode='NoTextRef'">
                <xsl:apply-templates mode="NoTextRef"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates>
                    <xsl:with-param name="originalContext" select="$originalContext"/>
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
                  CheckSeeTargetIsCitedOrItsDescendantIsCited
   -->
    <xsl:template name="CheckSeeTargetIsCitedOrItsDescendantIsCited">
        <xsl:variable name="sSee" select="@see"/>
        <xsl:choose>
            <xsl:when test="//indexedItem[@term=$sSee][not(ancestor::comment)] | //indexedRangeBegin[@term=$sSee][not(ancestor::comment)]">
                <xsl:text>Y</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="key('IndexTermID',@see)/descendant::indexTerm">
                    <xsl:variable name="sDescendantTermId" select="@id"/>
                    <xsl:if test="//indexedItem[@term=$sDescendantTermId][not(ancestor::comment)] or //indexedRangeBegin[@term=$sDescendantTermId][not(ancestor::comment)]">
                        <xsl:text>Y</xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
                  CreateIndexID
                                    -->
    <xsl:template name="CreateIndexID">
        <xsl:text>rXLingPapIndex.</xsl:text>
        <xsl:value-of select="generate-id()"/>
    </xsl:template>
    <!--
                  CreateIndexedItemID
                  -->
    <xsl:template name="CreateIndexedItemID">
        <xsl:param name="sTermId"/>
        <xsl:text>rXLingPapIndexedItem.</xsl:text>
        <xsl:value-of select="$sTermId"/>
        <xsl:text>.</xsl:text>
        <xsl:value-of select="generate-id()"/>
    </xsl:template>
    <!--
                  CreateIndexTermID
                  -->
    <xsl:template name="CreateIndexTermID">
        <xsl:param name="sTermId"/>
        <xsl:text>rXLingPapIndexTerm.</xsl:text>
        <xsl:value-of select="$sTermId"/>
    </xsl:template>
    <!--
        DoAnnotation
    -->
    <xsl:template name="DoAnnotation">
        <xsl:param name="sAnnotation"/>
        <p style="padding-left:0.25in">
            <xsl:apply-templates select="key('AnnotationID',$sAnnotation)"/>
        </p>
    </xsl:template>
    <!--
        DoAuthorFootnoteNumber
    -->
    <xsl:template name="DoAuthorFootnoteNumber">
        <xsl:variable name="iTitleEndnote">
            <xsl:call-template name="GetCountOfEndnoteInTitleUsingSymbol"/>
        </xsl:variable>
        <xsl:variable name="iAuthorPosition">
            <xsl:call-template name="GetAuthorFootnoteNumber">
                <xsl:with-param name="iTitleEndnote" select="$iTitleEndnote"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="OutputAuthorFootnoteSymbol">
            <xsl:with-param name="iAuthorPosition" select="$iAuthorPosition"/>
        </xsl:call-template>
    </xsl:template>
    <!--
        DoBook
    -->
    <xsl:template name="DoBook">
        <xsl:param name="book"/>
        <xsl:param name="pages"/>
        <xsl:for-each select="$book">
            <xsl:variable name="sTitle" select="normalize-space(../refTitle)"/>
            <xsl:if test="string-length($sTitle) &gt; 0">
                <i>
                    <xsl:apply-templates select="../refTitle"/>
                </i>
                <xsl:text>.  </xsl:text>
            </xsl:if>
            <xsl:if test="../../@showAuthorName='no'">
                <xsl:for-each select="..">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$book/.."/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:if>
            <xsl:if test="translatedBy">
                <xsl:text>Translated by </xsl:text>
                <xsl:apply-templates select="translatedBy"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="translatedBy"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="editor">
                <xsl:apply-templates select="editor"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="editor"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="bookversion">
                <xsl:apply-templates select="bookversion"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="bookversion"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="edition">
                <xsl:apply-templates select="edition"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="edition"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="seriesEd">
                <xsl:apply-templates select="seriesEd"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="seriesEd"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="series">
                <i>
                    <xsl:apply-templates select="series"/>
                </i>
                <xsl:if test="not(bVol)">
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="series"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:variable name="sPages" select="normalize-space($pages)"/>
            <xsl:choose>
                <xsl:when test="bVol">
                    <xsl:value-of select="normalize-space(bVol)"/>
                    <xsl:if test="string-length($sPages) &gt; 0">
                        <xsl:text>:</xsl:text>
                        <xsl:value-of select="$pages"/>
                    </xsl:if>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="bVol"/>
                    </xsl:call-template>
                    <xsl:text>&#x20;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="string-length($sPages) &gt; 0">
                        <xsl:value-of select="$sPages"/>
                        <xsl:text>. </xsl:text>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="multivolumeWork">
                <i>
                    <xsl:apply-templates select="multivolumeWork"/>
                </i>
                <xsl:text>.&#x20;</xsl:text>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="location and publisher">
                    <xsl:apply-templates select="location"/>
                    <xsl:text>: </xsl:text>
                    <xsl:apply-templates select="publisher"/>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="publisher"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="location">
                    <xsl:apply-templates select="location"/>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="location"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="publisher">
                    <xsl:apply-templates select="publisher"/>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="publisher"/>
                    </xsl:call-template>
                </xsl:when>
            </xsl:choose>
            <xsl:call-template name="DoReprintInfo">
                <xsl:with-param name="reprintInfo" select="reprintInfo"/>
            </xsl:call-template>
            <xsl:call-template name="DoRefUrlEtc">
                <xsl:with-param name="path" select="."/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--  
        DoBookEndnotesLabeling
    -->
    <xsl:template name="DoBookEndnotesLabeling">
        <xsl:param name="originalContext"/>
        <xsl:param name="chapterOrAppendixUnit"/>
        <xsl:param name="iTablenumberedAdjust" select="'0'"/>
        <xsl:variable name="sFootnoteNumber">
            <xsl:call-template name="GetFootnoteNumber">
                <xsl:with-param name="originalContext" select="$originalContext"/>
                <xsl:with-param name="iTablenumberedAdjust" select="$iTablenumberedAdjust"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:if test="$sFootnoteNumber='1'">
            <tr>
                <td colspan="2" style="font-style:italic; font-size:larger; font-weight:bold">
                    <xsl:choose>
                        <xsl:when test="name($chapterOrAppendixUnit)='chapter'">
                            <xsl:call-template name="OutputChapterLabel"/>
                        </xsl:when>
                        <xsl:when test="name($chapterOrAppendixUnit)='chapterBeforePart'">
                            <xsl:call-template name="OutputChapterLabel"/>
                        </xsl:when>
                        <xsl:when test="name($chapterOrAppendixUnit)='chapterInCollection'">
                            <xsl:if test="not($chapterOrAppendixUnit/backMatter/endnotes)">
                                <xsl:call-template name="OutputChapterLabel"/>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test="name($chapterOrAppendixUnit)='appendix'">
                            <xsl:call-template name="DoEndnoteSectionLabel">
                                <xsl:with-param name="layoutInfo" select="$chapterOrAppendixUnit"/>
                                <xsl:with-param name="sDefault" select="'Appendix'"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="name($chapterOrAppendixUnit)='glossary'">
                            <xsl:call-template name="DoEndnoteSectionLabel">
                                <xsl:with-param name="layoutInfo" select="$chapterOrAppendixUnit"/>
                                <xsl:with-param name="sDefault" select="'Glossary'"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="name($chapterOrAppendixUnit)='acknowledgements'">
                            <xsl:choose>
                                <xsl:when test="ancestor::frontMatter">
                                    <xsl:call-template name="DoEndnoteSectionLabel">
                                        <xsl:with-param name="layoutInfo" select="$chapterOrAppendixUnit"/>
                                        <xsl:with-param name="sDefault" select="'Acknowledgements'"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="DoEndnoteSectionLabel">
                                        <xsl:with-param name="layoutInfo" select="$chapterOrAppendixUnit"/>
                                        <xsl:with-param name="sDefault" select="'Acknowledgements'"/>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="name($chapterOrAppendixUnit)='preface'">
                            <xsl:call-template name="DoEndnoteSectionLabel">
                                <xsl:with-param name="layoutInfo" select="$chapterOrAppendixUnit"/>
                                <xsl:with-param name="sDefault" select="'Preface'"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="name($chapterOrAppendixUnit)='abstract'">
                            <xsl:call-template name="DoEndnoteSectionLabel">
                                <xsl:with-param name="layoutInfo" select="$chapterOrAppendixUnit"/>
                                <xsl:with-param name="sDefault" select="'Abstract'"/>
                            </xsl:call-template>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:if test="not($chapterOrAppendixUnit/backMatter/endnotes)">
                        <xsl:text>&#x20;</xsl:text>
                        <xsl:for-each select="$chapterOrAppendixUnit">
                            <xsl:call-template name="OutputChapterNumber"/>
                        </xsl:for-each>
                    </xsl:if>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    <!--
        DoCellAttributes
    -->
    <xsl:template name="DoCellAttributes">
        <xsl:if test="@direction">
            <xsl:attribute name="style">
                <xsl:text>direction:</xsl:text>
                <xsl:value-of select="@direction"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="@align">
            <xsl:attribute name="align">
                <xsl:value-of select="@align"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="@colspan">
            <xsl:attribute name="colspan">
                <xsl:value-of select="@colspan"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="@rowspan">
            <xsl:attribute name="rowspan">
                <xsl:value-of select="@rowspan"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="@valign">
            <xsl:attribute name="valign">
                <xsl:value-of select="@valign"/>
            </xsl:attribute>
        </xsl:if>
        <!-- does not work in HTML 4.0 
            <xsl:if test="@width">
            <xsl:attribute name="width">
            <xsl:value-of select="@width"/>
            </xsl:attribute>
            </xsl:if>
        -->
    </xsl:template>
    <!--
        DoContactInfo
    -->
    <xsl:template name="DoContactInfo">
        <xsl:param name="authorInfo"/>
        <td style="{$sExampleCellPadding}">
            <xsl:apply-templates select="$authorInfo/contactName"/>
            <br/>
            <xsl:for-each select="$authorInfo/contactAffiliation">
                <xsl:apply-templates select="."/>
                <br/>
            </xsl:for-each>
            <xsl:for-each select="$authorInfo/contactAddress">
                <xsl:apply-templates select="."/>
                <br/>
            </xsl:for-each>
            <xsl:for-each select="$authorInfo/contactEmail">
                <xsl:apply-templates select="."/>
                <br/>
            </xsl:for-each>
            <xsl:for-each select="$authorInfo/contactElectronic[@show='yes']">
                <xsl:apply-templates select="."/>
                <br/>
            </xsl:for-each>
        </td>
    </xsl:template>
    <!--  
        DoDate
    -->
    <xsl:template name="DoDate">
        <xsl:param name="works"/>
        <xsl:param name="sortedWorks"/>
        <xsl:variable name="date">
            <xsl:value-of select="refDate"/>
        </xsl:variable>
        <xsl:for-each select="refDate">
            <xsl:call-template name="OutputRefDateValue">
                <xsl:with-param name="date" select="$date"/>
                <xsl:with-param name="works" select="$works"/>
                <xsl:with-param name="sortedWorks" select="$sortedWorks"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:text>. </xsl:text>
    </xsl:template>
    <!--  
        DoDefinition
    -->
    <xsl:template name="DoDefinition">
        <td style="padding-left: .25em">
            <xsl:choose>
                <xsl:when test="@type">
                    <xsl:element name="span">
                        <xsl:attribute name="style">
                            <xsl:call-template name="DoType"/>
                        </xsl:attribute>
                        <xsl:apply-templates/>
                        <!--                        <xsl:choose>
                            <xsl:when test="child::ol | child::ul | child::dl | child::img | child::object | child::br">
                            <xsl:apply-templates/>
                            </xsl:when>
                            <xsl:otherwise>
                            <xsl:value-of select="." disable-output-escaping="yes"/>
                            </xsl:otherwise>
                            </xsl:choose>
                        -->
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                    <!--                <xsl:value-of select="." disable-output-escaping="yes"/> -->
                </xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
    <!--  
        DoEdPlural
    -->
    <xsl:template name="DoEdPlural">
        <xsl:param name="editor"/>
        <xsl:apply-templates select="$editor"/>
        <xsl:text>, ed</xsl:text>
        <xsl:if test="$editor/@plural='yes'">
            <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text>.</xsl:text>
        <!--        <xsl:call-template name="OutputPeriodIfNeeded">
            <xsl:with-param name="sText" select="$editor"/>
            </xsl:call-template>
        -->
    </xsl:template>
    <!--  
        DoEndnoteRefNumber
    -->
    <xsl:template name="DoEndnoteRefNumber">
        <xsl:text>[</xsl:text>
        <a href="#{@note}">
            <xsl:for-each select="key('EndnoteID',@note)">
                <xsl:call-template name="GetFootnoteNumber">
                    <xsl:with-param name="iAdjust" select="0"/>
                </xsl:call-template>
            </xsl:for-each>
        </a>
        <xsl:text>]</xsl:text>
    </xsl:template>
    <!--  
        DoEndnotes
    -->
    <xsl:template name="DoEndnotes">
        <xsl:param name="endnotesToShow" select="$endnotesToShow"/>
        <xsl:param name="endnotesToUse"
            select="//endnote[not(ancestor::referencedInterlinearText)][not(ancestor::chapterInCollection/backMatter/endnotes)][not(ancestor::comment)] | //interlinearRef[not(ancestor::chapterInCollection/backMatter/endnotes)]"/>
        <xsl:if test="contains($endnotesToShow,'X')">
            <xsl:if test="not(ancestor::chapterInCollection)">
                <hr size="3"/>
            </xsl:if>
            <xsl:variable name="sId">
                <xsl:call-template name="GetIdToUse">
                    <xsl:with-param name="sBaseId" select="$sEndnotesID"/>
                </xsl:call-template>
            </xsl:variable>
            <a name="{$sId}"/>
            <xsl:call-template name="OutputChapTitle">
                <xsl:with-param name="sTitle">
                    <xsl:call-template name="OutputEndnotesLabel"/>
                </xsl:with-param>
            </xsl:call-template>
            <table>
                <xsl:apply-templates select="$endnotesToUse" mode="backMatter"/>
            </table>
        </xsl:if>
    </xsl:template>
    <!--  
        DoEndnoteSectionLabel
    -->
    <xsl:template name="DoEndnoteSectionLabel">
        <xsl:param name="layoutInfo"/>
        <xsl:param name="sDefault"/>
        <xsl:choose>
            <xsl:when test="string-length(normalize-space($layoutInfo/@label)) &gt; 0">
                <xsl:value-of select="$layoutInfo/@label"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$sDefault"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        DoInterlinearFree
    -->
    <xsl:template name="DoInterlinearFree">
        <xsl:param name="originalContext"/>
        <table>
            <!-- add extra indent for when have an embedded interlinear; 
                be sure to allow for the case of when a listInterlinear begins with an interlinear -->
            <xsl:variable name="parent" select=".."/>
            <xsl:variable name="iParentPosition">
                <xsl:for-each select="../../*">
                    <xsl:if test=".=$parent">
                        <xsl:value-of select="position()"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="sCurrentLanguage" select="@lang"/>
            <xsl:choose>
                <xsl:when test="name()='literal'">
                    <xsl:if
                        test="preceding-sibling::literal[@lang=$sCurrentLanguage][position()=1] or preceding-sibling::*[1][name()='literal'][not(@lang)][position()=1] or name(../..)='interlinear' or name(../..)='listInterlinear' and name(..)='interlinear' and $iParentPosition!=1">
                        <xsl:attribute name="style">
                            <xsl:text>margin-left: 0.1in</xsl:text>
                        </xsl:attribute>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if
                        test="preceding-sibling::free[@lang=$sCurrentLanguage][position()=1]or preceding-sibling::*[1][name()='free'][not(@lang)][position()=1] or name(../..)='interlinear' or name(../..)='listInterlinear' and name(..)='interlinear' and $iParentPosition!=1">
                        <xsl:attribute name="style">
                            <xsl:text>margin-left: 0.1in</xsl:text>
                        </xsl:attribute>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
            <tr style="line-height:125%">
                <xsl:element name="td">
                    <xsl:attribute name="colspan">30</xsl:attribute>
                    <xsl:attribute name="style">
                        <xsl:call-template name="OutputFontAttributes">
                            <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:call-template name="DoLiteralLabel"/>
                    <xsl:apply-templates>
                        <xsl:with-param name="originalContext" select="$originalContext"/>
                    </xsl:apply-templates>
                </xsl:element>
                <xsl:if test="$sInterlinearSourceStyle='AfterFree' and not(following-sibling::free or following-sibling::literal)">
                    <xsl:if test="name(../..)='example'  or name(../..)='listInterlinear'">
                        <xsl:call-template name="OutputInterlinearTextReference">
                            <xsl:with-param name="sRef" select="../@textref"/>
                            <xsl:with-param name="sSource" select="../interlinearSource"/>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:if>
            </tr>
        </table>
        <xsl:if test="$sInterlinearSourceStyle='UnderFree' and not(following-sibling::free or following-sibling::literal)">
            <xsl:if test="name(../..)='example' or name(../..)='listInterlinear'">
                <table>
                    <tr>
                        <xsl:call-template name="OutputInterlinearTextReference">
                            <xsl:with-param name="sRef" select="../@textref"/>
                            <xsl:with-param name="sSource" select="../interlinearSource"/>
                        </xsl:call-template>
                    </tr>
                </table>
            </xsl:if>
        </xsl:if>
        <!--  
            DoInterlinearLine
        -->
    </xsl:template>
    <xsl:template name="DoInterlinearLine">
        <xsl:param name="originalContext"/>
        <xsl:variable name="bRtl">
            <xsl:choose>
                <xsl:when test="id(parent::lineGroup/line[1]/wrd/langData[1]/@lang)/@rtl='yes'">Y</xsl:when>
                <xsl:otherwise>N</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="wrd">
                <xsl:for-each select="wrd">
                    <xsl:element name="td">
                        <xsl:if test="$bRtl='Y'">
                            <xsl:attribute name="align">right</xsl:attribute>
                        </xsl:if>
                        <xsl:attribute name="style">
                            <xsl:call-template name="OutputFontAttributes">
                                <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                            </xsl:call-template>
                            <xsl:value-of select="$sExampleCellPadding"/>
                        </xsl:attribute>
                        <!-- Internet Explorer has a bug whereby small-caps is not always rendered on the same horizontal line as surrounding cells.
                            If we have space at the beginning and at the end of the <td>, it renders correctly.-->
                        <xsl:text>&#x20;</xsl:text>
                        <xsl:apply-templates>
                            <xsl:with-param name="originalContext" select="$originalContext"/>
                        </xsl:apply-templates>
                        <xsl:text>&#x20;</xsl:text>
                    </xsl:element>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="bFlip">
                    <xsl:choose>
                        <xsl:when test="id(parent::lineGroup/line[1]/langData[1]/@lang)/@rtl='yes'">Y</xsl:when>
                        <xsl:otherwise>N</xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <xsl:if test="$bFlip='Y'">
                    <xsl:attribute name="align">right</xsl:attribute>
                </xsl:if>
                <xsl:variable name="language">
                    <xsl:if test="langData">
                        <xsl:value-of select="langData/@lang"/>
                    </xsl:if>
                    <xsl:if test="gloss">
                        <xsl:value-of select="gloss/@lang"/>
                    </xsl:if>
                </xsl:variable>
                <xsl:variable name="sContents">
                    <xsl:apply-templates/>
                </xsl:variable>
                <xsl:variable name="sOrientedContents">
                    <xsl:choose>
                        <xsl:when test="$bFlip='Y'">
                            <!-- flip order, left to right -->
                            <xsl:call-template name="ReverseContents">
                                <xsl:with-param name="sList" select="$sContents"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$sContents"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <xsl:call-template name="OutputTableCells">
                    <xsl:with-param name="sList" select="$sOrientedContents"/>
                    <xsl:with-param name="language" select="$language"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        DoInterlinearLineGroup
    -->
    <xsl:template name="DoInterlinearLineGroup">
        <xsl:param name="mode"/>
        <xsl:param name="originalContext"/>
        <table cellpadding="0pt" cellspacing="0pt">
            <!-- add extra indent for when have an embedded interlinear; 
                be sure to allow for the case of when a listInterlinear begins with an interlinear -->
            <xsl:variable name="parent" select=".."/>
            <xsl:variable name="iParentPosition">
                <xsl:for-each select="../../*">
                    <xsl:if test=".=$parent">
                        <xsl:value-of select="position()"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:if test="name(../..)='interlinear' or name(../..)='listInterlinear' and name(..)='interlinear' and $iParentPosition!=1">
                <xsl:attribute name="style">
                    <xsl:text>margin-left: 0.1in</xsl:text>
                </xsl:attribute>
                <xsl:if test="count(../../lineGroup[last()]/line) &gt; 1 or count(line) &gt; 1">
                    <tr>
                        <td>&#xa0;</td>
                    </tr>
                </xsl:if>
            </xsl:if>
            <xsl:call-template name="ApplyTemplatesPerTextRefMode">
                <xsl:with-param name="mode" select="$mode"/>
                <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:call-template>
        </table>
    </xsl:template>
    <!--  
        DoRefCitation
    -->
    <xsl:template name="DoRefCitation">
        <xsl:param name="citation"/>
        <xsl:for-each select="$citation">
            <xsl:variable name="refer" select="id(@refToBook)"/>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="@refToBook"/>
                </xsl:attribute>
                <xsl:choose>
                    <xsl:when test="$refer/../citeName">
                        <xsl:apply-templates select="$refer/../citeName"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$refer/../@citename"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>,&#x20;</xsl:text>
                <xsl:value-of select="$refer/authorRole"/>
                <xsl:text>, </xsl:text>
                <xsl:variable name="sPage" select="normalize-space(@page)"/>
                <xsl:if test="string-length($sPage) &gt; 0">
                    <xsl:text>&#x20;</xsl:text>
                    <xsl:value-of select="$sPage"/>
                </xsl:if>
                <xsl:text>.</xsl:text>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>
    <!--  
        DoRefWorkPrep
    -->
    <xsl:template name="DoRefWorkPrep"/>
    <!--  
        DoRefUrlEtc
    -->
    <xsl:template name="DoRefUrlEtc">
        <xsl:param name="path"/>
        <xsl:if test="$path/url">
            <xsl:text> (</xsl:text>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:value-of select="normalize-space(translate($path/url,$sStripFromUrl,''))"/>
                </xsl:attribute>
                <xsl:value-of select="normalize-space($path/url)"/>
            </xsl:element>
            <xsl:text>)</xsl:text>
            <xsl:if test="$path/dateAccessed">
                <xsl:text>  (accessed </xsl:text>
                <xsl:value-of select="normalize-space($path/dateAccessed)"/>
                <xsl:text>)</xsl:text>
            </xsl:if>
            <xsl:text>.</xsl:text>
        </xsl:if>
        <xsl:if test="$lingPaper/@showiso639-3codeininterlinear='yes' or ancestor-or-self::refWork/@showiso639-3codes='yes'">
            <xsl:for-each select="$path/iso639-3code">
                <xsl:sort/>
                <span style="font-size:smaller">
                    <xsl:if test="position() = 1">
                        <xsl:text>  [</xsl:text>
                    </xsl:if>
                    <xsl:choose>
                        <xsl:when test="$bShowISO639-3Codes='Y'">
                            <xsl:variable name="sThisCode" select="."/>
                            <a href="#{$languages[@ISO639-3Code=$sThisCode]/@id}">
                                <xsl:value-of select="."/>
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="."/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="position() != last()">
                        <xsl:text>, </xsl:text>
                    </xsl:if>
                    <xsl:if test="position() = last()">
                        <xsl:text>]</xsl:text>
                    </xsl:if>
                </span>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <!--  
        DoRefWork
    -->
    <xsl:template name="DoRefWork">
        <xsl:param name="works"/>
        <xsl:param name="sortedWorks"/>
        <xsl:param name="bDoTarget" select="'Y'"/>
        <p style="text-indent:-0.25in;margin-bottom:0in;margin-top:0in">
            <xsl:choose>
                <xsl:when test="../@showAuthorName='no'">
                    <xsl:if test="$bDoTarget='Y'">
                        <xsl:element name="a">
                            <xsl:attribute name="name">
                                <xsl:value-of select="@id"/>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="author">
                        <xsl:value-of select="normalize-space(../@name)"/>
                    </xsl:variable>
                    <xsl:choose>
                        <xsl:when test="$bDoTarget='Y'">
                            <xsl:element name="a">
                                <xsl:attribute name="name">
                                    <xsl:value-of select="@id"/>
                                </xsl:attribute>
                                <xsl:value-of select="$author"/>
                            </xsl:element>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$author"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="substring($author,string-length($author),string-length($author))!='.'">.</xsl:if>
                    <xsl:text>&#x20;  </xsl:text>
                    <xsl:if test="authorRole">
                        <xsl:value-of select="authorRole"/>
                        <xsl:text>.  </xsl:text>
                    </xsl:if>
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                        <xsl:with-param name="sortedWorks" select="$sortedWorks"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            <!--
                book
            -->
            <xsl:if test="book">
                <xsl:call-template name="DoBook">
                    <xsl:with-param name="book" select="book"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                collection
            -->
            <xsl:if test="collection">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                </xsl:if>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <!--                    <xsl:value-of select="$sRdquo"/>-->
                <xsl:text> In </xsl:text>
                <xsl:choose>
                    <xsl:when test="collection/collCitation">
                        <xsl:variable name="citation" select="collection/collCitation"/>
                        <xsl:choose>
                            <xsl:when test="saxon:node-set($collOrProcVolumesToInclude)/refWork[@id=$citation/@refToBook]">
                                <xsl:call-template name="DoRefCitation">
                                    <xsl:with-param name="citation" select="$citation"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="FleshOutRefCitation">
                                    <xsl:with-param name="citation" select="$citation"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="DoEdPlural">
                            <xsl:with-param name="editor" select="collection/collEd"/>
                        </xsl:call-template>
                        <xsl:text>&#x20;</xsl:text>
                        <i>
                            <xsl:apply-templates select="collection/collTitle"/>
                        </i>
                        <xsl:text>.</xsl:text>
                        <xsl:if test="collection/bookversion">
                            <xsl:text>&#x20;</xsl:text>
                            <xsl:apply-templates select="collection/bookversion"/>
                            <xsl:call-template name="OutputPeriodIfNeeded">
                                <xsl:with-param name="sText" select="collection/bookversion"/>
                            </xsl:call-template>
                            <xsl:text>&#x20;</xsl:text>
                        </xsl:if>
                        <xsl:call-template name="DoCollectionEdition"/>
                        <xsl:choose>
                            <xsl:when test="collection/collVol">
                                <xsl:text>&#x20;</xsl:text>
                                <xsl:value-of select="normalize-space(collection/collVol)"/>
                                <xsl:text>:</xsl:text>
                                <xsl:value-of select="normalize-space(collection/collPages)"/>
                                <xsl:text>. </xsl:text>
                            </xsl:when>
                            <xsl:when test="collection/collPages">
                                <xsl:if test="collection/collVol">
                                    <xsl:text>,</xsl:text>
                                </xsl:if>
                                <xsl:text>&#x20;</xsl:text>
                                <xsl:value-of select="normalize-space(collection/collPages)"/>
                                <xsl:text>. </xsl:text>
                            </xsl:when>
                            <!--                                        <xsl:otherwise>
                                <xsl:text>.</xsl:text>
                                </xsl:otherwise>
                            -->
                        </xsl:choose>
                        <xsl:if test="collection/seriesEd">
                            <xsl:call-template name="DoEdPlural">
                                <xsl:with-param name="editor" select="collection/seriesEd"/>
                            </xsl:call-template>
                            <xsl:text>&#x20;</xsl:text>
                        </xsl:if>
                        <xsl:if test="collection/series">
                            <i>
                                <xsl:apply-templates select="collection/series"/>
                            </i>
                            <xsl:choose>
                                <xsl:when test="collection/bVol">
                                    <xsl:text>&#x20;</xsl:text>
                                    <xsl:apply-templates select="collection/bVol"/>
                                    <xsl:text>.&#x20;</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="OutputPeriodIfNeeded">
                                        <xsl:with-param name="sText" select="collection/series"/>
                                    </xsl:call-template>
                                    <xsl:text>&#x20;</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:if>
                        <xsl:if test="collection/multivolumeWork">
                            <i>
                                <xsl:apply-templates select="collection/multivolumeWork"/>
                            </i>
                            <xsl:text>.&#x20;</xsl:text>
                        </xsl:if>
                        <xsl:choose>
                            <xsl:when test="collection/location">
                                <xsl:text>&#x20;</xsl:text>
                                <xsl:value-of select="collection/location"/>
                                <xsl:text>: </xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>&#x20;</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:if test="collection/publisher">
                            <xsl:apply-templates select="collection/publisher"/>
                            <xsl:call-template name="OutputPeriodIfNeeded">
                                <xsl:with-param name="sText" select="collection/publisher"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:call-template name="DoReprintInfo">
                    <xsl:with-param name="reprintInfo" select="collection/reprintInfo"/>
                </xsl:call-template>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="collection"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                dissertation
            -->
            <xsl:if test="dissertation">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <i>
                        <xsl:apply-templates select="refTitle"/>
                    </i>
                    <xsl:text>. </xsl:text>
                </xsl:if>
                <xsl:call-template name="OutputLabel">
                    <xsl:with-param name="sDefault" select="$sPhDDissertationDefaultLabel"/>
                    <xsl:with-param name="pLabel">
                        <xsl:choose>
                            <xsl:when test="string-length(normalize-space(dissertation/@labelDissertation)) &gt; 0">
                                <xsl:value-of select="dissertation/@labelDissertation"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="//references/@labelDissertation"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
                <xsl:text>. </xsl:text>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="dissertation/location">
                    <xsl:text>(</xsl:text>
                    <xsl:apply-templates select="dissertation/location"/>
                    <xsl:text>).  </xsl:text>
                </xsl:if>
                <xsl:apply-templates select="dissertation/institution"/>
                <xsl:text>.</xsl:text>
                <xsl:if test="dissertation/published">
                    <xsl:text>  Published by </xsl:text>
                    <xsl:apply-templates select="dissertation/published/location"/>
                    <xsl:text>: </xsl:text>
                    <xsl:apply-templates select="dissertation/published/publisher"/>
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="normalize-space(dissertation/published/pubDate)"/>
                    <xsl:text>.</xsl:text>
                    <xsl:call-template name="DoReprintInfo">
                        <xsl:with-param name="reprintInfo" select="dissertation/published/reprintInfo"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="dissertation"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                journal article
            -->
            <xsl:if test="article">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:text>&#x20;</xsl:text>
                </xsl:if>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <i>
                    <xsl:apply-templates select="article/jTitle"/>
                    <xsl:text>&#x20;</xsl:text>
                    <xsl:value-of select="normalize-space(article/jVol)"/>
                    <xsl:if test="article/jIssueNumber">
                        <xsl:text>(</xsl:text>
                        <xsl:value-of select="article/jIssueNumber"/>
                        <xsl:text>)</xsl:text>
                    </xsl:if>
                    <xsl:choose>
                        <xsl:when test="article/jPages">
                            <xsl:text>:</xsl:text>
                            <xsl:value-of select="normalize-space(article/jPages)"/>
                        </xsl:when>
                        <xsl:when test="article/jArticleNumber">
                            <xsl:text>-</xsl:text>
                            <xsl:value-of select="normalize-space(article/jArticleNumber)"/>
                        </xsl:when>
                    </xsl:choose>
                </i>
                <xsl:text>.</xsl:text>
                <xsl:call-template name="DoReprintInfo">
                    <xsl:with-param name="reprintInfo" select="article/reprintInfo"/>
                </xsl:call-template>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="article"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                field notes
            -->
            <xsl:if test="fieldNotes">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:text>&#x20;</xsl:text>
                </xsl:if>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="fieldNotes/location">
                    <xsl:text> (</xsl:text>
                    <xsl:apply-templates select="fieldNotes/location"/>
                    <xsl:text>).  </xsl:text>
                </xsl:if>
                <xsl:apply-templates select="fieldNotes/institution"/>
                <xsl:text>.</xsl:text>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="fieldNotes"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                ms (manuscript)
            -->
            <xsl:if test="ms">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:text>&#x20;</xsl:text>
                </xsl:if>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="ms/location">
                    <xsl:text> (</xsl:text>
                    <xsl:apply-templates select="ms/location"/>
                    <xsl:text>).  </xsl:text>
                </xsl:if>
                <xsl:apply-templates select="ms/institution"/>
                <xsl:if test="ms/msVersion">
                    <xsl:apply-templates select="ms/msVersion"/>
                    <xsl:text>.  </xsl:text>
                </xsl:if>
                <xsl:text> Manuscript.</xsl:text>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="ms"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                paper
            -->
            <xsl:if test="paper">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                </xsl:if>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:call-template name="OutputPaperLabel"/>
                <xsl:value-of select="normalize-space(paper/conference)"/>
                <xsl:if test="paper/location">
                    <xsl:text>, </xsl:text>
                    <xsl:apply-templates select="paper/location"/>
                </xsl:if>
                <xsl:text>.</xsl:text>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="paper"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                proceedings
            -->
            <xsl:if test="proceedings">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                </xsl:if>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="proceedings/procCitation">
                        <xsl:text>  In </xsl:text>
                        <xsl:variable name="citation" select="proceedings/procCitation"/>
                        <xsl:choose>
                            <xsl:when test="saxon:node-set($collOrProcVolumesToInclude)/refWork[@id=$citation/@refToBook]">
                                <xsl:call-template name="DoRefCitation">
                                    <xsl:with-param name="citation" select="$citation"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="FleshOutRefCitation">
                                    <xsl:with-param name="citation" select="$citation"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="proceedings/procEd">
                                <xsl:text>  In </xsl:text>
                                <xsl:call-template name="DoEdPlural">
                                    <xsl:with-param name="editor" select="proceedings/procEd"/>
                                </xsl:call-template>
                                <xsl:text>&#x20;</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>&#x20;</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                        <i>
                            <xsl:value-of select="normalize-space(proceedings/procTitle)"/>
                        </i>
                        <xsl:choose>
                            <xsl:when test="proceedings/procVol">
                                <xsl:text>&#x20;</xsl:text>
                                <xsl:value-of select="normalize-space(proceedings/procVol)"/>
                                <xsl:text>:</xsl:text>
                                <xsl:value-of select="normalize-space(proceedings/procPages)"/>
                                <xsl:text>. </xsl:text>
                            </xsl:when>
                            <xsl:when test="proceedings/procPages">
                                <xsl:text>, </xsl:text>
                                <xsl:value-of select="normalize-space(proceedings/procPages)"/>
                                <xsl:text>. </xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>. </xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:if test="proceedings/seriesEd">
                            <xsl:call-template name="DoEdPlural">
                                <xsl:with-param name="editor" select="proceedings/seriesEd"/>
                            </xsl:call-template>
                            <xsl:text>&#x20;</xsl:text>
                        </xsl:if>
                        <xsl:if test="proceedings/series">
                            <i>
                                <xsl:apply-templates select="proceedings/series"/>
                            </i>
                            <xsl:choose>
                                <xsl:when test="proceedings/bVol">
                                    <xsl:text>&#x20;</xsl:text>
                                    <xsl:apply-templates select="proceedings/bVol"/>
                                    <xsl:text>. </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="OutputPeriodIfNeeded">
                                        <xsl:with-param name="sText" select="proceedings/series"/>
                                    </xsl:call-template>
                                    <xsl:text>&#x20;</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:if>
                        <xsl:if test="proceedings/multivolumeWork">
                            <i>
                                <xsl:apply-templates select="proceedings/multivolumeWork"/>
                            </i>
                            <xsl:text>.&#x20;</xsl:text>
                        </xsl:if>
                        <xsl:if test="proceedings/location or proceedings/publisher">
                            <xsl:apply-templates select="proceedings/location"/>
                            <xsl:if test="proceedings/publisher">
                                <xsl:text>: </xsl:text>
                                <xsl:apply-templates select="proceedings/publisher"/>
                            </xsl:if>
                            <xsl:text>.</xsl:text>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:call-template name="DoReprintInfo">
                    <xsl:with-param name="reprintInfo" select="proceedings/reprintInfo"/>
                </xsl:call-template>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="proceedings"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                thesis
            -->
            <xsl:if test="thesis">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <i>
                        <xsl:apply-templates select="refTitle"/>
                    </i>
                    <xsl:text>. </xsl:text>
                </xsl:if>
                <xsl:call-template name="OutputLabel">
                    <xsl:with-param name="sDefault" select="$sMAThesisDefaultLabel"/>
                    <xsl:with-param name="pLabel">
                        <xsl:choose>
                            <xsl:when test="string-length(normalize-space(thesis/@labelThesis)) &gt; 0">
                                <xsl:value-of select="thesis/@labelThesis"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="//references/@labelThesis"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
                <xsl:text>. </xsl:text>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="thesis/location">
                    <xsl:text> (</xsl:text>
                    <xsl:apply-templates select="thesis/location"/>
                    <xsl:text>).  </xsl:text>
                </xsl:if>
                <xsl:apply-templates select="thesis/institution"/>
                <xsl:text>.</xsl:text>
                <xsl:if test="thesis/published">
                    <xsl:text>  Published by </xsl:text>
                    <xsl:apply-templates select="thesis/published/location"/>
                    <xsl:text>: </xsl:text>
                    <xsl:apply-templates select="thesis/published/publisher"/>
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="normalize-space(thesis/published/pubDate)"/>
                    <xsl:text>.</xsl:text>
                </xsl:if>
                <xsl:call-template name="DoReprintInfo">
                    <xsl:with-param name="reprintInfo" select="thesis/published/reprintInfo"/>
                </xsl:call-template>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="thesis"/>
                </xsl:call-template>
            </xsl:if>
            <!--
                webPage
            -->
            <xsl:if test="webPage">
                <xsl:variable name="sTitle" select="normalize-space(refTitle)"/>
                <xsl:if test="string-length($sTitle) &gt; 0">
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:text>&#x20;</xsl:text>
                </xsl:if>
                <xsl:if test="../@showAuthorName='no'">
                    <xsl:call-template name="DoDate">
                        <xsl:with-param name="works" select="$works"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="webPage/edition">
                    <xsl:apply-templates select="webPage/edition"/>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="webPage/edition"/>
                    </xsl:call-template>
                    <xsl:text>&#x20;</xsl:text>
                </xsl:if>
                <xsl:if test="webPage/location">
                    <xsl:apply-templates select="webPage/location"/>
                    <xsl:text>: </xsl:text>
                </xsl:if>
                <xsl:if test="webPage/institution">
                    <xsl:apply-templates select="webPage/institution"/>
                    <xsl:text>. </xsl:text>
                </xsl:if>
                <xsl:if test="webPage/publisher">
                    <xsl:apply-templates select="webPage/publisher"/>
                </xsl:if>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="webPage"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:call-template name="DoRefUrlEtc">
                <xsl:with-param name="path" select="."/>
            </xsl:call-template>
            <xsl:variable name="sDOI" select="normalize-space(descendant::doi)"/>
            <xsl:if test="string-length($sDOI) &gt; 0">
                <xsl:text> doi:</xsl:text>
                <a href="https://doi.org/{translate($sDOI,$sStripFromUrl,'')}">
                    <xsl:value-of select="$sDOI"/>
                </a>
                <xsl:text>.</xsl:text>
            </xsl:if>
            <xsl:apply-templates select="descendant-or-self::comment"/>
        </p>
    </xsl:template>
    <!--  
        DoRefWorks
    -->
<!--    <xsl:template name="DoRefWorks">
        <xsl:variable name="thisAuthor" select="."/>
        <xsl:variable name="works"
            select="refWork[@id=$citations[not(ancestor::comment) and not(ancestor::annotation)][not(ancestor::refWork) or ancestor::refWork[@id=$citations[not(ancestor::refWork)]/@ref]]/@ref] | $refWorks[@id=saxon:node-set($collOrProcVolumesToInclude)/refWork/@id][parent::refAuthor=$thisAuthor] | refWork[@id=$citationsInAnnotationsReferredTo[not(ancestor::comment)]/@ref]"/>
        <xsl:for-each select="$works">
            <xsl:call-template name="DoRefWork">
                <xsl:with-param name="works" select="$works"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
-->    <!--  
        DoType
    -->
    <xsl:template name="DoType">
        <xsl:param name="type" select="@type"/>
        <xsl:for-each select="key('TypeID',$type)">
            <xsl:call-template name="OutputFontAttributes">
                <xsl:with-param name="language" select="."/>
            </xsl:call-template>
            <xsl:call-template name="DoNestedTypes">
                <xsl:with-param name="sList" select="@types"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--  
        DoInterlinearRefCitation
    -->
    <xsl:template name="DoInterlinearRefCitation">
        <xsl:param name="sRef"/>
        <a>
            <xsl:call-template name="DoInterlinearTextReferenceLink">
                <xsl:with-param name="sRef" select="$sRef"/>
                <xsl:with-param name="sExtension" select="'htm'"/>
            </xsl:call-template>
            <xsl:call-template name="DoInterlinearRefCitationContent">
                <xsl:with-param name="sRef" select="$sRef"/>
            </xsl:call-template>
        </a>
    </xsl:template>
    <!--  
        DoWrappableInterlinearLineGroup
    -->
    <xsl:template name="DoWrappableInterlinearLineGroup">
        <xsl:param name="mode"/>
        <xsl:param name="bHasExampleHeading"/>
        <xsl:param name="bListsShareSameCode"/>
        <xsl:param name="originalContext"/>
        <xsl:if test="(count(ancestor::interlinear) + count(ancestor::listInterlinear)) &gt; 1">
            <xsl:if test="$mode='NoTextRef' or  ../preceding-sibling::*[1][name()!='free' and name()!='literal']">
                <p/>
            </xsl:if>
        </xsl:if>
        <xsl:variable name="sLeftIndent">
            <xsl:choose>
                <xsl:when test="../preceding-sibling::*[1][name()='free' or name()='literal'] or count(ancestor::interlinear) &gt; 1">
                    <xsl:text>0.8</xsl:text>
                </xsl:when>
                <xsl:when test="preceding-sibling::*[1][name()='lineGroup']">
                    <xsl:text>1</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>0.25</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text>em</xsl:text>
        </xsl:variable>
        <xsl:variable name="iColCount">
            <xsl:call-template name="GetMaxColumnCountForLineGroup">
                <xsl:with-param name="bListsShareSameCode" select="'Y'"/>
            </xsl:call-template>
        </xsl:variable>
        <div class="itxwrap" style="padding-left:{$sLeftIndent};">
            <xsl:choose>
                <xsl:when test="line/wrd">
                    <xsl:variable name="bRtl">
                        <xsl:choose>
                            <xsl:when test="id(line[1]/wrd/langData[1]/@lang)/@rtl='yes'">Y</xsl:when>
                            <xsl:otherwise>N</xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    <xsl:if test="$bRtl='Y'">
                        <xsl:attribute name="class">itxwrap rtl</xsl:attribute>
                    </xsl:if>
                    <xsl:for-each select="line[count(wrd)=$iColCount][1]/wrd">
                        <xsl:call-template name="BoxUpWrdsInAllLinesInLineGroup">
                            <xsl:with-param name="originalContext" select="$originalContext"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <!-- uses langData or gloss with #PCDATA -->
                    <xsl:variable name="bFlip">
                        <xsl:choose>
                            <xsl:when test="id(line[1]/langData[1]/@lang)/@rtl='yes'">Y</xsl:when>
                            <xsl:otherwise>N</xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    <xsl:if test="$bFlip='Y'">
                        <xsl:attribute name="class">itxwrap rtl</xsl:attribute>
                    </xsl:if>
                    <xsl:for-each select="line[1]">
                        <xsl:variable name="lang">
                            <xsl:call-template name="GetLangInNonWrdLine"/>
                        </xsl:variable>
                        <xsl:call-template name="DoNonWrdInterlinearLineAsWrappable">
                            <xsl:with-param name="sList" select="."/>
                            <xsl:with-param name="lang" select="$lang"/>
                            <xsl:with-param name="bFlip" select="'N'"/>
                            <xsl:with-param name="iPosition" select="1"/>
                            <xsl:with-param name="iMaxColumns" select="$iColCount"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
                <xsl:if test="$sInterlinearSourceStyle='AfterFirstLine'">
                    <xsl:call-template name="OutputInterlinearTextReference">
                        <xsl:with-param name="sRef" select="../@textref"/>
                        <xsl:with-param name="sSource" select="../interlinearSource"/>
                    </xsl:call-template>
                </xsl:if>
        </div>
    </xsl:template>
    <!--  
        DoNestedTypes
    -->
    <xsl:template name="DoNestedTypes">
        <xsl:param name="sList"/>
        <xsl:variable name="sNewList" select="concat(normalize-space($sList),' ')"/>
        <xsl:variable name="sFirst" select="substring-before($sNewList,' ')"/>
        <xsl:variable name="sRest" select="substring-after($sNewList,' ')"/>
        <xsl:if test="string-length($sFirst) &gt; 0">
            <xsl:call-template name="DoType">
                <xsl:with-param name="type" select="$sFirst"/>
            </xsl:call-template>
            <xsl:if test="$sRest">
                <xsl:call-template name="DoNestedTypes">
                    <xsl:with-param name="sList" select="$sRest"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <!--  
        FleshOutRefCitation
    -->
    <xsl:template name="FleshOutRefCitation">
        <xsl:param name="citation"/>
        <xsl:variable name="citedWork" select="key('RefWorkID',$citation/@refToBook)"/>
        <xsl:call-template name="ConvertLastNameFirstNameToFirstNameLastName">
            <xsl:with-param name="sCitedWorkAuthor" select="$citedWork/../@name"/>
        </xsl:call-template>
        <xsl:choose>
            <xsl:when test="$citedWork/authorRole">
                <xsl:text>, </xsl:text>
                <xsl:value-of select="$citedWork/authorRole"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="$citedWork/authorRole"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>.  </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="DoBook">
            <xsl:with-param name="book" select="$citedWork/book"/>
            <xsl:with-param name="pages" select="$citation/@page"/>
        </xsl:call-template>
    </xsl:template>
    <!--  
        ForceItalicsInContentsTitle
    -->
    <xsl:template name="ForceItalicsInContentsTitle">
        <span style="font-style:italic;">
            <xsl:value-of select="."/>
        </span>
    </xsl:template>
    <!--
        HandleColumnWidth
    -->
    <xsl:template name="HandleColumnWidth">
        <xsl:param name="sWidth"/>
        <xsl:if test="string-length($sWidth) &gt; 0">
            <xsl:attribute name="style">
                <xsl:text>width:</xsl:text>
                <xsl:value-of select="$sWidth"/>
            </xsl:attribute>
        </xsl:if>
    </xsl:template>
    <!--  
        HandleEndnoteInBackMatter
    -->
    <xsl:template name="HandleEndnoteInBackMatter">
        <xsl:param name="originalContext"/>
        <xsl:param name="iTablenumberedAdjust" select="0"/>
        <xsl:choose>
            <xsl:when test="$originalContext and ancestor::interlinear-text">
                <!-- do nothing for an interlinearRef containing an endnote -->
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$bIsBook">
                    <xsl:choose>
                        <xsl:when test="$originalContext">
                            <xsl:for-each select="$originalContext">
                                <xsl:variable name="chapterOrAppendixUnit"
                                    select="ancestor::chapter | ancestor::appendix | ancestor::chapterInCollection | ancestor::chapterBeforePart | ancestor::glossary | ancestor::acknowledgements | ancestor::preface | ancestor::abstract"/>
                                <xsl:call-template name="DoBookEndnotesLabeling">
                                    <xsl:with-param name="originalContext" select="$originalContext"/>
                                    <xsl:with-param name="chapterOrAppendixUnit" select="$chapterOrAppendixUnit"/>
                                </xsl:call-template>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:variable name="chapterOrAppendixUnit"
                                select="ancestor::chapter | ancestor::appendix | ancestor::chapterInCollection | ancestor::chapterBeforePart | ancestor::glossary | ancestor::acknowledgements | ancestor::preface | ancestor::abstract"/>
                            <xsl:call-template name="DoBookEndnotesLabeling">
                                <xsl:with-param name="originalContext" select="$originalContext"/>
                                <xsl:with-param name="chapterOrAppendixUnit" select="$chapterOrAppendixUnit"/>
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <tr>
                    <td valign="top">
                        <a>
                            <xsl:attribute name="name">
                                <xsl:value-of select="@id"/>
                            </xsl:attribute>
                            <xsl:text>[</xsl:text>
                            <xsl:call-template name="GetFootnoteNumber">
                                <xsl:with-param name="originalContext" select="$originalContext"/>
                                <xsl:with-param name="iTablenumberedAdjust" select="$iTablenumberedAdjust"/>
                            </xsl:call-template>
                            <xsl:text>]</xsl:text>
                        </a>
                    </td>
                    <td>
                        <xsl:apply-templates/>
                    </td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        HandleListWordLangDataOrGloss
    -->
    <xsl:template name="HandleListWordLangDataOrGloss">
        <xsl:param name="bListsShareSameCode"/>
        <xsl:call-template name="OutputListLevelISOCode">
            <xsl:with-param name="bListsShareSameCode" select="$bListsShareSameCode"/>
        </xsl:call-template>
        <xsl:for-each select="(langData | gloss)">
            <td>
                <xsl:attribute name="style">
                    <xsl:value-of select="$sExampleCellPadding"/>
                </xsl:attribute>
                <xsl:apply-templates select="."/>
            </td>
        </xsl:for-each>
    </xsl:template>
    <!--  
        HandleOutputSection
    -->
    <xsl:template name="HandleOutputSection">
        <xsl:param name="sLevel" select="'h2'"/>
        <xsl:param name="sFontSize"/>
        <xsl:choose>
            <xsl:when test="parent::*[@subsectionsAreShort='yes']">
                <p>
                    <xsl:call-template name="OutputSection"/>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="{$sLevel}">
                    <xsl:if test="string-length($sFontSize) &gt; 0">
                        <xsl:attribute name="style">
                            <xsl:text>font-size:</xsl:text>
                            <xsl:value-of select="$sFontSize"/>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:call-template name="OutputSection"/>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
      HandleSmallCaps
   -->
    <xsl:template name="HandleSmallCaps">
        <xsl:attribute name="style">
            <xsl:text>font-variant:small-caps; </xsl:text>
        </xsl:attribute>
    </xsl:template>
    <!--
        OutputAbbreviationInCommaSeparatedList
    -->
    <xsl:template name="OutputAbbreviationInCommaSeparatedList">
        <a name="{@id}">
            <xsl:call-template name="OutputAbbrTerm">
                <xsl:with-param name="abbr" select="."/>
            </xsl:call-template>
            <xsl:text> = </xsl:text>
            <xsl:call-template name="OutputAbbrDefinition">
                <xsl:with-param name="abbr" select="."/>
            </xsl:call-template>
        </a>
        <xsl:choose>
            <xsl:when test="position() = last()">
                <xsl:text>.</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>, </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        OutputAbbreviationInTable
    -->
    <xsl:template name="OutputAbbreviationInTable">
        <xsl:param name="abbrsShownHere"/>
        <tr>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($abbrsShownHere/@abbrWidth)"/>
                </xsl:call-template>
                <a name="{@id}">
                    <xsl:call-template name="OutputAbbrTerm">
                        <xsl:with-param name="abbr" select="."/>
                    </xsl:call-template>
                </a>
            </td>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($abbrsShownHere/@equalsWidth)"/>
                </xsl:call-template>
                <xsl:text> = </xsl:text>
            </td>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($abbrsShownHere/@definitionWidth)"/>
                </xsl:call-template>
                <xsl:call-template name="OutputAbbrDefinition">
                    <xsl:with-param name="abbr" select="."/>
                </xsl:call-template>
            </td>
        </tr>
    </xsl:template>
    <!--
        OutputAbbreviationsInTable
    -->
    <xsl:template name="OutputAbbreviationsInTable">
        <xsl:param name="abbrsUsed"
            select="//abbreviation[not(ancestor::chapterInCollection/backMatter/abbreviations)][//abbrRef[not(ancestor::chapterInCollection/backMatter/abbreviations) and not(ancestor::comment)]/@abbr=@id]"/>
        <xsl:if test="count($abbrsUsed) &gt; 0">
            <table>
                <xsl:call-template name="SortAbbreviationsInTable">
                    <xsl:with-param name="abbrsUsed" select="$abbrsUsed"/>
                </xsl:call-template>
            </table>
        </xsl:if>
    </xsl:template>
    <!--
        Dummy templates used in common file
    -->
    <xsl:template name="LinkAttributesBegin"/>
    <xsl:template name="LinkAttributesEnd"/>
    <!--
      OutputAbbrTerm
   -->
    <xsl:template name="OutputAbbrTerm">
        <xsl:param name="abbr"/>
        <span>
            <xsl:variable name="sFontAttributes">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="$abbreviations"/>
                    <xsl:with-param name="ignoreFontFamily">
                        <xsl:choose>
                            <xsl:when test="$abbr/@ignoreabbreviationsfontfamily='yes'">
                                <xsl:text>Y</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>N</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:if test="$abbreviations/@usesmallcaps='yes' or string-length($sFontAttributes) &gt; 0">
                <xsl:attribute name="style">
                    <xsl:if test="$abbreviations/@usesmallcaps='yes'">
                        <xsl:text>font-variant:small-caps; </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="$sFontAttributes"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="string-length($abbrLang) &gt; 0">
                    <xsl:choose>
                        <xsl:when test="string-length($abbr//abbrInLang[@lang=$abbrLang]/abbrTerm) &gt; 0">
                            <xsl:apply-templates select="$abbr/abbrInLang[@lang=$abbrLang]/abbrTerm" mode="Use"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- a language is specified, but this abbreviation does not have anything; try using the default;
                                this assumes that something is better than nothing -->
                            <xsl:apply-templates select="$abbr/abbrInLang[1]/abbrTerm" mode="Use"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <!--  no language specified; just use the first one -->
                    <xsl:apply-templates select="$abbr/abbrInLang[1]/abbrTerm" mode="Use"/>
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    <!--  
                  OutputChapterNumber
-->
    <xsl:template name="OutputChapterNumber">
        <xsl:choose>
            <xsl:when test="name()='chapter' or name()='chapterInCollection'">
                <xsl:apply-templates select="." mode="numberChapter"/>
            </xsl:when>
            <xsl:when test="name()='chapterBeforePart'">
                <xsl:text>0</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="numberAppendix"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        OutputAppendixTOC
    -->
    <xsl:template name="OutputAppendixTOC">
        <xsl:param name="nLevel"/>
        <li>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:if test="ancestor::chapterInCollection">
                    <xsl:apply-templates select="ancestor::chapterInCollection" mode="numberChapter"/>
                    <xsl:text>.</xsl:text>
                </xsl:if>
                <xsl:apply-templates select="." mode="numberAppendix"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                <xsl:apply-templates select="secTitle" mode="contents"/>
            </xsl:element>
            <xsl:choose>
                <xsl:when test="section1">
                    <ul>
                        <xsl:call-template name="OutputAllSectionTOC">
                            <xsl:with-param name="nLevel">
                                <xsl:value-of select="$nLevel"/>
                            </xsl:with-param>
                            <xsl:with-param name="nodesSection1" select="section1"/>
                        </xsl:call-template>
                    </ul>
                </xsl:when>
                <xsl:when test="section2">
                    <ul>
                        <xsl:call-template name="OutputAllSectionTOC">
                            <xsl:with-param name="nLevel">
                                <xsl:value-of select="$nLevel"/>
                            </xsl:with-param>
                            <xsl:with-param name="nodesSection1" select="section2"/>
                        </xsl:call-template>
                    </ul>
                </xsl:when>
            </xsl:choose>
        </li>
    </xsl:template>
    <!--  
      OutputBackgroundColor
   -->
    <xsl:template name="OutputBackgroundColor">
        <xsl:if test="string-length(@backgroundcolor) &gt; 0">
            <xsl:text>; background-color:</xsl:text>
            <xsl:value-of select="@backgroundcolor"/>
            <xsl:text>; </xsl:text>
        </xsl:if>
    </xsl:template>
    <!--  
        OutputChapterInCollectionBackMatterContents
    -->
    <xsl:template name="OutputChapterInCollectionBackMatterContents">
        <xsl:param name="nLevel"/>
        <xsl:for-each select="backMatter/acknowledgements">
            <li>
                <a href="#{$sAcknowledgementsID}.{ancestor::chapterInCollection/@id}">
                    <xsl:call-template name="OutputAcknowledgementsLabel"/>
                </a>
            </li>
        </xsl:for-each>
        <xsl:for-each select="backMatter/appendix">
            <xsl:call-template name="OutputAppendixTOC">
                <xsl:with-param name="nLevel" select="$nLevel"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:for-each select="backMatter/glossary">
            <li>
                <xsl:variable name="iPos" select="position()"/>
                <a href="#{$sGlossaryID}{$iPos}.{ancestor::chapterInCollection/@id}">
                    <xsl:call-template name="OutputGlossaryLabel"/>
                </a>
            </li>
        </xsl:for-each>
        <xsl:for-each select="backMatter/endnotes">
            <li>
                <a href="#{$sEndnotesID}.{ancestor::chapterInCollection/@id}">
                    <xsl:call-template name="OutputEndnotesLabel"/>
                </a>
            </li>
        </xsl:for-each>
        <xsl:for-each select="backMatter/references">
            <li>
                <a href="#{$sReferencesID}.{ancestor::chapterInCollection/@id}">
                    <xsl:call-template name="OutputReferencesLabel"/>
                </a>
            </li>
        </xsl:for-each>
    </xsl:template>
    <!--  
        OutputChapterLabel
    -->
    <xsl:template name="OutputChapterLabel">
        <xsl:choose>
            <xsl:when test="string-length(normalize-space($lingPaper/@chapterlabel)) &gt; 0">
                <xsl:value-of select="$lingPaper/@chapterlabel"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Chapter</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
                  OutputChapTitle
-->
    <xsl:template name="OutputChapTitle">
        <xsl:param name="sNumber"/>
        <xsl:param name="sTitle"/>
        <xsl:param name="fSecTitleApplyTemplates" select="'N'"/>
        <p>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <big>
                <big>
                    <big>
                        <b>
                            <xsl:if test="string-length(@id) &gt; 0">
                                <a name="{@id}"/>
                            </xsl:if>
                            <xsl:if test="$sNumber">
                                <xsl:value-of select="$sNumber"/>
                                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                            </xsl:if>
                            <xsl:choose>
                                <xsl:when test="$fSecTitleApplyTemplates ='Y' and ancestor-or-self::chapter">
                                    <xsl:apply-templates select="secTitle"/>
                                </xsl:when>
                                <xsl:when test="$fSecTitleApplyTemplates ='Y' and ancestor-or-self::appendix">
                                    <xsl:apply-templates select="secTitle"/>
                                </xsl:when>
                                <xsl:when test="$fSecTitleApplyTemplates ='Y' and ancestor-or-self::chapterInCollection">
                                    <xsl:apply-templates select="frontMatter/title" mode="showChapterInCollectionTitle"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$sTitle"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </b>
                    </big>
                </big>
            </big>
        </p>
    </xsl:template>
    <!--
        OutputComment
    -->
    <xsl:template name="OutputComment">
        <span style="background-color:yellow;">
            <xsl:apply-templates/>
        </span>
    </xsl:template>
    <!--
        OutputContentsBackMatter
    -->
    <xsl:template name="OutputContentsBackMatter">
        <xsl:param name="nLevel"/>
        <xsl:for-each select="//appendix[not(ancestor::chapterInCollection)]">
            <xsl:call-template name="OutputAppendixTOC">
                <xsl:with-param name="nLevel" select="$nLevel"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:if test="//acknowledgements[parent::backMatter][not(ancestor::chapterInCollection)]">
            <li>
                <a href="#{$sAcknowledgementsID}">
                    <xsl:call-template name="OutputAcknowledgementsLabel"/>
                </a>
            </li>
        </xsl:if>
        <xsl:if test="//glossary[not(ancestor::chapterInCollection)]">
            <xsl:for-each select="//glossary[not(ancestor::chapterInCollection)]">
                <li>
                    <xsl:variable name="iPos" select="position()"/>
                    <a href="#{$sGlossaryID}{$iPos}">
                        <xsl:call-template name="OutputGlossaryLabel"/>
                    </a>
                </li>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test="//endnote[not(ancestor::chapterInCollection)]">
            <li>
                <a href="#{$sEndnotesID}">
                    <xsl:for-each select="//endnotes[not(ancestor::chapterInCollection)]">
                        <xsl:call-template name="OutputEndnotesLabel"/>
                    </xsl:for-each>
                </a>
            </li>
        </xsl:if>
        <xsl:for-each select="//references[not(ancestor::chapterInCollection)]">
            <xsl:variable name="authors" select="$otherAuthors | $gtAuthors"/>
            <xsl:if test="$authors">
                <li>
                    <a href="#{$sReferencesID}">
                        <xsl:call-template name="OutputReferencesLabel"/>
                    </a>
                </li>
            </xsl:if>
        </xsl:for-each>
        <xsl:if test="//keywordsShownHere[@showincontents='yes' and parent::backMatter and not(ancestor::chapterInCollection)]">
            <li>
                <a href="#{$sKeywordsInBackMatterID}">
                    <xsl:for-each select="//keywordsShownHere[parent::backMatter and not(ancestor::chapterInCollection)]">
                        <xsl:call-template name="OutputKeywordsLabel"/>
                    </xsl:for-each>
                </a>
            </li>
        </xsl:if>
        <xsl:for-each select="//index">
            <li>
                <a>
                    <xsl:attribute name="href">
                        <xsl:text>#</xsl:text>
                        <xsl:call-template name="CreateIndexID"/>
                    </xsl:attribute>
                    <xsl:call-template name="OutputIndexLabel"/>
                </a>
            </li>
        </xsl:for-each>
    </xsl:template>
    <!--
        OutputContentsFrontMatter
    -->
    <xsl:template name="OutputContentsFrontMatter">
        <xsl:if test="//keywordsShownHere[@showincontents='yes' and parent::frontMatter][not(ancestor::chapterInCollection)]">
            <li>
                <a href="#{$sKeywordsInFrontMatterID}">
                    <xsl:for-each select="//keywordsShownHere[@showincontents='yes' and parent::frontMatter and not(ancestor::chapterInCollection)]">
                        <xsl:call-template name="OutputKeywordsLabel"/>
                    </xsl:for-each>
                </a>
            </li>
        </xsl:if>
        <xsl:if test="//acknowledgements[parent::frontMatter][not(ancestor::chapterInCollection)]">
            <li>
                <a href="#{$sAcknowledgementsID}">
                    <xsl:call-template name="OutputAcknowledgementsLabel"/>
                </a>
            </li>
        </xsl:if>
        <xsl:for-each select="//abstract[not(ancestor::chapterInCollection)]">
            <li>
                <a href="#{$sAbstractID}{count(preceding-sibling::abstract)}">
                    <xsl:call-template name="OutputAbstractLabel"/>
                </a>
            </li>
        </xsl:for-each>
        <xsl:if test="//preface[not(ancestor::chapterInCollection)]">
            <xsl:for-each select="//preface">
                <li>
                    <a href="#{$sPrefaceID}{count(preceding-sibling::preface)}">
                        <xsl:call-template name="OutputPrefaceLabel"/>
                    </a>
                </li>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    <!--
        OutputContentsPart
    -->
    <xsl:template name="OutputContentsPart">
        <xsl:param name="nLevel"/>
        <xsl:variable name="part" select="."/>
        <xsl:variable name="precedingVolume" select="preceding-sibling::*[1][name()='volume']"/>
        <xsl:if test="$precedingVolume">
            <xsl:call-template name="OutputVolumeInContents">
                <xsl:with-param name="volume" select="$precedingVolume"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="position()=1">
            <xsl:for-each select="preceding-sibling::*[name()='chapterBeforePart']">
                <xsl:call-template name="OutputAllChapterTOC">
                    <xsl:with-param name="nLevel">
                        <xsl:value-of select="$nLevel"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:if>
        <li>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:apply-templates select="." mode="numberPart"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                <xsl:apply-templates select="secTitle"/>
            </xsl:element>
        </li>
        <ul>
            <xsl:for-each select="chapter | chapterInCollection">
                <xsl:call-template name="OutputAllChapterTOC">
                    <xsl:with-param name="nLevel">
                        <xsl:value-of select="$nLevel"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:for-each>
        </ul>
    </xsl:template>
    <!--
        OutputCssSpecial
    -->
    <xsl:template name="OutputCssSpecial">
        <xsl:param name="fDoStyleAttribute" select="'Y'"/>
        <xsl:param name="fDoBackgroundColor" select="'Y'"/>
        <xsl:choose>
            <xsl:when test="string-length(normalize-space(@cssSpecial)) &gt; 0">
                <xsl:choose>
                    <xsl:when test="$fDoStyleAttribute='Y'">
                        <xsl:attribute name="style">
                            <xsl:value-of select="@cssSpecial"/>
                            <xsl:if test="$fDoBackgroundColor='Y'">
                                <xsl:call-template name="OutputBackgroundColor"/>
                            </xsl:if>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>; </xsl:text>
                        <xsl:value-of select="@cssSpecial"/>
                        <xsl:if test="$fDoBackgroundColor='Y'">
                            <xsl:call-template name="OutputBackgroundColor"/>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$fDoBackgroundColor='Y'">
                    <xsl:choose>
                        <xsl:when test="$fDoStyleAttribute='Y' and string-length(@backgroundcolor) &gt; 0">
                            <xsl:attribute name="style">
                                <xsl:call-template name="OutputBackgroundColor"/>
                            </xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="OutputBackgroundColor"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
                   OutputEndnoteNumber
-->
    <xsl:template name="OutputEndnoteNumber">
        <xsl:param name="attr" select="@id"/>
        <xsl:param name="node" select="."/>
        <xsl:param name="originalContext"/>
        <span style="font-size:65%; vertical-align:super">
            <xsl:call-template name="InsertCommaBetweenConsecutiveEndnotes"/>
            <xsl:text>[</xsl:text>
            <a>
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="$attr"/>
                </xsl:attribute>
                <xsl:variable name="iTablenumberedAdjust">
                    <xsl:choose>
                        <xsl:when test="ancestor::tablenumbered and $lingPaper/@tablenumberedLabelAndCaptionLocation='after'">
                            <xsl:choose>
                                <xsl:when test="ancestor::caption">
                                    <xsl:value-of select="count(ancestor::tablenumbered/table/descendant::*[name()!='caption']/descendant::endnote)"/>
                                </xsl:when>
                                <xsl:when test="ancestor::table">
                                    <xsl:value-of select="-count(ancestor::tablenumbered/table/caption/descendant::endnote)"/>
                                </xsl:when>
                                <xsl:otherwise>0</xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>0</xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <xsl:call-template name="GetFootnoteNumber">
                    <xsl:with-param name="originalContext" select="$originalContext"/>
                    <xsl:with-param name="iTablenumberedAdjust" select="$iTablenumberedAdjust"/>
                </xsl:call-template>
            </a>
            <xsl:text>]</xsl:text>
        </span>
    </xsl:template>
    <!--  
                  OutputExampleNumber
-->
    <xsl:template name="OutputExampleNumber">
        <xsl:element name="a">
            <xsl:attribute name="name">
                <xsl:value-of select="../../@num"/>
            </xsl:attribute>
            <xsl:text>(</xsl:text>
            <xsl:call-template name="GetExampleNumber">
                <xsl:with-param name="example" select="."/>
            </xsl:call-template>
            <xsl:text>)</xsl:text>
        </xsl:element>
    </xsl:template>
    <!--  
        OutputFigureLabelAndCaption
    -->
    <xsl:template name="OutputFigureLabelAndCaption">
        <xsl:param name="bDoBold" select="'Y'"/>
        <xsl:param name="bDoStyles" select="'Y'"/>
        <span>
            <xsl:if test="$bDoBold='Y'">
                <xsl:attribute name="style">
                    <xsl:text>font-weight:bold;</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:call-template name="OutputFigureLabel"/>
            <!--            <xsl:apply-templates select="." mode="figure"/>-->
            <xsl:call-template name="GetFigureNumber">
                <xsl:with-param name="figure" select="."/>
            </xsl:call-template>
            <xsl:text>&#xa0;</xsl:text>
        </span>
        <xsl:choose>
            <xsl:when test="$bDoStyles='Y'">
                <xsl:apply-templates select="caption" mode="show"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="caption" mode="contents"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
                  OutputFontAttributes
-->
    <xsl:template name="OutputFontAttributes">
        <xsl:param name="language"/>
        <xsl:param name="ignoreFontFamily" select="'N'"/>
        <xsl:if test="string-length(normalize-space($language/@font-family)) &gt; 0 and $ignoreFontFamily='N'">
            <xsl:text>font-family:</xsl:text>
            <xsl:value-of select="$language/@font-family"/>
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:if test="string-length(normalize-space($language/@font-size)) &gt; 0">
            <xsl:text>font-size:</xsl:text>
            <xsl:value-of select="$language/@font-size"/>
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:if test="string-length(normalize-space($language/@font-style)) &gt; 0">
            <xsl:text>font-style:</xsl:text>
            <xsl:value-of select="$language/@font-style"/>
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:if test="string-length(normalize-space($language/@font-variant)) &gt; 0">
            <xsl:text>font-variant:</xsl:text>
            <xsl:value-of select="$language/@font-variant"/>
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:if test="string-length(normalize-space($language/@font-weight)) &gt; 0">
            <xsl:text>font-weight:</xsl:text>
            <xsl:value-of select="$language/@font-weight"/>
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:if test="string-length(normalize-space($language/@color)) &gt; 0">
            <xsl:text>color:</xsl:text>
            <xsl:value-of select="$language/@color"/>
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:if test="string-length(normalize-space($language/@backgroundcolor)) &gt; 0">
            <xsl:text>; background-color:</xsl:text>
            <xsl:value-of select="$language/@backgroundcolor"/>
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:variable name="sCssSpecial" select="normalize-space(@cssSpecial)"/>
        <xsl:if test="string-length($sCssSpecial) &gt; 0">
            <xsl:value-of select="$sCssSpecial"/>
            <xsl:if test="substring($sCssSpecial,string-length($sCssSpecial)) != ';'">
                <xsl:text>; </xsl:text>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <!--
        OutputGlossaryTerm
    -->
    <xsl:template name="OutputGlossaryTerm">
        <xsl:param name="glossaryTerm"/>
        <xsl:param name="bIsRef" select="'Y'"/>
        <xsl:param name="glossaryTermRef"/>
        <span>
            <xsl:variable name="sFontAttributes">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="$glossaryTerms"/>
                    <xsl:with-param name="ignoreFontFamily">
                        <xsl:choose>
                            <xsl:when test="$glossaryTerm/@ignoreglossarytermsfontfamily='yes'">
                                <xsl:text>Y</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>N</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:if test="string-length($sFontAttributes) &gt; 0">
                <xsl:attribute name="style">
                    <xsl:value-of select="$sFontAttributes"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:call-template name="OutputGlossaryTermContentInContext">
                <xsl:with-param name="glossaryTerm" select="$glossaryTerm"/>
                <xsl:with-param name="bIsRef" select="$bIsRef"/>
                <xsl:with-param name="glossaryTermRef" select="$glossaryTermRef"/>
            </xsl:call-template>
        </span>
    </xsl:template>
    <!--
        OutputGlossaryTermInDefinitionList
    -->
    <xsl:template name="OutputGlossaryTermInDefinitionList">
        <xsl:param name="glossaryTermsShownHere"/>
        <xsl:variable name="sThisHangingIndent"/>
        <xsl:variable name="sThisInitialIndent"/>
        <p>
            <xsl:attribute name="style">
                <xsl:call-template name="OutputCssSpecial">
                    <xsl:with-param name="fDoStyleAttribute" select="'N'"/>
                </xsl:call-template>
                <xsl:text>; padding-left:</xsl:text>
                <xsl:choose>
                    <xsl:when test="string-length($sThisHangingIndent) &gt; 0">
                        <xsl:value-of select="$sThisHangingIndent"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>1em</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>; text-indent:-</xsl:text>
                <xsl:choose>
                    <xsl:when test="string-length($sThisInitialIndent) &gt; 0">
                        <xsl:value-of select="$sThisInitialIndent"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="string-length($sThisHangingIndent) &gt; 0">
                                <xsl:value-of select="$sThisHangingIndent"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>1em</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <a name="{@id}">
                <xsl:call-template name="OutputGlossaryTerm">
                    <xsl:with-param name="glossaryTerm" select="."/>
                    <xsl:with-param name="bIsRef" select="'N'"/>
                </xsl:call-template>
            </a>
            <xsl:text>: </xsl:text>
            <xsl:call-template name="OutputGlossaryTermDefinition">
                <xsl:with-param name="glossaryTerm" select="."/>
            </xsl:call-template>
        </p>
    </xsl:template>
    <!--
        OutputGlossaryTermInTable
    -->
    <xsl:template name="OutputGlossaryTermInTable">
        <xsl:param name="glossaryTermsShownHere"/>
        <tr>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($glossaryTermsShownHere/@glossaryTermWidth)"/>
                </xsl:call-template>
                <a name="{@id}">
                    <xsl:call-template name="OutputGlossaryTerm">
                        <xsl:with-param name="glossaryTerm" select="."/>
                        <xsl:with-param name="bIsRef" select="'N'"/>
                    </xsl:call-template>
                </a>
            </td>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($glossaryTermsShownHere/@equalsWidth)"/>
                </xsl:call-template>
                <xsl:text> = </xsl:text>
            </td>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($glossaryTermsShownHere/@definitionWidth)"/>
                </xsl:call-template>
                <xsl:call-template name="OutputGlossaryTermDefinition">
                    <xsl:with-param name="glossaryTerm" select="."/>
                </xsl:call-template>
            </td>
        </tr>
    </xsl:template>
    <!--
        OutputGlossaryTermsAsDefinitionList
    -->
    <xsl:template name="OutputGlossaryTermsAsDefinitionList">
        <xsl:param name="glossaryTermsUsed"
            select="//glossaryTerm[not(ancestor::chapterInCollection/backMatter/glossaryTerms)][//glossaryTermRef[not(ancestor::chapterInCollection/backMatter/glossaryTerms)]/@glossaryTerm=@id]"/>
        <xsl:if test="count($glossaryTermsUsed) &gt; 0">
            <div>
                <xsl:call-template name="SortGlossaryTermsAsDefinitionList">
                    <xsl:with-param name="glossaryTermsUsed" select="$glossaryTermsUsed"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    <!--
        OutputGlossaryTermsInTable
    -->
    <xsl:template name="OutputGlossaryTermsInTable">
        <xsl:param name="glossaryTermsUsed"
            select="//glossaryTerm[not(ancestor::chapterInCollection/backMatter/glossaryTerms)][//glossaryTermRef[not(ancestor::chapterInCollection/backMatter/glossaryTerms)]/@glossaryTerm=@id]"/>
        <xsl:if test="count($glossaryTermsUsed) &gt; 0">
            <table>
                <xsl:call-template name="SortGlossaryTermsInTable">
                    <xsl:with-param name="glossaryTermsUsed" select="$glossaryTermsUsed"/>
                </xsl:call-template>
            </table>
        </xsl:if>
    </xsl:template>

    <!--
                   OutputIndexedItemsRange
-->
    <xsl:template name="OutputIndexedItemsRange">
        <xsl:param name="sIndexedItemID"/>
        <xsl:variable name="sBeginSectionNumber">
            <!-- output section number of lowest-level section containing the indexedItem -->
            <xsl:call-template name="OutputIndexedItemsSectionNumber"/>
        </xsl:variable>
        <a href="#{$sIndexedItemID}">
            <xsl:value-of select="$sBeginSectionNumber"/>
        </a>
        <xsl:if test="name()='indexedRangeBegin'">
            <xsl:variable name="sBeginId" select="@id"/>
            <!-- only use first one because that's all there should be -->
            <xsl:variable name="indexedRangeEnd" select="//indexedRangeEnd[@begin=$sBeginId][not(ancestor::comment)][1]"/>
            <xsl:variable name="sEndSectionNumber">
                <xsl:for-each select="$indexedRangeEnd[not(ancestor::comment)]">
                    <xsl:call-template name="OutputIndexedItemsSectionNumber"/>
                </xsl:for-each>
            </xsl:variable>
            <xsl:if test="$sEndSectionNumber != $sBeginSectionNumber">
                <!-- only output range if the start and end differ -->
                <xsl:text>-</xsl:text>
                <xsl:variable name="sIndexedEndItemID">
                    <xsl:for-each select="$indexedRangeEnd[not(ancestor::comment)]">
                        <xsl:call-template name="CreateIndexedItemID">
                            <xsl:with-param name="sTermId" select="@begin"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:variable>
                <a href="#{$sIndexedEndItemID}">
                    <xsl:value-of select="$sEndSectionNumber"/>
                </a>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <!--
                   OutputIndexedItemsSectionNumber
-->
    <xsl:template name="OutputIndexedItemsSectionNumber">
        <xsl:choose>
            <xsl:when test="ancestor::section6">
                <xsl:for-each select="ancestor::section6">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section5">
                <xsl:for-each select="ancestor::section5">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section4">
                <xsl:for-each select="ancestor::section4">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section3">
                <xsl:for-each select="ancestor::section3">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section2">
                <xsl:for-each select="ancestor::section2">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section1">
                <xsl:for-each select="ancestor::section1">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::chapter">
                <xsl:apply-templates select="ancestor::chapter" mode="number"/>
            </xsl:when>
            <xsl:when test="ancestor::chapterInCollection">
                <xsl:apply-templates select="ancestor::chapterInCollection" mode="number"/>
            </xsl:when>
            <xsl:when test="ancestor::chapterBeforePart">
                <xsl:text>0</xsl:text>
            </xsl:when>
            <xsl:when test="ancestor::appendix">
                <xsl:for-each select="ancestor::appendix">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::part">
                <xsl:apply-templates select="ancestor::part" mode="numberPart"/>
            </xsl:when>
            <xsl:when test="ancestor::abbreviations">
                <xsl:for-each select="ancestor::abbreviations">
                    <xsl:call-template name="OutputAbbreviationsLabel"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::abstract">
                <xsl:for-each select="ancestor::abstract">
                    <xsl:call-template name="OutputAbstractLabel"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::acknowledgements">
                <xsl:for-each select="ancestor::acknowledgements">
                    <xsl:call-template name="OutputAcknowledgementsLabel"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::glosary">
                <xsl:for-each select="ancestor::glossary">
                    <xsl:call-template name="OutputGlossaryLabel"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::preface">
                <xsl:for-each select="ancestor::preface">
                    <xsl:call-template name="OutputPrefaceLabel"/>
                </xsl:for-each>
            </xsl:when>
        </xsl:choose>
        <xsl:if test="ancestor::endnote">
            <xsl:text>n</xsl:text>
        </xsl:if>
    </xsl:template>
    <!--
                   OutputIndexTerms
-->
    <xsl:template name="OutputIndexTerms">
        <xsl:param name="sIndexKind"/>
        <xsl:param name="lang"/>
        <xsl:param name="terms"/>
        <xsl:variable name="indexTermsToShow" select="$terms/indexTerm[@kind=$sIndexKind or @kind='subject' and $sIndexKind='common' or count(//index)=1]"/>
        <xsl:if test="$indexTermsToShow">
            <div style="margin-left: 0.5in; margin-right: 0.5in">
                <!-- force line break so we can more effectively use a line-oriented differences tool -->
                <xsl:text>&#xA;</xsl:text>
                <xsl:for-each select="$indexTermsToShow">
                    <xsl:sort lang="{$lang}" select="term[@lang=$lang or position()=1 and not (following-sibling::term[@lang=$lang])]"/>
                    <xsl:variable name="sTermId" select="@id"/>
                    <!-- if a nested index term is cited, we need to be sure to show its parents, even if they are not cited -->
                    <xsl:variable name="bHasCitedDescendant">
                        <xsl:for-each select="descendant::indexTerm">
                            <xsl:variable name="sDescendantTermId" select="@id"/>
                            <xsl:if test="//indexedItem[@term=$sDescendantTermId][not(ancestor::comment)] or //indexedRangeBegin[@term=$sDescendantTermId][not(ancestor::comment)]">
                                <xsl:text>Y</xsl:text>
                            </xsl:if>
                            <xsl:if test="@see">
                                <xsl:call-template name="CheckSeeTargetIsCitedOrItsDescendantIsCited"/>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:variable>
                    <xsl:variable name="indexedItems" select="//indexedItem[@term=$sTermId][not(ancestor::comment)] | //indexedRangeBegin[@term=$sTermId][not(ancestor::comment)]"/>
                    <xsl:variable name="bHasSeeAttribute">
                        <xsl:if test="string-length(@see) &gt; 0">
                            <xsl:text>Y</xsl:text>
                        </xsl:if>
                    </xsl:variable>
                    <xsl:variable name="bSeeTargetIsCitedOrItsDescendantIsCited">
                        <xsl:if test="$bHasSeeAttribute='Y'">
                            <xsl:call-template name="CheckSeeTargetIsCitedOrItsDescendantIsCited"/>
                        </xsl:if>
                    </xsl:variable>
                    <xsl:choose>
                        <xsl:when test="$indexedItems or contains($bHasCitedDescendant,'Y')">
                            <!-- this term or one its descendants is cited; show it -->
                            <a>
                                <xsl:attribute name="name">
                                    <xsl:call-template name="CreateIndexTermID">
                                        <xsl:with-param name="sTermId" select="$sTermId"/>
                                    </xsl:call-template>
                                </xsl:attribute>
                                <xsl:call-template name="OutputIndexTermsTerm">
                                    <xsl:with-param name="lang" select="$lang"/>
                                    <xsl:with-param name="indexTerm" select="."/>
                                </xsl:call-template>
                                <xsl:text>&#xa0;&#xa0;</xsl:text>
                            </a>
                            <xsl:for-each select="$indexedItems">
                                <!-- show each reference -->
                                <xsl:variable name="sIndexedItemID">
                                    <xsl:call-template name="CreateIndexedItemID">
                                        <xsl:with-param name="sTermId" select="$sTermId"/>
                                    </xsl:call-template>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="@main='yes' and count($indexedItems) &gt; 1">
                                        <b>
                                            <xsl:call-template name="OutputIndexedItemsRange">
                                                <xsl:with-param name="sIndexedItemID" select="$sIndexedItemID"/>
                                            </xsl:call-template>
                                        </b>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:call-template name="OutputIndexedItemsRange">
                                            <xsl:with-param name="sIndexedItemID" select="$sIndexedItemID"/>
                                        </xsl:call-template>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:if test="position()!=last()">
                                    <xsl:text>, </xsl:text>
                                </xsl:if>
                            </xsl:for-each>
                            <xsl:if test="$bHasSeeAttribute='Y' and contains($bSeeTargetIsCitedOrItsDescendantIsCited, 'Y')">
                                <!-- this term also has a @see attribute which refers to a term that is cited or whose descendant is cited -->
                                <xsl:call-template name="OutputIndexTermSeeBefore">
                                    <xsl:with-param name="indexedItems" select="$indexedItems"/>
                                </xsl:call-template>
                                <a>
                                    <xsl:attribute name="href">
                                        <xsl:text>#</xsl:text>
                                        <xsl:call-template name="CreateIndexTermID">
                                            <xsl:with-param name="sTermId" select="@see"/>
                                        </xsl:call-template>
                                    </xsl:attribute>
                                    <xsl:apply-templates select="key('IndexTermID',@see)/term[@lang=$lang or position()=1 and not (following-sibling::term[@lang=$lang])]" mode="InIndex"/>
                                </a>
                                <xsl:call-template name="OutputIndexTermSeeAfter">
                                    <xsl:with-param name="indexedItems" select="$indexedItems"/>
                                </xsl:call-template>
                            </xsl:if>
                            <br/>
                            <xsl:call-template name="OutputIndexTerms">
                                <xsl:with-param name="sIndexKind" select="$sIndexKind"/>
                                <xsl:with-param name="lang" select="$lang"/>
                                <xsl:with-param name="terms" select="indexTerms"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="$bHasSeeAttribute='Y' and contains($bSeeTargetIsCitedOrItsDescendantIsCited, 'Y')">
                            <!-- neither this term nor its decendants are cited, but it has a @see attribute which refers to a term that is cited or for which one of its descendants is cited -->
                            <!--                            <xsl:apply-templates select="term[1]" mode="InIndex"/>-->
                            <xsl:apply-templates select="term[@lang=$lang or position()=1 and not (following-sibling::term[@lang=$lang])]" mode="InIndex"/>
                            <xsl:text>,</xsl:text>
                            <xsl:call-template name="OutputIndexTermSeeAloneBefore"/>
                            <a>
                                <xsl:attribute name="href">
                                    <xsl:text>#</xsl:text>
                                    <xsl:call-template name="CreateIndexTermID">
                                        <xsl:with-param name="sTermId" select="@see"/>
                                    </xsl:call-template>
                                </xsl:attribute>
                                <xsl:call-template name="OutputIndexTermsTerm">
                                    <xsl:with-param name="lang" select="$lang"/>
                                    <xsl:with-param name="indexTerm" select="key('IndexTermID',@see)"/>
                                </xsl:call-template>
                            </a>
                            <xsl:call-template name="OutputIndexTermSeeAloneAfter"/>
                            <br/>
                            <!-- force line break so we can more effectively use a line-oriented differences tool -->
                            <xsl:text>&#xA;</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    <!--  
                  OutputInterlinear
-->
    <xsl:template name="OutputInterlinear">
        <xsl:param name="mode"/>
        <xsl:choose>
            <xsl:when test="lineSet">
                <xsl:for-each select="lineSet | conflation">
                    <xsl:call-template name="ApplyTemplatesPerTextRefMode">
                        <xsl:with-param name="mode" select="$mode"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="ApplyTemplatesPerTextRefMode">
                    <xsl:with-param name="mode" select="$mode"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        OutputInterlinearLineTableCellContent
    -->
    <xsl:template name="OutputInterlinearLineTableCellContent">
        <xsl:param name="lang"/>
        <xsl:param name="sFirst"/>
        <xsl:variable name="glossLayout" select="$contentLayoutInfo/glossLayout"/>
        <span>
            <xsl:attribute name="style">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',$lang)"/>
                    <xsl:with-param name="originalContext" select="$sFirst"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:value-of select="$sFirst"/>
        </span>
    </xsl:template>
    <!--  
                  OutputInterlinearTextReference
-->
    <xsl:template name="OutputInterlinearTextReference">
        <xsl:param name="sRef"/>
        <xsl:param name="sSource"/>
        <xsl:if test="string-length(normalize-space($sRef)) &gt; 0 or $sSource">
            <xsl:choose>
                <xsl:when test="$bAutomaticallyWrapInterlinears='yes'">
                    <div class="itxitem">
                        <span>
                            <xsl:call-template name="OutputInterlinearTextReferenceContent">
                                <xsl:with-param name="sSource" select="$sSource"/>
                                <xsl:with-param name="sRef" select="$sRef"/>
                            </xsl:call-template>
                        </span>
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <td>
                        <xsl:text disable-output-escaping="yes">&#xa0;&#xa0;</xsl:text>
                        <!--            <xsl:text disable-output-escaping="no">&#xa0;&#xa0;</xsl:text>-->
                    </td>
                    <td>
                        <xsl:call-template name="OutputInterlinearTextReferenceContent">
                            <xsl:with-param name="sSource" select="$sSource"/>
                            <xsl:with-param name="sRef" select="$sRef"/>
                        </xsl:call-template>
                    </td>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <!--  
        OutputInterlinearTextReferenceContent
    -->
    <xsl:template name="OutputInterlinearTextReferenceContent">
        <xsl:param name="sSource"/>
        <xsl:param name="sRef"/>
        <xsl:text>[</xsl:text>
        <xsl:choose>
            <xsl:when test="$sSource">
                <!--                  <xsl:value-of select="$sSource"/>-->
                <xsl:apply-templates select="$sSource" mode="contents"/>
            </xsl:when>
            <xsl:when test="string-length(normalize-space($sRef)) &gt; 0">
                <xsl:call-template name="DoInterlinearRefCitation">
                    <xsl:with-param name="sRef" select="$sRef"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
        <xsl:text>]</xsl:text>
    </xsl:template>
    <!--
        OutputISO639-3CodeInCommaSeparatedList
    -->
    <xsl:template name="OutputISO639-3CodeInCommaSeparatedList">
        <a name="{@id}">
            <xsl:value-of select="@ISO639-3Code"/>
            <xsl:text> = </xsl:text>
            <xsl:call-template name="OutputISO639-3CodeLanguageName">
                <xsl:with-param name="language" select="."/>
            </xsl:call-template>
        </a>
        <xsl:choose>
            <xsl:when test="position() = last()">
                <xsl:text>.</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>, </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        OutputISO639-3CodeInTable
    -->
    <xsl:template name="OutputISO639-3CodeInTable">
        <xsl:param name="codesShownHere"/>
        <tr>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($codesShownHere/@codeWidth)"/>
                </xsl:call-template>
                <a name="{@id}">
                    <xsl:value-of select="@ISO639-3Code"/>
                </a>
            </td>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($codesShownHere/@equalsWidth)"/>
                </xsl:call-template>
                <xsl:text> = </xsl:text>
            </td>
            <td valign="top">
                <xsl:call-template name="HandleColumnWidth">
                    <xsl:with-param name="sWidth" select="normalize-space($codesShownHere/@languageNameWidth)"/>
                </xsl:call-template>
                <xsl:call-template name="OutputISO639-3CodeLanguageName">
                    <xsl:with-param name="language" select="."/>
                </xsl:call-template>
            </td>
        </tr>
    </xsl:template>
    <!--
        OutputISO639-3CodesInTable
    -->
    <xsl:template name="OutputISO639-3CodesInTable">
        <xsl:param name="codesUsed"
            select="//language[//iso639-3codeRef[not(ancestor::chapterInCollection)]/@lang=@id or //lineGroup/line[1]/descendant::langData[1][not(ancestor::chapterInCollection)]/@lang=@id or //word/langData[1][not(ancestor::chapterInCollection)]/@lang=@id or //listWord/langData[1][not(ancestor::chapterInCollection)]/@lang=@id]"/>
        <xsl:if test="count($codesUsed) &gt; 0">
            <table>
                <xsl:call-template name="SortISO639-3CodesInTable">
                    <xsl:with-param name="codesUsed" select="$codesUsed"/>
                </xsl:call-template>
            </table>
        </xsl:if>
    </xsl:template>

    <!--
        OutputISOCodeInExample
    -->
    <xsl:template name="OutputISOCodeInExample">
        <xsl:param name="sIsoCode"/>
        <xsl:param name="bOutputBreak" select="'Y'"/>
        <xsl:choose>
            <xsl:when test="string-length($sIsoCode) &gt; 0">
                <xsl:if test="$bOutputBreak='Y'">
                    <br/>
                </xsl:if>
                <span style="font-size:smaller">
                    <xsl:choose>
                        <xsl:when test="$bShowISO639-3Codes='Y'">
                            <a href="#{$languages[@ISO639-3Code=$sIsoCode]/@id}">
                                <xsl:text>[</xsl:text>
                                <xsl:value-of select="$sIsoCode"/>
                                <xsl:text>]</xsl:text>
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>[</xsl:text>
                            <xsl:value-of select="$sIsoCode"/>
                            <xsl:text>]</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="firstLangData" select="descendant::langData[1] | key('InterlinearReferenceID',interlinearRef/@textref)[1]/descendant::langData[1]"/>
                <xsl:if test="$firstLangData">
                    <xsl:variable name="sIsoCode2" select="key('LanguageID',$firstLangData/@lang)/@ISO639-3Code"/>
                    <xsl:if test="string-length($sIsoCode2) &gt; 0">
                        <xsl:if test="$bOutputBreak='Y'">
                            <br/>
                        </xsl:if>
                        <span style="font-size:smaller">
                            <xsl:choose>
                                <xsl:when test="$bShowISO639-3Codes='Y'">
                                    <a href="#{$languages[@ISO639-3Code=$sIsoCode2]/@id}">
                                        <xsl:text>[</xsl:text>
                                        <xsl:value-of select="$sIsoCode2"/>
                                        <xsl:text>]</xsl:text>
                                    </a>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>[</xsl:text>
                                    <xsl:value-of select="$sIsoCode2"/>
                                    <xsl:text>]</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </span>
                    </xsl:if>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        OutputListLevelISOCode
    -->
    <xsl:template name="OutputListLevelISOCode">
        <xsl:param name="bListsShareSameCode"/>
        <xsl:if test="$lingPaper/@showiso639-3codeininterlinear='yes' or ancestor-or-self::example/@showiso639-3codes='yes'">
            <xsl:if test="contains($bListsShareSameCode,'N')">
                <td>
                    <xsl:call-template name="OutputISOCodeInExample">
                        <xsl:with-param name="bOutputBreak" select="'N'"/>
                    </xsl:call-template>
                </td>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <!--  
                  OutputSection
-->
    <xsl:template name="OutputSection">
        <xsl:attribute name="style">
            <xsl:call-template name="DoType"/>
        </xsl:attribute>
        <xsl:element name="a">
            <xsl:attribute name="name">
                <xsl:value-of select="@id"/>
            </xsl:attribute>
        </xsl:element>
        <xsl:call-template name="OutputSectionNumberAndTitle"/>
    </xsl:template>
    <!--  
                  OutputSectionNumber
-->
    <xsl:template name="OutputSectionNumber">
        <xsl:choose>
            <xsl:when test="name()='appendix' or ancestor::appendix">
                <xsl:for-each select="ancestor::chapterInCollection">
                    <xsl:apply-templates select="." mode="numberChapter"/>
                    <xsl:text>.</xsl:text>
                </xsl:for-each>
                <xsl:apply-templates select="." mode="numberAppendix"/>
                <xsl:if test="name()='appendix'">
                    <xsl:text>.</xsl:text>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="number"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
      OutputSectionNumberAndTitle
   -->
    <xsl:template name="OutputSectionNumberAndTitle">
        <xsl:choose>
            <xsl:when test="parent::*[@subsectionsAreShort='yes']">
                <div style="font-weight:bold;">
                    <xsl:apply-templates select="secTitle"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="OutputSectionNumber"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                <xsl:apply-templates select="secTitle"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
      OutputSectionNumberAndTitleInContents
   -->
    <xsl:template name="OutputSectionNumberAndTitleInContents">
        <xsl:choose>
            <xsl:when test="parent::*[@subsectionsAreShort='yes']">
                <!-- no number should show -->
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="OutputSectionNumber"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="secTitle" mode="contents"/>
    </xsl:template>
    <!--  
                  OutputAllChapterTOC
-->
    <xsl:template name="OutputAllChapterTOC">
        <xsl:param name="nLevel" select="3"/>
        <xsl:variable name="precedingVolume" select="preceding-sibling::*[1][name()='volume']"/>
        <xsl:if test="$precedingVolume">
            <xsl:call-template name="OutputVolumeInContents">
                <xsl:with-param name="volume" select="$precedingVolume"/>
            </xsl:call-template>
        </xsl:if>
        <li>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:call-template name="OutputChapterNumber"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                <xsl:choose>
                    <xsl:when test="name()='chapterInCollection'">
                        <xsl:apply-templates select="frontMatter/title" mode="showChapterInCollectionTitle"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="secTitle" mode="contents"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
            <xsl:if test="name()='chapterInCollection' and frontMatter/author">
                <br/>
                <xsl:call-template name="GetAuthorsAsCommaSeparatedList"/>
            </xsl:if>
            <ul>
                <xsl:apply-templates select="frontMatter/abstract | frontMatter/acknowledgements | frontMatter/preface" mode="contents"/>
                <xsl:call-template name="OutputAllSectionTOC">
                    <xsl:with-param name="nLevel">
                        <xsl:value-of select="$nLevel"/>
                    </xsl:with-param>
                    <xsl:with-param name="nodesSection1" select="section1"/>
                </xsl:call-template>
                <xsl:call-template name="OutputChapterInCollectionBackMatterContents">
                    <xsl:with-param name="nLevel" select="$nLevel"/>
                </xsl:call-template>
            </ul>
        </li>
    </xsl:template>
    <!--  
                  OutputAllSectionTOC
-->
    <xsl:template name="OutputAllSectionTOC">
        <xsl:param name="nLevel" select="3"/>
        <xsl:param name="nodesSection1"/>
        <xsl:if test="$nLevel!=0">
            <xsl:for-each select="$nodesSection1">
                <xsl:call-template name="OutputSectionTOC"/>
                <xsl:if test="section2 and $nLevel>=2">
                    <ul>
                        <xsl:for-each select="section2">
                            <xsl:if test="parent::*[@subsectionsAreShort!='yes' or @excludeShortSubsectionsFromContents!='yes']">
                                <xsl:call-template name="OutputSectionTOC"/>
                                <xsl:if test="section3 and $nLevel>=3">
                                    <ul>
                                        <xsl:for-each select="section3">
                                            <xsl:if test="parent::*[@subsectionsAreShort!='yes' or @excludeShortSubsectionsFromContents!='yes']">
                                                <xsl:call-template name="OutputSectionTOC"/>
                                                <xsl:if test="section4 and $nLevel>=4">
                                                    <ul>
                                                        <xsl:for-each select="section4">
                                                            <xsl:if test="parent::*[@subsectionsAreShort!='yes' or @excludeShortSubsectionsFromContents!='yes']">
                                                                <xsl:call-template name="OutputSectionTOC"/>
                                                                <xsl:if test="section5 and $nLevel>=5">
                                                                    <ul>
                                                                        <xsl:for-each select="section5">
                                                                            <xsl:if test="parent::*[@subsectionsAreShort!='yes' or @excludeShortSubsectionsFromContents!='yes']">
                                                                                <xsl:call-template name="OutputSectionTOC"/>
                                                                                <xsl:if test="section6 and $nLevel>=6">
                                                                                    <ul>
                                                                                        <xsl:for-each select="section6">
                                                                                            <xsl:if test="parent::*[@subsectionsAreShort!='yes' or @excludeShortSubsectionsFromContents!='yes']">
                                                                                                <xsl:call-template name="OutputSectionTOC"/>
                                                                                            </xsl:if>
                                                                                        </xsl:for-each>
                                                                                    </ul>
                                                                                </xsl:if>
                                                                            </xsl:if>
                                                                        </xsl:for-each>
                                                                    </ul>
                                                                </xsl:if>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                    </ul>
                                                </xsl:if>
                                            </xsl:if>
                                        </xsl:for-each>
                                    </ul>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </ul>
                </xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    <!--  
                  OutputSectionTOC
-->
    <xsl:template name="OutputSectionTOC">
        <li>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:call-template name="OutputSectionNumberAndTitleInContents"/>
            </xsl:element>
        </li>
    </xsl:template>
    <!--  
                  OutputTable
-->
    <xsl:template name="OutputTable">
        <xsl:element name="table">
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
                <xsl:call-template name="OutputCssSpecial">
                    <xsl:with-param name="fDoStyleAttribute">N</xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="OutputBackgroundColor"/>
            </xsl:attribute>
            <xsl:if test="@border">
                <xsl:attribute name="border">
                    <xsl:value-of select="@border"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="@cellpadding">
                <xsl:attribute name="cellpadding">
                    <xsl:value-of select="@cellpadding"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="@cellspacing">
                <xsl:attribute name="cellspacing">
                    <xsl:value-of select="@cellspacing"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="caption and not(ancestor::tablenumbered)">
                <xsl:apply-templates select="caption" mode="show"/>
            </xsl:if>
            <xsl:apply-templates/>
            <xsl:if test="endCaption and not(ancestor::tablenumbered)">
                <xsl:apply-templates select="endCaption" mode="show"/>
            </xsl:if>
        </xsl:element>
    </xsl:template>
    <!--  
                  OutputTableCells
-->
    <xsl:template name="OutputTableCells">
        <xsl:param name="sList"/>
        <xsl:param name="language"/>
        <xsl:variable name="sNewList" select="concat(normalize-space($sList),' ')"/>
        <xsl:variable name="sFirst" select="substring-before($sNewList,' ')"/>
        <xsl:variable name="sRest" select="substring-after($sNewList,' ')"/>
        <xsl:element name="td">
            <xsl:attribute name="style">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',$language)"/>
                </xsl:call-template>
                <xsl:value-of select="$sExampleCellPadding"/>
            </xsl:attribute>
            <xsl:value-of select="$sFirst"/>
        </xsl:element>
        <xsl:if test="$sRest">
            <xsl:call-template name="OutputTableCells">
                <xsl:with-param name="sList" select="$sRest"/>
                <xsl:with-param name="language" select="$language"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <!--  
        OutputTableNumberedLabel
    -->
    <xsl:template name="OutputTableNumberedLabel">
        <xsl:variable name="label" select="$lingPaper/@tablenumberedLabel"/>
        <xsl:choose>
            <xsl:when test="string-length($label) &gt; 0">
                <xsl:value-of select="$label"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Table </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        OutputTableNumberedLabelAndCaption
    -->
    <xsl:template name="OutputTableNumberedLabelAndCaption">
        <xsl:param name="bDoBold" select="'Y'"/>
        <xsl:param name="bDoStyles" select="'Y'"/>
        <span>
            <xsl:if test="$bDoBold='Y'">
                <xsl:attribute name="style">
                    <xsl:text>font-weight:bold;</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:call-template name="OutputTableNumberedLabel"/>
            <!--            <xsl:apply-templates select="." mode="tablenumbered"/>-->
            <xsl:call-template name="GetTableNumberedNumber">
                <xsl:with-param name="tablenumbered" select="."/>
            </xsl:call-template>
            <xsl:text>&#xa0;</xsl:text>
        </span>
        <xsl:choose>
            <xsl:when test="$bDoStyles='Y'">
                <xsl:apply-templates select="table/caption | table/endCaption | caption" mode="show"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="table/caption | table/endCaption | caption" mode="contents"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        OutputTOCVolumeLine
    -->
    <xsl:template name="OutputTOCVolumeLine">
        <xsl:param name="sLabel"/>
        <xsl:param name="sSpaceBefore" select="'10'"/>
        <xsl:param name="sSpaceAfter" select="'10'"/>
        <xsl:param name="sIndent" select="'0pt'"/>
        <li>
            <xsl:attribute name="style">
                <xsl:text>font-weight:bold;</xsl:text>
            <xsl:if test="number($sSpaceBefore)>0">
                    <xsl:text>padding-top:12pt;</xsl:text>
            </xsl:if>
            <xsl:if test="number($sSpaceAfter)>0">
                <xsl:text>padding-bottom:12pt</xsl:text>
            </xsl:if>
            </xsl:attribute>
            <xsl:value-of select="$sLabel"/>
        </li>
    </xsl:template>
    <!--  
                  ReverseContents
-->
    <xsl:template name="ReverseContents">
        <xsl:param name="sList"/>
        <xsl:variable name="sNewList" select="concat(normalize-space($sList),' ')"/>
        <xsl:variable name="sFirst" select="substring-before($sNewList,' ')"/>
        <xsl:variable name="sRest" select="substring-after($sNewList,' ')"/>
        <xsl:if test="$sRest">
            <xsl:call-template name="ReverseContents">
                <xsl:with-param name="sList" select="$sRest"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:value-of select="$sFirst"/>
        <xsl:text>&#x20;</xsl:text>
    </xsl:template>
    <xsl:template match="interlinearSource" mode="contents">
        <xsl:apply-templates/>
    </xsl:template>
    <!--  
        SetFramedTypeItem
    -->
    <xsl:template name="SetFramedTypeItem">
        <xsl:param name="sAttributeValue"/>
        <xsl:param name="sDefaultValue"/>
        <xsl:choose>
            <xsl:when test="string-length($sAttributeValue) &gt; 0">
                <xsl:value-of select="$sAttributeValue"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$sDefaultValue"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        SetMetadata
    -->
    <xsl:template name="SetMetadata">
        <meta name="author">
            <xsl:attribute name="content">
                <xsl:call-template name="SetMetadataAuthor"/>
            </xsl:attribute>
        </meta>
        <xsl:if test="$lingPaper/frontMatter/title != ''">
            <meta name="title">
                <xsl:attribute name="content">
                    <xsl:call-template name="SetMetadataTitle"/>
                </xsl:attribute>
            </meta>
        </xsl:if>
        <xsl:if test="string-length($lingPaper/publishingInfo/keywords) &gt; 0">
            <meta name="keywords">
                <xsl:attribute name="content">
                    <xsl:call-template name="SetMetadataKeywords"/>
                </xsl:attribute>
            </meta>
        </xsl:if>
        <meta name="generator">
            <xsl:attribute name="content">
                <xsl:call-template name="SetMetadataCreator"/>
            </xsl:attribute>
        </meta>
    </xsl:template>
    <xsl:variable name="hasInterlinears">
        <xsl:choose>
            <xsl:when test="//interlinear">
                <xsl:text>Y</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>N</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <!--  
        BoxUpWrdsInAllLinesInLineGroup
    -->
    <xsl:template name="BoxUpWrdsInAllLinesInLineGroup">
        <xsl:param name="originalContext"/>
        <xsl:variable name="iPos" select="count(preceding-sibling::wrd) + 1"/>
        <div class="itxitem">
            <xsl:for-each select="../preceding-sibling::line">
                <xsl:for-each select="wrd[position()=$iPos]">
                    <xsl:call-template name="DoWrdWrap">
                        <xsl:with-param name="originalContext" select="$originalContext"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:for-each>
            <xsl:call-template name="DoWrdWrap">
                <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:call-template>
            <xsl:for-each select="../following-sibling::line">
                <xsl:for-each select="wrd[position()=$iPos]">
                    <xsl:call-template name="DoWrdWrap">
                        <xsl:with-param name="originalContext" select="$originalContext"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:for-each>
        </div>
        <!--        <xsl:if test="not($originalContext)">
            <xsl:for-each select="../preceding-sibling::line/wrd[position()=$iPos]">
            <xsl:call-template name="DoFootnoteTextWithinWrappableWrd">
            <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:call-template>
            </xsl:for-each>
            <xsl:call-template name="DoFootnoteTextWithinWrappableWrd">
            <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:call-template>
            <xsl:for-each select="../following-sibling::line/wrd[position()=$iPos]">
            <xsl:call-template name="DoFootnoteTextWithinWrappableWrd">
            <xsl:with-param name="originalContext" select="$originalContext"/>
            </xsl:call-template>
            </xsl:for-each>
            </xsl:if>-->
        <!--        <xsl:if test="position()!=last()">
            <xsl:choose>
            <xsl:when test="count(../../line) &gt; 1">
            <!-\-<tex:cmd name="XLingPaperintspace"/>-\->
            <span>&#x20;</span>
            </xsl:when>
            <xsl:otherwise>
            <xsl:text>&#x20;</xsl:text>
            </xsl:otherwise>
            </xsl:choose>
            </xsl:if>-->
    </xsl:template>
    <!--  
        CalculateColumnsInInterlinearLine
    -->
    <xsl:template name="CalculateColumnsInInterlinearLine">
        <xsl:param name="sList"/>
        <xsl:variable name="sNewList" select="concat(normalize-space($sList),' ')"/>
        <xsl:variable name="sFirst" select="substring-before($sNewList,' ')"/>
        <xsl:variable name="sRest" select="substring-after($sNewList,' ')"/>
        <xsl:text>x</xsl:text>
        <xsl:if test="$sRest">
            <xsl:call-template name="CalculateColumnsInInterlinearLine">
                <xsl:with-param name="sList" select="$sRest"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <!--  
        DoIthCellInNonWrdInterlinearLineAsWrappable
    -->
    <xsl:template name="DoIthCellInNonWrdInterlinearLineAsWrappable">
        <xsl:param name="sList"/>
        <xsl:param name="lang"/>
        <xsl:param name="iPositionToUse"/>
        <xsl:param name="iCurrentPosition"/>
        <xsl:param name="iMaxColumns"/>
        <xsl:variable name="sNewList" select="concat(normalize-space($sList),' ')"/>
        <xsl:variable name="sFirst" select="substring-before($sNewList,' ')"/>
        <xsl:choose>
            <xsl:when test="$iCurrentPosition = $iPositionToUse">
                <xsl:call-template name="OutputInterlinearLineTableCellContent">
                    <xsl:with-param name="lang" select="$lang"/>
                    <xsl:with-param name="sFirst" select="$sFirst"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="sRest" select="substring-after($sNewList,' ')"/>
                <xsl:if test="$sRest or $iCurrentPosition &lt; $iMaxColumns">
                    <xsl:call-template name="DoIthCellInNonWrdInterlinearLineAsWrappable">
                        <xsl:with-param name="sList" select="$sRest"/>
                        <xsl:with-param name="lang" select="$lang"/>
                        <xsl:with-param name="iPositionToUse" select="$iPositionToUse"/>
                        <xsl:with-param name="iCurrentPosition" select="$iCurrentPosition + 1"/>
                        <xsl:with-param name="iMaxColumns" select="$iMaxColumns"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        DoNonWrdInterlinearLineAsWrappable
    -->
    <xsl:template name="DoNonWrdInterlinearLineAsWrappable">
        <xsl:param name="sList"/>
        <xsl:param name="lang"/>
        <xsl:param name="bFlip"/>
        <xsl:param name="iPosition"/>
        <xsl:param name="iMaxColumns"/>
        <xsl:variable name="sNewList" select="concat(normalize-space($sList),' ')"/>
        <xsl:variable name="sFirst" select="substring-before($sNewList,' ')"/>
        <xsl:variable name="sRest" select="substring-after($sNewList,' ')"/>
        <xsl:variable name="iLineCountInLineGroup" select="count(../line)"/>
        <div class="itxitem">
            <div>
                <xsl:call-template name="OutputInterlinearLineTableCellContent">
                    <xsl:with-param name="lang" select="$lang"/>
                    <xsl:with-param name="sFirst" select="$sFirst"/>
                </xsl:call-template>
            </div>
            <xsl:for-each select="following-sibling::line">
                <xsl:variable name="langOfNewLine">
                    <xsl:call-template name="GetLangInNonWrdLine"/>
                </xsl:variable>
                <xsl:variable name="sOrientedContents">
                    <xsl:call-template name="GetOrientedContents">
                        <xsl:with-param name="bFlip" select="$bFlip"/>
                    </xsl:call-template>
                </xsl:variable>
                <div>
                    <xsl:call-template name="DoIthCellInNonWrdInterlinearLineAsWrappable">
                        <xsl:with-param name="sList" select="$sOrientedContents"/>
                        <xsl:with-param name="lang" select="$langOfNewLine"/>
                        <xsl:with-param name="iPositionToUse" select="$iPosition"/>
                        <xsl:with-param name="iCurrentPosition" select="1"/>
                        <xsl:with-param name="iMaxColumns" select="$iMaxColumns"/>
                    </xsl:call-template>
                </div>
            </xsl:for-each>
            <!--                <xsl:if test="$iLineCountInLineGroup &gt; 1 or not($sRest or $iPosition &lt; $iMaxColumns)">
                <tr>
                <td>
                <xsl:value-of select="$sBasicPointSize"/>
                <xsl:text>pt</xsl:text>
                </td>
                </tr>
                </xsl:if>-->
        </div>
        <xsl:if test="$sRest or $iPosition &lt; $iMaxColumns">
            <!--<xsl:choose>
                <xsl:when test="$iLineCountInLineGroup &gt; 1">
                <tex:cmd name="XLingPaperintspace"/>
                </xsl:when>
                <xsl:otherwise>
                <!-\-  if there is only one line we might as well just use spaces -\->-->
            <xsl:text>&#x20;</xsl:text>
            <!--                </xsl:otherwise>
                </xsl:choose>-->
            <xsl:call-template name="DoNonWrdInterlinearLineAsWrappable">
                <xsl:with-param name="sList" select="$sRest"/>
                <xsl:with-param name="lang" select="$lang"/>
                <xsl:with-param name="bFlip" select="$bFlip"/>
                <xsl:with-param name="iPosition" select="$iPosition + 1"/>
                <xsl:with-param name="iMaxColumns" select="$iMaxColumns"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <!--  
        DoWrdWrap
    -->
    <xsl:template name="DoWrdWrap">
        <xsl:param name="originalContext"/>
        <div>
            <xsl:choose>
                <xsl:when test="@lang">
                    <span>
                        <xsl:attribute name="style">
                            <xsl:call-template name="OutputFontAttributes">
                                <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                                <xsl:with-param name="originalContext" select="."/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <xsl:apply-templates>
                            <xsl:with-param name="originalContext" select="$originalContext"/>
                        </xsl:apply-templates>
                    </span>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates>
                        <xsl:with-param name="originalContext" select="$originalContext"/>
                    </xsl:apply-templates>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    <!--  
        GetLangInNonWrdLine
    -->
    <xsl:template name="GetLangInNonWrdLine">
        <xsl:choose>
            <xsl:when test="langData">
                <xsl:value-of select="langData/@lang"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="gloss/@lang"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        GetMaxColumnCountForLineGroup
    -->
    <xsl:template name="GetMaxColumnCountForLineGroup">
        <xsl:param name="bListsShareSameCode"/>
        <xsl:variable name="iTempCount">
            <xsl:for-each select="line | ../listWord">
                <xsl:sort select="count(wrd) + count(langData) + count(gloss)" order="descending" data-type="number"/>
                <xsl:if test="position()=1">
                    <xsl:value-of select="count(wrd) + count(langData) + count(gloss)"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test=" name()!='listWord' and $iTempCount=1 or name()!='listWord' and count(descendant::wrd)=0">
                <!-- have space-delimited langData and/or gloss line(s) -->
                <xsl:variable name="sMaxColCount">
                    <xsl:call-template name="GetMaxColumnCountForPCDATALines"/>
                </xsl:variable>
                <xsl:variable name="sIsoCode">
                    <xsl:for-each select="parent::listInterlinear">
                        <xsl:call-template name="GetISOCode"/>
                    </xsl:for-each>
                </xsl:variable>
                <!--  2011.11.16              <xsl:choose>
                    <xsl:when test="string-length($sIsoCode) = 3">-->
                <xsl:choose>
                    <xsl:when test="contains($bListsShareSameCode,'N')">
                        <xsl:value-of select="string-length($sMaxColCount)+1"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="string-length($sMaxColCount)"/>
                    </xsl:otherwise>
                </xsl:choose>
                <!-- 2011.11.16                   </xsl:when>
                    <xsl:otherwise>
                    <xsl:value-of select="string-length($sMaxColCount)"/>
                    </xsl:otherwise>
                    </xsl:choose>
                -->
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="sIsoCode">
                    <xsl:for-each select="parent::listInterlinear">
                        <xsl:call-template name="GetISOCode"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:choose>
                    <xsl:when test="contains($bListsShareSameCode,'N')">
                        <xsl:value-of select="number($iTempCount + 1)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$iTempCount"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        GetMaxColumnCountForPCDATALines
    -->
    <xsl:template name="GetMaxColumnCountForPCDATALines">
        <!-- We need to figure out the maximum number of items in the line elements.
            The maximum could be in any line since the user just keys data in them.
            We use a bit of a trick.  We put XML into a variable, with a root of <lines> and each line as <line>.
            Each line contains one x for each item in the line.  We then sort these and get the longest one.
            We use the longest one to figure out how many columns we will need.
            Note that with XSLT version 1.0, we have to use something like the Saxon extension function node-set().
        -->
        <xsl:variable name="lines">
            <lines>
                <xsl:for-each select="line | ../listWord">
                    <line>
                        <xsl:call-template name="CalculateColumnsInInterlinearLine">
                            <xsl:with-param name="sList" select="langData | gloss"/>
                        </xsl:call-template>
                    </line>
                </xsl:for-each>
            </lines>
        </xsl:variable>
        <xsl:for-each select="saxon:node-set($lines)/descendant::*">
            <xsl:for-each select="line">
                <xsl:sort select="." order="descending"/>
                <xsl:if test="position()=1">
                    <xsl:value-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>
    <!-- 
        GetOrientedContents
    -->
    <xsl:template name="GetOrientedContents">
        <xsl:param name="bFlip"/>
        <xsl:variable name="sContents">
            <!--               <xsl:apply-templates/>  Why do we want to include all the parameters, etc. when what we really want is the text? -->
            <!--                    <xsl:value-of select="."/>-->
            <xsl:value-of select="self::*[not(descendant-or-self::endnote)]"/>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$bFlip='Y'">
                <!-- flip order, left to right -->
                <xsl:call-template name="ReverseContents">
                    <xsl:with-param name="sList" select="$sContents"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="langData and id(langData/@lang)/@rtl='yes'">
                <!-- flip order, left to right -->
                <xsl:call-template name="ReverseContents">
                    <xsl:with-param name="sList" select="$sContents"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$sContents"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- ===========================================================
      ELEMENTS TO IGNORE
      =========================================================== -->
    <xsl:template match="language"/>
    <xsl:template match="interlinearSource"/>
    <xsl:template match="shortTitle"/>
    <xsl:template match="styles"/>
    <xsl:template match="style"/>
    <xsl:template match="term"/>
    <xsl:template match="type"/>
</xsl:stylesheet>
