<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:saxon="http://icl.com/saxon" exclude-result-prefixes="xhtml saxon">
    <xsl:output method="xml" version="1.0" encoding="utf-8"/>
    <!-- ===========================================================
      Parameters
      ========================================================= -->
    <!--
    The default is AfterFirstLine (immediately after the last item in the first line)
    The other possibilities are AfterFree (immediately after the free translation, on the same line)
       and UnderFree (on the line immediately after the free translation)
    -->
    <xsl:param name="sInterlinearSourceStyle">AfterFirstLine</xsl:param>
    <xsl:include href="XLingPapCommon.xsl"/>
    <xsl:include href="XLingPapCannedCommon.xsl"/>
    <xsl:include href="XLingPapXHTMLCommon.xsl"/>
    <!-- ===========================================================
      Global variables
      =========================================================== -->
    <xsl:variable name="sLdquo">&#8220;</xsl:variable>
    <xsl:variable name="sRdquo">&#8221;</xsl:variable>
    <!-- ===========================================================
      MAIN BODY
      =========================================================== -->
    <xsl:template match="//lingPaper">
        <xhtml>
            <head>
                <!--                <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>-->
                <xsl:comment> generated by XLingPapXHTML1.xsl Version <xsl:value-of select="$sVersion"/>&#x20;</xsl:comment>
                <title>
                    <xsl:variable name="sTitle">
                        <xsl:apply-templates select="frontMatter/title/child::node()[name()!='endnote']"/>
                    </xsl:variable>
                    <xsl:value-of select="$sTitle"/>
                </title>
                <style type="text/css">
               <xsl:text>.interblock { display: -moz-inline-box; display:inline-block; vertical-align: top; } </xsl:text>
            </style>
            </head>
            <body>
                <xsl:apply-templates/>
            </body>
        </xhtml>
    </xsl:template>
    <!-- ===========================================================
      FRONTMATTER
      =========================================================== -->
    <!--
      title
      -->
    <xsl:template match="title">
        <center>
            <b>
                <big>
                    <big>
                        <big>
                            <!--              <xsl:value-of select="."/> -->
                            <xsl:apply-templates/>
                        </big>
                    </big>
                </big>
            </b>
        </center>
    </xsl:template>
    <xsl:template match="subtitle">
        <center>
            <b>
                <big>
                    <big>
                        <xsl:apply-templates/>
                    </big>
                </big>
            </b>
        </center>
    </xsl:template>
    <!--
      author
      -->
    <xsl:template match="author">
        <xsl:if test="position()=1">
            <br/>
        </xsl:if>
        <center>
            <i>
                <xsl:apply-templates/>
            </i>
        </center>
    </xsl:template>
    <!--
      affiliation
      -->
    <xsl:template match="affiliation">
        <xsl:if test="position()=1">
            <br/>
        </xsl:if>
        <center>
            <i>
                <xsl:value-of select="."/>
            </i>
        </center>
    </xsl:template>
    <!--
        emailAddress
    -->
    <xsl:template match="emailAddress">
        <xsl:if test="position()=1">
            <br/>
        </xsl:if>
        <center>
            <i>
                <xsl:value-of select="."/>
            </i>
        </center>
    </xsl:template>
    <!--
      date or presentedAt
      -->
    <xsl:template match="date | presentedAt">
        <br/>
        <center>
            <small>
                <xsl:apply-templates/>
            </small>
        </center>
    </xsl:template>
    <!--
      version
      -->
    <xsl:template match="version">
        <center>
            <small>Version: <xsl:apply-templates/>
            </small>
        </center>
    </xsl:template>
    <!--
      contents
      -->
    <xsl:template match="contents">
        <hr/>
        <div>
            <center>
                <big>
                    <big>
                        <b>
                            <xsl:call-template name="OutputContentsLabel"/>
                        </b>
                    </big>
                </big>
            </center>
            <xsl:variable name="nLevel">
                <xsl:value-of select="number(@showLevel)"/>
            </xsl:variable>
            <ul>
                <xsl:if test="//acknowledgements[parent::frontMatter]">
                    <li>
                        <a href="#rXLingPapAcknowledgements">
                            <xsl:call-template name="OutputAcknowledgementsLabel"/>
                        </a>
                    </li>
                </xsl:if>
                <xsl:if test="//abstract">
                    <li>
                        <a href="#{$sAbstractID}">
                            <xsl:call-template name="OutputAbstractLabel"/>
                        </a>
                    </li>
                </xsl:if>
                <xsl:if test="//preface">
                    <xsl:for-each select="//preface">
                        <li>
                            <a href="#{$sPrefaceID}{count(preceding-sibling::preface)}">
                                <xsl:call-template name="OutputPrefaceLabel"/>
                            </a>
                        </li>
                    </xsl:for-each>
                </xsl:if>
                <xsl:if test="//part">
                    <xsl:for-each select="//part">
                        <xsl:if test="position()=1">
                            <xsl:for-each select="preceding-sibling::*[name()='chapterBeforePart']">
                                <xsl:call-template name="OutputAllChapterTOC">
                                    <xsl:with-param name="nLevel">
                                        <xsl:value-of select="$nLevel"/>
                                    </xsl:with-param>
                                </xsl:call-template>
                            </xsl:for-each>
                        </xsl:if>
                        <li>
                            <xsl:element name="a">
                                <xsl:attribute name="href">
                                    <xsl:text>#</xsl:text>
                                    <xsl:value-of select="@id"/>
                                </xsl:attribute>
                                <xsl:apply-templates select="." mode="numberPart"/>
                                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                                <xsl:apply-templates select="secTitle"/>
                            </xsl:element>
                        </li>
                        <ul>
                            <xsl:for-each select="chapter">
                                <xsl:call-template name="OutputAllChapterTOC">
                                    <xsl:with-param name="nLevel">
                                        <xsl:value-of select="$nLevel"/>
                                    </xsl:with-param>
                                </xsl:call-template>
                            </xsl:for-each>
                        </ul>
                    </xsl:for-each>
                </xsl:if>
                <!-- part -->
                <xsl:if test="not(//part) and //chapter">
                    <xsl:for-each select="//chapter">
                        <li>
                            <xsl:element name="a">
                                <xsl:attribute name="href">
                                    <xsl:text>#</xsl:text>
                                    <xsl:value-of select="@id"/>
                                </xsl:attribute>
                                <xsl:apply-templates select="." mode="numberChapter"/>
                                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                                <xsl:apply-templates select="secTitle"/>
                            </xsl:element>
                            <ul>
                                <xsl:call-template name="OutputAllSectionTOC">
                                    <xsl:with-param name="nLevel">
                                        <xsl:value-of select="$nLevel"/>
                                    </xsl:with-param>
                                    <xsl:with-param name="nodesSection1" select="section1"/>
                                </xsl:call-template>
                            </ul>
                        </li>
                    </xsl:for-each>
                </xsl:if>
                <!-- chapter -->
                <xsl:if test="not(//part) and not(//chapter)">
                    <xsl:call-template name="OutputAllSectionTOC">
                        <xsl:with-param name="nLevel">
                            <xsl:value-of select="$nLevel"/>
                        </xsl:with-param>
                        <xsl:with-param name="nodesSection1" select="//section1[not(parent::appendix)]"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:for-each select="//appendix">
                    <li>
                        <xsl:element name="a">
                            <xsl:attribute name="href">
                                <xsl:text>#</xsl:text>
                                <xsl:value-of select="@id"/>
                            </xsl:attribute>
                            <xsl:apply-templates select="." mode="numberAppendix"/>
                            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                            <xsl:apply-templates select="secTitle"/>
                        </xsl:element>
                        <xsl:choose>
                            <xsl:when test="section1">
                                <ul>
                                    <xsl:call-template name="OutputAllSectionTOC">
                                        <xsl:with-param name="nLevel">
                                            <xsl:value-of select="$nLevel"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="nodesSection1" select="section1"/>
                                    </xsl:call-template>
                                </ul>
                            </xsl:when>
                            <xsl:when test="section2">
                                <ul>
                                    <xsl:call-template name="OutputAllSectionTOC">
                                        <xsl:with-param name="nLevel">
                                            <xsl:value-of select="$nLevel"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="nodesSection1" select="section2"/>
                                    </xsl:call-template>
                                </ul>
                            </xsl:when>
                        </xsl:choose>
                    </li>
                </xsl:for-each>
                <xsl:if test="//acknowledgements[parent::backMatter]">
                    <li>
                        <a href="#rXLingPapAcknowledgements">
                            <xsl:call-template name="OutputAcknowledgementsLabel"/>
                        </a>
                    </li>
                </xsl:if>
                <xsl:if test="//glossary">
                    <xsl:for-each select="//glossary">
                        <li>
                            <xsl:variable name="iPos" select="position()"/>
                            <a href="#{$sGlossaryID}{$iPos}">
                                <xsl:call-template name="OutputGlossaryLabel"/>
                            </a>
                        </li>
                    </xsl:for-each>
                </xsl:if>
                <xsl:if test="//endnote">
                    <li>
                        <a href="#{$sEndnotesID}">
                            <xsl:call-template name="OutputEndnotesLabel"/>
                        </a>
                    </li>
                </xsl:if>
                <xsl:if test="//references">
                    <li>
                        <a href="#{$sReferencesID}">
                            <xsl:call-template name="OutputReferencesLabel"/>
                        </a>
                    </li>
                </xsl:if>
                <xsl:for-each select="//index">
                    <li>
                        <a>
                            <xsl:attribute name="href">
                                <xsl:text>#</xsl:text>
                                <xsl:call-template name="CreateIndexID"/>
                            </xsl:attribute>
                            <xsl:call-template name="OutputIndexLabel"/>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </div>
    </xsl:template>
    <!--
      abstract and acknowledgements, preface and glossary
      -->
    <xsl:template match="abstract | acknowledgements | preface | glossary">
        <br/>
        <xsl:if test="not(name(preceding-sibling::*) = 'contents')">
            <hr/>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="parent::frontMatter">
                <center>
                    <b>
                        <big>
                            <big>
                                <xsl:choose>
                                    <xsl:when test="name(.)='abstract'">
                                        <a name="$sAbstractID">
                                            <xsl:call-template name="OutputAbstractLabel"/>
                                        </a>
                                    </xsl:when>
                                    <xsl:when test="name(.)='preface'">
                                        <a name="{$sPrefaceID}{count(preceding-sibling::preface)}">
                                            <xsl:call-template name="OutputPrefaceLabel"/>
                                        </a>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <a name="rXLingPapAcknowledgements">
                                            <xsl:call-template name="OutputAcknowledgementsLabel"/>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </big>
                        </big>
                    </b>
                </center>
            </xsl:when>
            <xsl:when test="name(.)='glossary'">
                <xsl:variable name="iPos" select="count(preceding-sibling::glossary) + 1"/>
                <a name="{$sGlossaryID}{$iPos}">
                    <xsl:call-template name="OutputChapTitle">
                        <xsl:with-param name="sTitle">
                            <xsl:call-template name="OutputGlossaryLabel"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <!-- assume it is acknowledgments -->
                <a name="rXLingPapAcknowledgements">
                    <xsl:call-template name="OutputChapTitle">
                        <xsl:with-param name="sTitle">
                            <xsl:call-template name="OutputAcknowledgementsLabel"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </a>
            </xsl:otherwise>
        </xsl:choose>
        <div style="margin-left: 0.5in; margin-right: 0.5in">
            <xsl:apply-templates/>
        </div>
        <xsl:if test="position() = last()">
            <hr/>
        </xsl:if>
    </xsl:template>
    <!--
      index
      -->
    <xsl:template match="index">
        <hr/>
        <!-- force line break so we can more effectively use a line-oriented differences tool -->
        <xsl:text>&#xA;</xsl:text>
        <a>
            <xsl:attribute name="name">
                <xsl:call-template name="CreateIndexID"/>
            </xsl:attribute>
            <xsl:apply-templates/>
            <xsl:call-template name="OutputChapTitle">
                <xsl:with-param name="sTitle">
                    <xsl:call-template name="OutputIndexLabel"/>
                </xsl:with-param>
            </xsl:call-template>
        </a>
        <!-- process any paragraphs, etc. that may be at the beginning -->
        <xsl:apply-templates/>
        <!-- now process the contents of this index -->
        <xsl:variable name="sIndexKind">
            <xsl:choose>
                <xsl:when test="@kind">
                    <xsl:value-of select="@kind"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>common</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="OutputIndexTerms">
            <xsl:with-param name="sIndexKind" select="$sIndexKind"/>
            <xsl:with-param name="lang" select="$indexLang"/>
            <xsl:with-param name="terms" select="//lingPaper/indexTerms"/>
        </xsl:call-template>
    </xsl:template>
    <!--
      indexedItem or indexedRangeBegin
      -->
    <xsl:template match="indexedItem | indexedRangeBegin">
        <xsl:variable name="sTermId" select="@term"/>
        <a>
            <xsl:attribute name="name">
                <xsl:call-template name="CreateIndexedItemID">
                    <xsl:with-param name="sTermId" select="@term"/>
                </xsl:call-template>
            </xsl:attribute>
        </a>
    </xsl:template>
    <!--
      indexedRangeEnd
      -->
    <xsl:template match="indexedRangeEnd">
        <a>
            <xsl:attribute name="name">
                <xsl:call-template name="CreateIndexedItemID">
                    <xsl:with-param name="sTermId" select="@begin"/>
                </xsl:call-template>
            </xsl:attribute>
        </a>
    </xsl:template>
    <!--
      term
      -->
    <xsl:template match="term" mode="InIndex">
        <xsl:apply-templates/>
    </xsl:template>
    <!-- ===========================================================
      PARTS, CHAPTERS, SECTIONS, and APPENDICES
      =========================================================== -->
    <!--
      Part
      -->
    <xsl:template match="part">
        <hr size="3"/>
        <p>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <center>
                <big>
                    <big>
                        <big>
                            <big>
                                <big>
                                    <b>
                                        <xsl:element name="a">
                                            <xsl:attribute name="name">
                                                <xsl:value-of select="@id"/>
                                            </xsl:attribute>
                                            <xsl:apply-templates select="." mode="numberPart"/>
                                            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                                            <xsl:apply-templates select="secTitle"/>
                                        </xsl:element>
                                    </b>
                                </big>
                            </big>
                        </big>
                    </big>
                </big>
            </center>
        </p>
        <hr size="3"/>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <!--
      Chapter
      -->
    <xsl:template match="chapter | chapterBeforePart">
        <xsl:call-template name="OutputChapTitle">
            <xsl:with-param name="sNumber">
                <xsl:call-template name="OutputChapterNumber"/>
            </xsl:with-param>
            <xsl:with-param name="sTitle">
                <xsl:apply-templates select="secTitle"/>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <!--
      Sections
      -->
    <xsl:template match="section1">
        <h1>
            <xsl:call-template name="OutputSection"/>
        </h1>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section2">
        <h2>
            <xsl:call-template name="OutputSection"/>
        </h2>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section3">
        <h3>
            <xsl:call-template name="OutputSection"/>
        </h3>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section4">
        <h4>
            <xsl:call-template name="OutputSection"/>
        </h4>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section5">
        <h5 style="font-size:100%">
            <xsl:call-template name="OutputSection"/>
        </h5>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <xsl:template match="section6">
        <h6 style="font-size:100%">
            <xsl:call-template name="OutputSection"/>
        </h6>
        <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
    </xsl:template>
    <!--
      Appendix
      -->
    <xsl:template match="appendix">
        <hr size="3"/>
        <xsl:choose>
            <xsl:when test="//chapter">
                <xsl:call-template name="OutputChapTitle">
                    <xsl:with-param name="sNumber">
                        <xsl:apply-templates select="." mode="numberAppendix"/>
                    </xsl:with-param>
                    <xsl:with-param name="sTitle">
                        <xsl:apply-templates select="secTitle"/>
                    </xsl:with-param>
                </xsl:call-template>
                <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
            </xsl:when>
            <xsl:otherwise>
                <h1>
                    <xsl:call-template name="OutputSection"/>
                </h1>
                <xsl:apply-templates select="child::node()[name()!='secTitle']"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        secTitle
    -->
    <xsl:template match="secTitle">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="secTitle" mode="contents">
        <xsl:apply-templates select="child::node()[name()!='endnote']"/>
    </xsl:template>
    <!--
        sectionRef
    -->
    <xsl:template match="sectionRef">
        <xsl:call-template name="OutputAnyTextBeforeSectionRef"/>
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showTitle"/>
        </xsl:call-template>
        <a href="#{@sec}">
            <xsl:call-template name="DoSectionRef"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showTitle"/>
        </xsl:call-template>
    </xsl:template>
    <!--
      appendixRef
      -->
    <xsl:template match="appendixRef">
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showTitle"/>
        </xsl:call-template>
        <a href="#{@app}">
            <xsl:call-template name="DoAppendixRef"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showTitle"/>
        </xsl:call-template>
    </xsl:template>
    <!--
      genericRef
      -->
    <xsl:template match="genericRef">
        <xsl:element name="a">
            <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
                <xsl:value-of select="@gref"/>
            </xsl:attribute>
            <xsl:call-template name="OutputGenericRef"/>
        </xsl:element>
    </xsl:template>
    <!--
      genericTarget
   -->
    <xsl:template match="genericTarget">
        <a name="{@id}"/>
    </xsl:template>
    <!--
      link
      -->
    <xsl:template match="link">
        <xsl:element name="a">
            <xsl:attribute name="href">
                <xsl:value-of select="@href"/>
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <!-- ===========================================================
      PARAGRAPH
      =========================================================== -->
    <xsl:template match="p | pc">
        <!--    <xsl:if test="parent::endnote and not(position()=1)">
      <tr>
        <td/>
        <td>
          <p>
            <xsl:apply-templates/>
          </p>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="not(parent::endnote) or position()=1">
    -->
        <p>
            <xsl:if test="name(.)='pc'">
                <xsl:attribute name="class">pc</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </p>
        <!--    </xsl:if> -->
    </xsl:template>
    <!-- ===========================================================
      QUOTES
      =========================================================== -->
    <xsl:template match="q">"<xsl:apply-templates/>"</xsl:template>
    <xsl:template match="blockquote">
        <div style="margin-left:.5in;margin-right:.5in">
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!-- ===========================================================
        PROSE TEXT
        =========================================================== -->
    <xsl:template match="prose-text">
        <div>
            <xsl:attribute name="style">
                <xsl:text>margin-left:.5in;margin-right:.5in;</xsl:text>
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!-- ===========================================================
      EXAMPLES
      =========================================================== -->
    <xsl:template match="example">
        <div>
            <xsl:call-template name="DoExample"/>
        </div>
    </xsl:template>
    <!--
        interlinearRef
    -->
    <xsl:template match="interlinearRef">
        <xsl:for-each select="key('InterlinearReferenceID',@textref)[1]">
            <xsl:apply-templates/>
        </xsl:for-each>
    </xsl:template>
    <!--
        interlinearRefCitation
    -->
    <xsl:template match="interlinearRefCitation[@showTitleOnly='short' or @showTitleOnly='full']">
        <!-- we do not show any brackets when these options are set -->
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showTitleOnly"/>
        </xsl:call-template>
        <a href="#{@textref}">
            <xsl:call-template name="DoInterlinearRefCitationShowTitleOnly"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showTitleOnly"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="interlinearRefCitation">
        <xsl:if test="not(@bracket) or @bracket='both' or @bracket='initial'">
            <xsl:text>[</xsl:text>
        </xsl:if>
        <xsl:variable name="interlinear" select="key('InterlinearReferenceID',@textref)"/>
        <xsl:choose>
            <xsl:when test="name($interlinear)='interlinear-text'">
                <a href="#{@textref}">
                    <xsl:choose>
                        <xsl:when test="$interlinear/textInfo/shortTitle and string-length($interlinear/textInfo/shortTitle) &gt; 0">
                            <xsl:apply-templates select="$interlinear/textInfo/shortTitle/child::node()[name()!='endnote']"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="$interlinear/textInfo/textTitle/child::node()[name()!='endnote']"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="DoInterlinearRefCitation">
                    <xsl:with-param name="sRef" select="@textref"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not(@bracket) or @bracket='both' or @bracket='final'">
            <xsl:text>]</xsl:text>
        </xsl:if>
    </xsl:template>
    <!--
      line
      -->
    <xsl:template match="line">
        <tr>
            <xsl:call-template name="DoInterlinearLine"/>
            <xsl:if test="count(preceding-sibling::line) = 0">
                <xsl:if test="$sInterlinearSourceStyle='AfterFirstLine'">
                    <xsl:call-template name="OutputInterlinearTextReference">
                        <xsl:with-param name="sRef" select="../../@textref"/>
                        <xsl:with-param name="sSource" select="../../interlinearSource"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:if>
        </tr>
    </xsl:template>
    <xsl:template match="line" mode="NoTextRef">
        <tr>
            <xsl:call-template name="DoInterlinearLine"/>
        </tr>
    </xsl:template>
    <!--
        figure
    -->
    <xsl:template match="figure">
        <div id="{@id}" align="{@align}">
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <xsl:if test="$lingPaper/@figureLabelAndCaptionLocation='before'">
                <p>
                    <xsl:call-template name="OutputFigureLabelAndCaption"/>
                </p>
            </xsl:if>
            <xsl:apply-templates select="*[name()!='caption' and name()!='shortCaption']"/>
            <xsl:if test="$lingPaper/@figureLabelAndCaptionLocation='after'">
                <p>
                    <xsl:call-template name="OutputFigureLabelAndCaption"/>
                </p>
            </xsl:if>
        </div>
    </xsl:template>
    <!--
        figureRef
    -->
    <xsl:template match="figureRef">
        <xsl:call-template name="OutputAnyTextBeforeFigureRef"/>
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showCaption"/>
        </xsl:call-template>
        <a href="#{@figure}">
            <xsl:call-template name="DoFigureRef"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showCaption"/>
        </xsl:call-template>
    </xsl:template>
    <!--
        listOfFiguresShownHere
    -->
    <xsl:template match="listOfFiguresShownHere">
        <div>
            <ul>
                <xsl:for-each select="//figure">
                    <li>
                        <a href="#{@id}">
                            <xsl:call-template name="OutputFigureLabelAndCaption">
                                <xsl:with-param name="bDoBold" select="'N'"/>
                                <xsl:with-param name="bDoStyles" select="'N'"/>
                            </xsl:call-template>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </div>
    </xsl:template>
    <!--
        tablenumbered
    -->
    <xsl:template match="tablenumbered">
        <div id="{@id}" align="{table/@align}">
            <xsl:call-template name="OutputCssSpecial">
                <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
            </xsl:call-template>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <xsl:if test="$lingPaper/@tablenumberedLabelAndCaptionLocation='before'">
                <p>
                    <xsl:call-template name="OutputTableNumberedLabelAndCaption"/>
                </p>
            </xsl:if>
            <xsl:apply-templates select="*[name()!='shortCaption']"/>
            <xsl:if test="$lingPaper/@tablenumberedLabelAndCaptionLocation='after'">
                <p>
                    <xsl:call-template name="OutputTableNumberedLabelAndCaption"/>
                </p>
            </xsl:if>
        </div>
    </xsl:template>
    <!--
        tablenumberedRef
    -->
    <xsl:template match="tablenumberedRef">
        <xsl:call-template name="OutputAnyTextBeforeTablenumberedRef"/>
        <xsl:call-template name="DoReferenceShowTitleBefore">
            <xsl:with-param name="showTitle" select="@showCaption"/>
        </xsl:call-template>
        <a href="#{@table}">
            <xsl:call-template name="DoTablenumberedRef"/>
        </a>
        <xsl:call-template name="DoReferenceShowTitleAfter">
            <xsl:with-param name="showTitle" select="@showCaption"/>
        </xsl:call-template>
    </xsl:template>
    <!--
        listOfTablesShownHere
    -->
    <xsl:template match="listOfTablesShownHere">
        <div>
            <ul>
                <xsl:for-each select="//tablenumbered">
                    <li>
                        <a href="#{@id}">
                            <xsl:call-template name="OutputTableNumberedLabelAndCaption">
                                <xsl:with-param name="bDoBold" select="'N'"/>
                                <xsl:with-param name="bDoStyles" select="'N'"/>
                            </xsl:call-template>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </div>
    </xsl:template>
    <!--
        table
    -->
    <xsl:template match="table">
        <xsl:choose>
            <xsl:when test="name(..)='example'">
                <xsl:choose>
                    <xsl:when test="preceding-sibling::exampleHeading">
                        <br style="line-height:5pt"/>
                        <xsl:call-template name="OutputTable"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <td>
                            <xsl:attribute name="style">
                                <xsl:value-of select="$sExampleCellPadding"/>
                            </xsl:attribute>
                            <xsl:call-template name="OutputTable"/>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <div>
                    <xsl:if test="string-length(normalize-space(@align)) &gt; 0">
                        <xsl:attribute name="align">
                            <xsl:value-of select="@align"/>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:call-template name="OutputCssSpecial">
                        <xsl:with-param name="fDoStyleAttribute" select="'Y'"/>
                    </xsl:call-template>
                    <xsl:call-template name="OutputTable"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="caption" mode="show">
        <xsl:choose>
            <xsl:when test="ancestor::tablenumbered or ancestor::figure">
                <span>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <td colspan="30">
                        <xsl:call-template name="DoCellAttributes"/>
                        <b>
                            <!-- default is bold -->
                            <xsl:apply-templates/>
                        </b>
                    </td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="endCaption" mode="show">
        <xsl:choose>
            <xsl:when test="ancestor::tablenumbered or ancestor::figure">
                <span>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:attribute name="style">
                        <xsl:call-template name="DoType"/>
                    </xsl:attribute>
                    <td colspan="30">
                        <xsl:call-template name="DoCellAttributes"/>
                        <b>
                            <!-- default is bold -->
                            <xsl:apply-templates/>
                        </b>
                    </td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        exampleRef
    -->
    <xsl:template match="exampleRef">
        <a>
            <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
                <xsl:choose>
                    <xsl:when test="@letter and name(id(@letter))!='example'">
                        <xsl:value-of select="@letter"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="@num">
                            <xsl:value-of select="@num"/>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:call-template name="DoExampleRefContent"/>
        </a>
    </xsl:template>
    <!--
        listDefinition
    -->
    <xsl:template match="listDefinition">
        <tr>
            <td valign="top">
                <xsl:element name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="@letter"/>
                    </xsl:attribute>
                    <xsl:apply-templates select="." mode="letter"/>.</xsl:element>
            </td>
            <xsl:for-each select="definition">
                <xsl:call-template name="DoDefinition"/>
            </xsl:for-each>
        </tr>
        <!--        </table> -->
    </xsl:template>
    <!-- ===========================================================
        ENDNOTES and ENDNOTEREFS
        =========================================================== -->
    <!--
        endnotes
    -->
    <xsl:template match="endnotes">
        <xsl:if test="//endnote">
            <hr size="3"/>
            <a name="{$sEndnotesID}">
                <xsl:call-template name="OutputChapTitle">
                    <xsl:with-param name="sTitle">
                        <xsl:call-template name="OutputEndnotesLabel"/>
                    </xsl:with-param>
                </xsl:call-template>
            </a>
            <table>
                <xsl:apply-templates select="//endnote" mode="backMatter"/>
            </table>
        </xsl:if>
    </xsl:template>
    <!--
        endnoteRef
    -->
    <xsl:template match="endnoteRef">
        <xsl:call-template name="OutputEndnoteNumber">
            <xsl:with-param name="attr" select="@note"/>
            <xsl:with-param name="node" select="id(@note)"/>
        </xsl:call-template>
    </xsl:template>
    <!-- ===========================================================
        CITATIONS and REFERENCES 
        =========================================================== -->
    <!--
        citation
    -->
    <xsl:template match="//citation[not(parent::selectedBibliography)]">
        <xsl:variable name="refer" select="id(@ref)"/>
        <xsl:element name="a">
            <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
                <xsl:value-of select="@ref"/>
            </xsl:attribute>
            <xsl:if test="@author='yes'">
                <xsl:value-of select="$refer/../@citename"/>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="not(@paren) or @paren='both' or @paren='initial'">(</xsl:if>
            <xsl:variable name="works" select="$refWorks[../@name=$refer/../@name and @id=//citation/@ref]"/>
            <xsl:variable name="date">
                <xsl:value-of select="$refer/refDate"/>
            </xsl:variable>
            <xsl:if test="@author='yes' and not(not(@paren) or @paren='both' or @paren='initial')">
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:value-of select="$date"/>
            <xsl:if test="count($works[refDate=$date])>1">
                <xsl:apply-templates select="$refer" mode="dateLetter">
                    <xsl:with-param name="date" select="$date"/>
                </xsl:apply-templates>
            </xsl:if>
            <xsl:variable name="sPage" select="normalize-space(@page)"/>
            <xsl:if test="string-length($sPage) &gt; 0">
                <xsl:text>:</xsl:text>
                <xsl:value-of select="$sPage"/>
            </xsl:if>
            <xsl:if test="not(@paren) or @paren='both' or @paren='final'">)</xsl:if>
        </xsl:element>
    </xsl:template>
    <!--
        references
    -->
    <xsl:template match="references">
        <hr size="3"/>
        <a name="{$sReferencesID}">
            <xsl:call-template name="OutputChapTitle">
                <xsl:with-param name="sTitle">
                    <xsl:call-template name="OutputReferencesLabel"/>
                </xsl:with-param>
            </xsl:call-template>
        </a>
        <div style="margin-left:0.25in">
            <xsl:call-template name="DoRefAuthors"/>
        </div>
    </xsl:template>
    <!--
      refTitle
      -->
    <xsl:template match="refTitle">
        <xsl:apply-templates/>
    </xsl:template>
    <!-- ===========================================================
      BR
      =========================================================== -->
    <xsl:template match="br">
        <br/>
    </xsl:template>
    <!-- ===========================================================
      GLOSS
      =========================================================== -->
    <xsl:template match="gloss">
        <xsl:if test="ancestor::word and preceding-sibling::*[1][name()='langData']">
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        </xsl:if>
        <xsl:element name="span">
            <xsl:attribute name="style">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <!-- ===========================================================
      ABBREVIATION
      =========================================================== -->
    <xsl:template match="abbrRef">
        <xsl:choose>
            <xsl:when test="ancestor::genericRef">
                <xsl:call-template name="OutputAbbrTerm">
                    <xsl:with-param name="abbr" select="id(@abbr)"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <a href="#{@abbr}">
                    <xsl:if test="ancestor::gloss or parent::object">
                        <xsl:attribute name="style">
                            <xsl:text>; text-decoration:none; </xsl:text>
                            <xsl:for-each select="ancestor::gloss">
                                <xsl:sort order="descending"/>
                                <xsl:call-template name="OutputFontAttributes">
                                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                                </xsl:call-template>
                            </xsl:for-each>
                            <xsl:for-each select="ancestor::object">
                                <xsl:sort order="descending"/>
                                <xsl:call-template name="DoType">
                                    <xsl:with-param name="type" select="@type"/>
                                </xsl:call-template>
                            </xsl:for-each>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:call-template name="OutputAbbrTerm">
                        <xsl:with-param name="abbr" select="id(@abbr)"/>
                    </xsl:call-template>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- decided not to do this; use glossary instead
   <xsl:template match="backMatter/abbreviationsShownHere">
      <hr size="3"/>
      <a name="rXLingPapAbbreviations">
         <xsl:call-template name="OutputChapTitle">
            <xsl:with-param name="sTitle">
               <xsl:call-template name="OutputAbbreviationsLabel"/>
            </xsl:with-param>
         </xsl:call-template>
      </a>
      <xsl:call-template name="OutputAbbreviationsInTable"/>
   </xsl:template>
   -->
    <xsl:template match="abbreviationsShownHere">
        <xsl:choose>
            <xsl:when test="ancestor::endnote">
                <xsl:choose>
                    <xsl:when test="parent::p">
                        <xsl:call-template name="OutputAbbreviationsInCommaSeparatedList"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <p>
                            <xsl:call-template name="OutputAbbreviationsInCommaSeparatedList"/>
                        </p>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="not(ancestor::p)">
                <!-- ignore any other abbreviationsShownHere in a p except when also in an endnote; everything else goes in a table -->
                <xsl:call-template name="OutputAbbreviationsInTable"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="abbrTerm | abbrDefinition"/>
    <!-- ===========================================================
        exampleHeading
        =========================================================== -->
    <xsl:template match="exampleHeading">
        <table cellpadding="0pt" cellspacing="0pt">
            <tr>
                <td>&#xa0;<xsl:apply-templates/></td>
            </tr>
        </table>
    </xsl:template>
    <xsl:template match="exampleHeading" mode="noInitialSpace">
        <table cellpadding="0pt" cellspacing="0pt">
            <tr>
                <td>
                    <xsl:apply-templates/>
                </td>
            </tr>
        </table>
    </xsl:template>
    <!-- ===========================================================
      LANGDATA
      =========================================================== -->
    <xsl:template match="langData">
        <xsl:element name="span">
            <xsl:attribute name="style">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <!-- ===========================================================
      OBJECT
      =========================================================== -->
    <xsl:template match="object">
        <xsl:element name="span">
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <xsl:for-each select="key('TypeID',@type)">
                <xsl:value-of select="@before"/>
            </xsl:for-each>
            <xsl:apply-templates/>
            <xsl:for-each select="key('TypeID',@type)">
                <xsl:value-of select="@after"/>
            </xsl:for-each>
        </xsl:element>
    </xsl:template>
    <!-- ===========================================================
      INTERLINEAR TEXT
      =========================================================== -->
    <!--  
                  textTitle
-->
    <xsl:template match="textTitle">
        <div align="center" style="font-size:larger; font-weight:bold">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!--  
                  source
-->
    <xsl:template match="source">
        <div align="center" style="font-style:italic">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <!-- ===========================================================
      NUMBERING PROCESSING 
      =========================================================== -->
    <!--  
                  sections
-->
    <xsl:template mode="number" match="*">
        <xsl:choose>
            <xsl:when test="ancestor-or-self::chapter">
                <xsl:apply-templates select="." mode="numberChapter"/>
                <xsl:if test="ancestor::chapter">
                    <xsl:text>.</xsl:text>
                </xsl:if>
            </xsl:when>
            <xsl:when test="ancestor-or-self::chapterBeforePart">
                <xsl:text>0</xsl:text>
                <xsl:if test="ancestor::chapterBeforePart">
                    <xsl:text>.</xsl:text>
                </xsl:if>
            </xsl:when>
        </xsl:choose>
        <!--
        <xsl:if test="//chapter">
            <xsl:apply-templates select="." mode="numberChapter"/>.</xsl:if>
      -->
        <xsl:number level="multiple" count="section1 | section2 | section3 | section4 | section5 | section6" format="1.1"/>
        <!--<xsl:variable name="numAt1">
         <xsl:number level="multiple" count="section1 | section2 | section3 | section4 | section5 | section6" format="1.1"/>
      </xsl:variable>
      -->
        <!--  adjust section1 number down by one to start with 0 -->
        <!--<xsl:variable name="num1" select="substring-before($numAt1,'.')"/>
      <xsl:variable name="numRest" select="substring-after($numAt1,'.')"/>
      <xsl:variable name="num1At0">
         <xsl:choose>
            <xsl:when test="$num1">
               <xsl:value-of select="number($num1)-1"/>
               <xsl:text>.</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="number($numAt1)-1"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:value-of select="$num1At0"/>
      <xsl:value-of select="$numRest"/>
  -->
    </xsl:template>
    <!--  
                  appendix
-->
    <xsl:template mode="numberAppendix" match="*">
        <xsl:number level="multiple" count="appendix | section1 | section2 | section3 | section4 | section5 | section6" format="A.1"/>
    </xsl:template>
    <!--  
                  chapter
-->
    <xsl:template mode="numberChapter" match="*">
        <xsl:number level="any" count="chapter" format="1"/>
    </xsl:template>
    <!--  
                  part
-->
    <xsl:template mode="numberPart" match="*">
        <xsl:number level="multiple" count="part" format="I"/>
    </xsl:template>
    <!--  
                  endnote
-->
    <xsl:template mode="endnote" match="endnote[parent::author]">
        <xsl:variable name="iAuthorPosition" select="count(parent::author/preceding-sibling::author[endnote]) + 1"/>
        <xsl:call-template name="OutputAuthorFootnoteSymbol">
            <xsl:with-param name="iAuthorPosition" select="$iAuthorPosition"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template mode="endnote" match="*">
        <xsl:number level="any" count="endnote[not(parent::author)]" format="1"/>
    </xsl:template>
    <!--  
                  example
-->
    <xsl:template mode="example" match="*">
        <xsl:number level="any" count="example[not(ancestor::endnote)]" format="1"/>
    </xsl:template>
    <!--  
      exampleInEndnote
   -->
    <xsl:template mode="exampleInEndnote" match="*">
        <xsl:number level="single" count="example" format="i"/>
    </xsl:template>
    <!--  
        figure
    -->
    <xsl:template mode="figure" match="*">
        <xsl:choose>
            <xsl:when test="//chapter">
                <xsl:for-each select="ancestor::chapter | ancestor::appendix | ancestor::chapterBeforePart">
                    <xsl:call-template name="OutputChapterNumber">
                        <xsl:with-param name="fIgnoreTextAfterLetter" select="'Y'"/>
                    </xsl:call-template>
                </xsl:for-each>
                <xsl:text>.</xsl:text>
                <xsl:number level="any" count="figure" from="chapter | appendix | chapterBeforePart" format="1"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:number level="any" count="figure" format="1"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        tablenumbered
    -->
    <xsl:template mode="tablenumbered" match="*">
        <xsl:choose>
            <xsl:when test="//chapter">
                <xsl:for-each select="ancestor::chapter | ancestor::appendix | ancestor::chapterBeforePart">
                    <xsl:call-template name="OutputChapterNumber">
                        <xsl:with-param name="fIgnoreTextAfterLetter" select="'Y'"/>
                    </xsl:call-template>
                </xsl:for-each>
                <xsl:text>.</xsl:text>
                <xsl:number level="any" count="tablenumbered" from="chapter | appendix | chapterBeforePart" format="1"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:number level="any" count="tablenumbered" format="1"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
                  letter
-->
    <xsl:template mode="letter" match="*">
        <xsl:number level="single" count="listWord | listSingle | listInterlinear | listDefinition | lineSet" format="a"/>
    </xsl:template>
    <!--  
                  dateLetter
-->
    <xsl:template mode="dateLetter" match="*">
        <xsl:param name="date"/>
        <xsl:number level="single" count="refWork[@id=//citation/@ref][refDate=$date]" format="a"/>
    </xsl:template>
    <!-- ===========================================================
        ELEMENTS TO IGNORE
        =========================================================== -->
    <xsl:template match="basicPointSize"/>
    <xsl:template match="blockQuoteIndent"/>
    <xsl:template match="citation[parent::selectedBibliography]"/>
    <xsl:template match="defaultFontFamily"/>
    <xsl:template match="fixedText"/>
    <xsl:template match="footerMargin"/>
    <xsl:template match="footnotePointSize"/>
    <xsl:template match="headerMargin"/>
    <xsl:template match="pageBottomMargin"/>
    <xsl:template match="pageHeight"/>
    <xsl:template match="pageInsideMargin"/>
    <xsl:template match="pageOutsideMargin"/>
    <xsl:template match="pageTopMargin"/>
    <xsl:template match="pageWidth"/>
    <xsl:template match="paragraphIndent"/>
    <xsl:template match="publisherStyleSheetName"/>
    <xsl:template match="publisherStyleSheetReferencesName"/>
    <xsl:template match="publisherStyleSheetReferencesVersion"/>
    <xsl:template match="publisherStyleSheetVersion"/>
    <!-- ===========================================================
      NAMED TEMPLATES
      =========================================================== -->
    <!--
      ApplyTemplatesPerTextRefMode
   -->
    <xsl:template name="ApplyTemplatesPerTextRefMode">
        <xsl:param name="mode"/>
        <xsl:choose>
            <xsl:when test="$mode='NoTextRef'">
                <xsl:apply-templates mode="NoTextRef"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
                  CheckSeeTargetIsCitedOrItsDescendantIsCited
   -->
    <xsl:template name="CheckSeeTargetIsCitedOrItsDescendantIsCited">
        <xsl:variable name="sSee" select="@see"/>
        <xsl:choose>
            <xsl:when test="//indexedItem[@term=$sSee] | //indexedRangeBegin[@term=$sSee]">
                <xsl:text>Y</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="key('IndexTermID',@see)/descendant::indexTerm">
                    <xsl:variable name="sDescendantTermId" select="@id"/>
                    <xsl:if test="//indexedItem[@term=$sDescendantTermId] or //indexedRangeBegin[@term=$sDescendantTermId]">
                        <xsl:text>Y</xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
                  CreateIndexID
                                    -->
    <xsl:template name="CreateIndexID">
        <xsl:text>rXLingPapIndex.</xsl:text>
        <xsl:value-of select="generate-id()"/>
    </xsl:template>
    <!--
                  CreateIndexedItemID
                  -->
    <xsl:template name="CreateIndexedItemID">
        <xsl:param name="sTermId"/>
        <xsl:text>rXLingPapIndexedItem.</xsl:text>
        <xsl:value-of select="$sTermId"/>
        <xsl:text>.</xsl:text>
        <xsl:value-of select="generate-id()"/>
    </xsl:template>
    <!--
                  CreateIndexTermID
                  -->
    <xsl:template name="CreateIndexTermID">
        <xsl:param name="sTermId"/>
        <xsl:text>rXLingPapIndexTerm.</xsl:text>
        <xsl:value-of select="$sTermId"/>
    </xsl:template>
    <!--
        DoBook
    -->
    <xsl:template name="DoBook">
        <xsl:param name="book"/>
        <xsl:param name="pages"/>
        <xsl:for-each select="$book">
            <i>
                <xsl:apply-templates select="../refTitle"/>
            </i>
            <xsl:text>.  </xsl:text>
            <xsl:if test="translatedBy">
                <xsl:text>Translated by </xsl:text>
                <xsl:value-of select="normalize-space(translatedBy)"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="translatedBy"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="edition">
                <xsl:value-of select="normalize-space(edition)"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="edition"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="seriesEd">
                <xsl:value-of select="normalize-space(seriesEd)"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="seriesEd"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:if test="series">
                <i>
                    <xsl:value-of select="normalize-space(series)"/>
                </i>
                <xsl:if test="not(bVol)">
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="series"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:text>&#x20;</xsl:text>
            </xsl:if>
            <xsl:variable name="sPages" select="normalize-space($pages)"/>
            <xsl:choose>
                <xsl:when test="bVol">
                    <xsl:value-of select="normalize-space(bVol)"/>
                    <xsl:if test="string-length($sPages) &gt; 0">
                        <xsl:text>:</xsl:text>
                        <xsl:value-of select="$pages"/>
                    </xsl:if>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="bVol"/>
                    </xsl:call-template>
                    <xsl:text>&#x20;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="string-length($sPages) &gt; 0">
                        <xsl:value-of select="$sPages"/>
                        <xsl:text>. </xsl:text>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="location and publisher">
                    <xsl:value-of select="normalize-space(location)"/>
                    <xsl:text>: </xsl:text>
                    <xsl:value-of select="normalize-space(publisher)"/>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="publisher"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="location">
                    <xsl:value-of select="normalize-space(location)"/>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="location"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="publisher">
                    <xsl:value-of select="normalize-space(publisher)"/>
                    <xsl:call-template name="OutputPeriodIfNeeded">
                        <xsl:with-param name="sText" select="publisher"/>
                    </xsl:call-template>
                </xsl:when>
            </xsl:choose>
            <xsl:call-template name="DoRefUrlEtc">
                <xsl:with-param name="path" select="."/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
                  DoCellAttributes
                  -->
    <xsl:template name="DoCellAttributes">
        <xsl:if test="@direction">
            <xsl:attribute name="style">
                <xsl:text>direction:</xsl:text>
                <xsl:value-of select="@direction"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="@align">
            <xsl:attribute name="align">
                <xsl:value-of select="@align"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="@colspan">
            <xsl:attribute name="colspan">
                <xsl:value-of select="@colspan"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="@rowspan">
            <xsl:attribute name="rowspan">
                <xsl:value-of select="@rowspan"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="@valign">
            <xsl:attribute name="valign">
                <xsl:value-of select="@valign"/>
            </xsl:attribute>
        </xsl:if>
        <!-- does not work in HTML 4.0 
           <xsl:if test="@width">
         <xsl:attribute name="width">
            <xsl:value-of select="@width"/>
         </xsl:attribute>
      </xsl:if>
      -->
    </xsl:template>
    <!--  
        DoEdPlural
    -->
    <xsl:template name="DoEdPlural">
        <xsl:param name="editor"/>
        <xsl:value-of select="normalize-space($editor)"/>
        <xsl:text>, ed</xsl:text>
        <xsl:if test="$editor/@plural='yes'">
            <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text>.</xsl:text>
        <!--        <xsl:call-template name="OutputPeriodIfNeeded">
            <xsl:with-param name="sText" select="$editor"/>
        </xsl:call-template>
-->
    </xsl:template>
    <!--  
      DoInterlinearFree
   -->
    <xsl:template name="DoInterlinearFree">
        <table>
            <!-- add extra indent for when have an embedded interlinear; 
            be sure to allow for the case of when a listInterlinear begins with an interlinear -->
            <xsl:variable name="parent" select=".."/>
            <xsl:variable name="iParentPosition">
                <xsl:for-each select="../../*">
                    <xsl:if test=".=$parent">
                        <xsl:value-of select="position()"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="sCurrentLanguage" select="@lang"/>
            <xsl:if test="preceding-sibling::free[@lang=$sCurrentLanguage][position()=1] or preceding-sibling::*[1][name()='free'][not(@lang)][position()=1] or name(../..)='interlinear' or name(../..)='listInterlinear' and name(..)='interlinear' and $iParentPosition!=1">
                <!--              <xsl:if test="preceding-sibling::free[@lang=$sCurrentLanguage][position()=1] or preceding-sibling::free[not(@lang)][position()=1] or name(../..)='interlinear' or name(../..)='listInterlinear' and name(..)='interlinear' and $iParentPosition!=1">-->
                <xsl:attribute name="style">
                    <xsl:text>margin-left: 0.1in</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <tr style="line-height:125%">
                <xsl:element name="td">
                    <xsl:attribute name="colspan">30</xsl:attribute>
                    <xsl:attribute name="style">
                        <xsl:call-template name="OutputFontAttributes">
                            <xsl:with-param name="language" select="key('LanguageID',@lang)"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </xsl:element>
                <xsl:if test="$sInterlinearSourceStyle='AfterFree'">
                    <xsl:if test="name(../..)='example'  or name(../..)='listInterlinear'">
                        <xsl:call-template name="OutputInterlinearTextReference">
                            <xsl:with-param name="sRef" select="../@textref"/>
                            <xsl:with-param name="sSource" select="../interlinearSource"/>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:if>
            </tr>
        </table>
        <xsl:if test="$sInterlinearSourceStyle='UnderFree'">
            <xsl:if test="name(../..)='example' or name(../..)='listInterlinear'">
                <table>
                    <tr>
                        <xsl:call-template name="OutputInterlinearTextReference">
                            <xsl:with-param name="sRef" select="../@textref"/>
                            <xsl:with-param name="sSource" select="../interlinearSource"/>
                        </xsl:call-template>
                    </tr>
                </table>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <!--  
        DoRefCitation
    -->
    <xsl:template name="DoRefCitation">
        <xsl:param name="citation"/>
        <xsl:for-each select="$citation">
            <xsl:variable name="refer" select="id(@refToBook)"/>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="@refToBook"/>
                </xsl:attribute>
                <xsl:value-of select="$refer/../@citename"/>
                <xsl:text>,&#x20;</xsl:text>
                <xsl:value-of select="$refer/authorRole"/>
                <xsl:text>, </xsl:text>
                <xsl:variable name="sPage" select="normalize-space(@page)"/>
                <xsl:if test="string-length($sPage) &gt; 0">
                    <xsl:text>&#x20;</xsl:text>
                    <xsl:value-of select="$sPage"/>
                </xsl:if>
                <xsl:text>.</xsl:text>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>
    <!--  
        DoRefUrlEtc
    -->
    <xsl:template name="DoRefUrlEtc">
        <xsl:param name="path"/>
        <xsl:if test="$path/url">
            <xsl:text> (</xsl:text>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:value-of select="normalize-space($path/url)"/>
                </xsl:attribute>
                <xsl:value-of select="normalize-space($path/url)"/>
            </xsl:element>
            <xsl:text>)</xsl:text>
            <xsl:if test="$path/dateAccessed">
                <xsl:text>  (accessed </xsl:text>
                <xsl:value-of select="normalize-space($path/dateAccessed)"/>
                <xsl:text>)</xsl:text>
            </xsl:if>
            <xsl:text>.</xsl:text>
        </xsl:if>
        <xsl:for-each select="$path/iso639-3code">
            <xsl:sort/>
            <span style="font-size:smaller">
                <xsl:if test="position() = 1">
                    <xsl:text>  [</xsl:text>
                </xsl:if>
                <xsl:value-of select="."/>
                <xsl:if test="position() != last()">
                    <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:if test="position() = last()">
                    <xsl:text>]</xsl:text>
                </xsl:if>
            </span>
        </xsl:for-each>
    </xsl:template>
    <!--  
        DoRefWorks
    -->
<!--    <xsl:template name="DoRefWorks">
        <xsl:variable name="thisAuthor" select="."/>
        <xsl:variable name="works" select="refWork[@id=$citations[not(ancestor::comment) and not(ancestor::annotation)][not(ancestor::refWork) or ancestor::refWork[@id=$citations[not(ancestor::refWork)]/@ref]]/@ref] | $refWorks[@id=saxon:node-set($collOrProcVolumesToInclude)/refWork/@id][parent::refAuthor=$thisAuthor] | refWork[@id=$citationsInAnnotationsReferredTo[not(ancestor::comment)]/@ref]"/>
        <xsl:for-each select="$works">
            <p style="text-indent:-0.25in;margin-bottom:0in;margin-top:0in">
                <xsl:variable name="author">
                    <xsl:value-of select="normalize-space(../@name)"/>
                </xsl:variable>
                <xsl:element name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="@id"/>
                    </xsl:attribute>
                    <xsl:value-of select="$author"/>
                </xsl:element>
                <xsl:if test="substring($author,string-length($author),string-length($author))!='.'">.</xsl:if>
                <xsl:text>&#x20;  </xsl:text>
                <xsl:if test="authorRole">
                    <xsl:value-of select="authorRole"/>
                    <xsl:text>.  </xsl:text>
                </xsl:if>
                <xsl:variable name="date">
                    <xsl:value-of select="refDate"/>
                </xsl:variable>
                <xsl:value-of select="$date"/>
                <xsl:if test="count($works[refDate=$date])>1">
                    <xsl:apply-templates select="." mode="dateLetter">
                        <xsl:with-param name="date" select="$date"/>
                    </xsl:apply-templates>
                </xsl:if>
                <xsl:text>. </xsl:text>
                <!-\-
                    book
                -\->
                <xsl:if test="book">
                    <xsl:call-template name="DoBook">
                        <xsl:with-param name="book" select="book"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    collection
                -\->
                <xsl:if test="collection">
                    <xsl:value-of select="$sLdquo"/>
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:value-of select="$sRdquo"/>
                    <xsl:text> In </xsl:text>
                    <xsl:choose>
                        <xsl:when test="collection/collCitation">
                            <xsl:variable name="citation" select="collection/collCitation"/>
                            <xsl:choose>
                                <xsl:when test="saxon:node-set($collOrProcVolumesToInclude)/refWork[@id=$citation/@refToBook]">
                                    <xsl:call-template name="DoRefCitation">
                                        <xsl:with-param name="citation" select="$citation"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="FleshOutRefCitation">
                                        <xsl:with-param name="citation" select="$citation"/>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="DoEdPlural">
                                <xsl:with-param name="editor" select="collection/collEd"/>
                            </xsl:call-template>
                            <xsl:text>&#x20;</xsl:text>
                            <i>
                                <xsl:value-of select="normalize-space(collection/collTitle)"/>
                            </i>
                            <xsl:text>.</xsl:text>
                            <xsl:call-template name="DoCollectionEdition"/>
                            <xsl:choose>
                                <xsl:when test="collection/collVol">
                                    <xsl:text>&#x20;</xsl:text>
                                    <xsl:value-of select="normalize-space(collection/collVol)"/>
                                    <xsl:text>:</xsl:text>
                                    <xsl:value-of select="normalize-space(collection/collPages)"/>
                                    <xsl:text>. </xsl:text>
                                </xsl:when>
                                <xsl:when test="collection/collPages">
                                    <xsl:if test="collection/collVol">
                                        <xsl:text>,</xsl:text>
                                    </xsl:if>
                                    <xsl:text>&#x20;</xsl:text>
                                    <xsl:value-of select="normalize-space(collection/collPages)"/>
                                    <xsl:text>. </xsl:text>
                                </xsl:when>
                                <!-\-                                        <xsl:otherwise>
                                    <xsl:text>.</xsl:text>
                                    </xsl:otherwise>
                                -\->
                            </xsl:choose>
                            <xsl:if test="collection/seriesEd">
                                <xsl:call-template name="DoEdPlural">
                                    <xsl:with-param name="editor" select="collection/seriesEd"/>
                                </xsl:call-template>
                                <xsl:text>&#x20;</xsl:text>
                            </xsl:if>
                            <xsl:if test="collection/series">
                                <i>
                                    <xsl:value-of select="normalize-space(collection/series)"/>
                                </i>
                                <xsl:if test="not(bVol)">
                                    <xsl:call-template name="OutputPeriodIfNeeded">
                                        <xsl:with-param name="sText" select="collection/series"/>
                                    </xsl:call-template>
                                </xsl:if>
                                <xsl:text>&#x20;</xsl:text>
                            </xsl:if>
                            <xsl:choose>
                                <xsl:when test="collection/location">
                                    <xsl:text>&#x20;</xsl:text>
                                    <xsl:value-of select="normalize-space(collection/location)"/>
                                    <xsl:text>: </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>&#x20;</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:if test="collection/publisher">
                                <xsl:value-of select="normalize-space(collection/publisher)"/>
                                <xsl:call-template name="OutputPeriodIfNeeded">
                                    <xsl:with-param name="sText" select="collection/publisher"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="collection"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    dissertation
                -\->
                <xsl:if test="dissertation">
                    <i>
                        <xsl:apply-templates select="refTitle"/>
                    </i>
                    <xsl:text>. </xsl:text>
                    <xsl:call-template name="OutputLabel">
                        <xsl:with-param name="sDefault" select="$sPhDDissertationDefaultLabel"/>
                        <xsl:with-param name="pLabel">
                            <xsl:choose>
                                <xsl:when test="string-length(normalize-space(dissertation/@labelDissertation)) &gt; 0">
                                    <xsl:value-of select="dissertation/@labelDissertation"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="//references/@labelDissertation"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:text>. </xsl:text>
                    <xsl:if test="dissertation/location">
                        <xsl:text>(</xsl:text>
                        <xsl:value-of select="normalize-space(dissertation/location)"/>
                        <xsl:text>).  </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="normalize-space(dissertation/institution)"/>
                    <xsl:text>.</xsl:text>
                    <xsl:if test="dissertation/published">
                        <xsl:text>  Published by </xsl:text>
                        <xsl:value-of select="normalize-space(dissertation/published/location)"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="normalize-space(dissertation/published/publisher)"/>
                        <xsl:text>, </xsl:text>
                        <xsl:value-of select="normalize-space(dissertation/published/pubDate)"/>
                        <xsl:text>.</xsl:text>
                    </xsl:if>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="dissertation"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    journal article
                -\->
                <xsl:if test="article">
                    <xsl:value-of select="$sLdquo"/>
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:value-of select="$sRdquo"/>
                    <xsl:text>&#x20;</xsl:text>
                    <i>
                        <xsl:value-of select="normalize-space(article/jTitle)"/>
                        <xsl:text>&#x20;</xsl:text>
                        <xsl:value-of select="normalize-space(article/jVol)"/>
                        <xsl:if test="article/jIssueNumber">
                            <xsl:text>(</xsl:text>
                            <xsl:value-of select="article/jIssueNumber"/>
                            <xsl:text>)</xsl:text>
                        </xsl:if>
                        <xsl:choose>
                            <xsl:when test="article/jPages">
                                <xsl:text>:</xsl:text>
                                <xsl:value-of select="normalize-space(article/jPages)"/>
                            </xsl:when>
                            <xsl:when test="article/jArticleNumber">
                                <xsl:text>-</xsl:text>
                                <xsl:value-of select="normalize-space(article/jArticleNumber)"/>
                            </xsl:when>
                        </xsl:choose>
                    </i>
                    <xsl:text>.</xsl:text>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="article"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    field notes
                -\->
                <xsl:if test="fieldNotes">
                    <xsl:value-of select="$sLdquo"/>
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:value-of select="$sRdquo"/>
                    <xsl:text>&#x20;</xsl:text>
                    <xsl:if test="fieldNotes/location">
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="normalize-space(fieldNotes/location)"/>
                        <xsl:text>).  </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="normalize-space(fieldNotes/institution)"/>
                    <xsl:text>.</xsl:text>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="fieldNotes"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    ms (manuscript)
                -\->
                <xsl:if test="ms">
                    <xsl:value-of select="$sLdquo"/>
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:value-of select="$sRdquo"/>
                    <xsl:text>&#x20;</xsl:text>
                    <xsl:if test="ms/location">
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="normalize-space(ms/location)"/>
                        <xsl:text>).  </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="normalize-space(ms/institution)"/>
                    <xsl:text> ms.</xsl:text>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="ms"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    paper
                -\->
                <xsl:if test="paper">
                    <xsl:value-of select="$sLdquo"/>
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:value-of select="$sRdquo"/>
                    <xsl:text>  Paper presented at the </xsl:text>
                    <xsl:value-of select="normalize-space(paper/conference)"/>
                    <xsl:if test="paper/location">
                        <xsl:text>, </xsl:text>
                        <xsl:value-of select="normalize-space(paper/location)"/>
                    </xsl:if>
                    <xsl:text>.</xsl:text>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="paper"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    proceedings
                -\->
                <xsl:if test="proceedings">
                    <xsl:value-of select="$sLdquo"/>
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:value-of select="$sRdquo"/>
                    <xsl:choose>
                        <xsl:when test="proceedings/procCitation">
                            <xsl:text>  In </xsl:text>
                            <xsl:variable name="citation" select="proceedings/procCitation"/>
                            <xsl:choose>
                                <xsl:when test="saxon:node-set($collOrProcVolumesToInclude)/refWork[@id=$citation/@refToBook]">
                                    <xsl:call-template name="DoRefCitation">
                                        <xsl:with-param name="citation" select="$citation"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="FleshOutRefCitation">
                                        <xsl:with-param name="citation" select="$citation"/>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:choose>
                                <xsl:when test="proceedings/procEd">
                                    <xsl:text>  In </xsl:text>
                                    <xsl:call-template name="DoEdPlural">
                                        <xsl:with-param name="editor" select="proceedings/procEd"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>&#x20;</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                            <i>
                                <xsl:value-of select="normalize-space(proceedings/procTitle)"/>
                            </i>
                            <xsl:choose>
                                <xsl:when test="proceedings/procVol">
                                    <xsl:text>&#x20;</xsl:text>
                                    <xsl:value-of select="normalize-space(proceedings/procVol)"/>
                                    <xsl:text>:</xsl:text>
                                    <xsl:value-of select="normalize-space(proceedings/procPages)"/>
                                    <xsl:text>. </xsl:text>
                                </xsl:when>
                                <xsl:when test="proceedings/procPages">
                                    <xsl:text>, </xsl:text>
                                    <xsl:value-of select="normalize-space(proceedings/procPages)"/>
                                    <xsl:text>. </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>. </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:if test="proceedings/location or proceedings/publisher">
                                <xsl:value-of select="normalize-space(proceedings/location)"/>
                                <xsl:if test="proceedings/publisher">
                                    <xsl:text>: </xsl:text>
                                    <xsl:value-of select="normalize-space(proceedings/publisher)"/>
                                </xsl:if>
                                <xsl:text>.</xsl:text>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="proceedings"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    thesis
                -\->
                <xsl:if test="thesis">
                    <i>
                        <xsl:apply-templates select="refTitle"/>
                    </i>
                    <xsl:text>. </xsl:text>
                    <xsl:call-template name="OutputLabel">
                        <xsl:with-param name="sDefault" select="$sMAThesisDefaultLabel"/>
                        <xsl:with-param name="pLabel">
                            <xsl:choose>
                                <xsl:when test="string-length(normalize-space(thesis/@labelThesis)) &gt; 0">
                                    <xsl:value-of select="thesis/@labelThesis"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="//references/@labelThesis"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:text>. </xsl:text>
                    <xsl:if test="thesis/location">
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="normalize-space(thesis/location)"/>
                        <xsl:text>).  </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="normalize-space(thesis/institution)"/>
                    <xsl:text>.</xsl:text>
                    <xsl:if test="thesis/published">
                        <xsl:text>  Published by </xsl:text>
                        <xsl:value-of select="normalize-space(thesis/published/location)"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="normalize-space(thesis/published/publisher)"/>
                        <xsl:text>, </xsl:text>
                        <xsl:value-of select="normalize-space(thesis/published/pubDate)"/>
                        <xsl:text>.</xsl:text>
                    </xsl:if>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="thesis"/>
                    </xsl:call-template>
                </xsl:if>
                <!-\-
                    webPage
                -\->
                <xsl:if test="webPage">
                    <xsl:value-of select="$sLdquo"/>
                    <xsl:apply-templates select="refTitle"/>
                    <xsl:text>.</xsl:text>
                    <xsl:value-of select="$sRdquo"/>
                    <xsl:text>&#x20;</xsl:text>
                    <xsl:if test="webPage/edition">
                        <xsl:value-of select="normalize-space(webPage/edition)"/>
                        <xsl:call-template name="OutputPeriodIfNeeded">
                            <xsl:with-param name="sText" select="webPage/edition"/>
                        </xsl:call-template>
                        <xsl:text>&#x20;</xsl:text>
                    </xsl:if>
                    <xsl:if test="webPage/location">
                        <xsl:value-of select="normalize-space(webPage/location)"/>
                        <xsl:text>: </xsl:text>
                    </xsl:if>
                    <xsl:if test="webPage/institution">
                        <xsl:value-of select="normalize-space(webPage/institution)"/>
                        <xsl:text>. </xsl:text>
                    </xsl:if>
                    <xsl:if test="webPage/publisher">
                        <xsl:value-of select="normalize-space(webPage/publisher)"/>
                    </xsl:if>
                    <xsl:call-template name="DoRefUrlEtc">
                        <xsl:with-param name="path" select="webPage"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:call-template name="DoRefUrlEtc">
                    <xsl:with-param name="path" select="."/>
                </xsl:call-template>
            </p>
        </xsl:for-each>
    </xsl:template>
-->    <!--  
        DoInterlinearRefCitation
    -->
    <xsl:template name="DoInterlinearRefCitation">
        <xsl:param name="sRef"/>
        <a href="#{$sRef}">
            <xsl:call-template name="DoInterlinearRefCitationContent">
                <xsl:with-param name="sRef" select="$sRef"/>
            </xsl:call-template>
        </a>
    </xsl:template>
    <!--  
        DoItemRefLabel
    -->
    <xsl:template name="DoItemRefLabel">
        <xsl:param name="sLabel"/>
        <xsl:param name="sDefault"/>
        <xsl:choose>
            <xsl:when test="string-length($sLabel) &gt; 0">
                <xsl:value-of select="$sLabel"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$sDefault"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>&#xa0;</xsl:text>
    </xsl:template>
    <!--  
        FleshOutRefCitation
    -->
    <xsl:template name="FleshOutRefCitation">
        <xsl:param name="citation"/>
        <xsl:variable name="citedWork" select="key('RefWorkID',$citation/@refToBook)"/>
        <xsl:call-template name="ConvertLastNameFirstNameToFirstNameLastName">
            <xsl:with-param name="sCitedWorkAuthor" select="$citedWork/../@name"/>
        </xsl:call-template>
        <xsl:choose>
            <xsl:when test="$citedWork/authorRole">
                <xsl:text>, </xsl:text>
                <xsl:value-of select="$citedWork/authorRole"/>
                <xsl:call-template name="OutputPeriodIfNeeded">
                    <xsl:with-param name="sText" select="$citedWork/authorRole"/>
                </xsl:call-template>
                <xsl:text>&#x20;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>.  </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="DoBook">
            <xsl:with-param name="book" select="$citedWork/book"/>
            <xsl:with-param name="pages" select="$citation/@page"/>
        </xsl:call-template>
    </xsl:template>
    <!--  
      HandleSmallCaps
   -->
    <xsl:template name="HandleSmallCaps">
        <xsl:attribute name="style">
            <xsl:text>font-variant:small-caps; </xsl:text>
        </xsl:attribute>
    </xsl:template>
    <!--
        OutputAbbreviationInCommaSeparatedList
    -->
    <xsl:template name="OutputAbbreviationInCommaSeparatedList">
        <a name="{@id}">
            <xsl:call-template name="OutputAbbrTerm">
                <xsl:with-param name="abbr" select="."/>
            </xsl:call-template>
            <xsl:text> = </xsl:text>
            <xsl:call-template name="OutputAbbrDefinition">
                <xsl:with-param name="abbr" select="."/>
            </xsl:call-template>
        </a>
        <xsl:choose>
            <xsl:when test="position() = last()">
                <xsl:text>.</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>, </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
      OutputAbbrTerm
   -->
    <xsl:template name="OutputAbbrTerm">
        <xsl:param name="abbr"/>
        <xsl:variable name="sAbbrTerm">
            <xsl:choose>
                <xsl:when test="string-length($abbrLang) &gt; 0">
                    <xsl:choose>
                        <xsl:when test="string-length($abbr//abbrInLang[@lang=$abbrLang]/abbrTerm) &gt; 0">
                            <xsl:value-of select="$abbr/abbrInLang[@lang=$abbrLang]/abbrTerm"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- a language is specified, but this abbreviation does not have anything; try using the default;
                        this assumes that something is better than nothing -->
                            <xsl:value-of select="$abbr/abbrInLang[1]/abbrTerm"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <!--  no language specified; just use the first one -->
                    <xsl:value-of select="$abbr/abbrInLang[1]/abbrTerm"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <span>
            <xsl:variable name="sFontAttributes">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="$abbreviations"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:if test="$abbreviations/@usesmallcaps='yes' or string-length($sFontAttributes) &gt; 0">
                <xsl:attribute name="style">
                    <xsl:if test="$abbreviations/@usesmallcaps='yes'">
                        <xsl:text>font-variant:small-caps; </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="$sFontAttributes"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$sAbbrTerm"/>
        </span>
    </xsl:template>
    <!--  
                  OutputChapterNumber
-->
    <xsl:template name="OutputChapterNumber">
        <xsl:choose>
            <xsl:when test="name()='chapter'">
                <xsl:apply-templates select="." mode="numberChapter"/>
            </xsl:when>
            <xsl:when test="name()='chapterBeforePart'">
                <xsl:text>0</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="numberAppendix"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
        OutputAnyTextBeforeFigureRef
    -->
    <xsl:template name="OutputAnyTextBeforeFigureRef">
        <!-- output any canned text before the section reference -->
        <xsl:variable name="lingPaper" select="//lingPaper"/>
        <xsl:variable name="ssingular" select="'figure'"/>
        <xsl:variable name="splural" select="'figures'"/>
        <xsl:variable name="sSingular" select="'Figure'"/>
        <xsl:variable name="sPlural" select="'Figures'"/>
        <xsl:choose>
            <xsl:when test="@textBefore='useDefault'">
                <xsl:choose>
                    <xsl:when test="$lingPaper/@figureRefDefault='none'">
                        <!-- do nothing -->
                    </xsl:when>
                    <xsl:when test="$lingPaper/@figureRefDefault='singular'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@figureRefSingularLabel"/>
                            <xsl:with-param name="sDefault" select="$ssingular"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@figureRefDefault='capitalizedSingular'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@figureRefCapitalizedSingularLabel"/>
                            <xsl:with-param name="sDefault" select="$sSingular"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@figureRefDefault='plural'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@figureRefPluralLabel"/>
                            <xsl:with-param name="sDefault" select="$splural"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@figureRefDefault='capitalizedPlural'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@figureRefCapitalizedPluralLabel"/>
                            <xsl:with-param name="sDefault" select="$sPlural"/>
                        </xsl:call-template>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="@textBefore='singular'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@figureRefSingularLabel"/>
                    <xsl:with-param name="sDefault" select="$ssingular"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='capitalizedSingular'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@figureRefCapitalizedSingularLabel"/>
                    <xsl:with-param name="sDefault" select="$sSingular"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='plural'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@figureRefPluralLabel"/>
                    <xsl:with-param name="sDefault" select="$splural"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='capitalizedPlural'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@figureRefCapitalizedPluralLabel"/>
                    <xsl:with-param name="sDefault" select="$sPlural"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!--
        OutputAnyTextBeforeSectionRef
    -->
    <xsl:template name="OutputAnyTextBeforeSectionRef">
        <!-- output any canned text before the section reference -->
        <xsl:variable name="lingPaper" select="//lingPaper"/>
        <xsl:variable name="ssingular" select="'section'"/>
        <xsl:variable name="splural" select="'sections'"/>
        <xsl:variable name="sSingular" select="'Section'"/>
        <xsl:variable name="sPlural" select="'Sections'"/>
        <xsl:choose>
            <xsl:when test="@textBefore='useDefault'">
                <xsl:choose>
                    <xsl:when test="$lingPaper/@sectionRefDefault='none'">
                        <!-- do nothing -->
                    </xsl:when>
                    <xsl:when test="$lingPaper/@sectionRefDefault='singular'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@sectionRefSingularLabel"/>
                            <xsl:with-param name="sDefault" select="$ssingular"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@sectionRefDefault='capitalizedSingular'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@sectionRefCapitalizedSingularLabel"/>
                            <xsl:with-param name="sDefault" select="$sSingular"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@sectionRefDefault='plural'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@sectionRefPluralLabel"/>
                            <xsl:with-param name="sDefault" select="$splural"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@sectionRefDefault='capitalizedPlural'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@sectionRefCapitalizedPluralLabel"/>
                            <xsl:with-param name="sDefault" select="$sPlural"/>
                        </xsl:call-template>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="@textBefore='singular'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@sectionRefSingularLabel"/>
                    <xsl:with-param name="sDefault" select="$ssingular"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='capitalizedSingular'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@sectionRefCapitalizedSingularLabel"/>
                    <xsl:with-param name="sDefault" select="$sSingular"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='plural'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@sectionRefPluralLabel"/>
                    <xsl:with-param name="sDefault" select="$splural"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='capitalizedPlural'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@sectionRefCapitalizedPluralLabel"/>
                    <xsl:with-param name="sDefault" select="$sPlural"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!--
        OutputAnyTextBeforeTablenumberedRef
    -->
    <xsl:template name="OutputAnyTextBeforeTablenumberedRef">
        <!-- output any canned text before the section reference -->
        <xsl:variable name="lingPaper" select="//lingPaper"/>
        <xsl:variable name="ssingular" select="'table'"/>
        <xsl:variable name="splural" select="'tables'"/>
        <xsl:variable name="sSingular" select="'Table'"/>
        <xsl:variable name="sPlural" select="'Tables'"/>
        <xsl:choose>
            <xsl:when test="@textBefore='useDefault'">
                <xsl:choose>
                    <xsl:when test="$lingPaper/@tablenumberedRefDefault='none'">
                        <!-- do nothing -->
                    </xsl:when>
                    <xsl:when test="$lingPaper/@tablenumberedRefDefault='singular'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@tablenumberedRefSingularLabel"/>
                            <xsl:with-param name="sDefault" select="$ssingular"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@tablenumberedRefDefault='capitalizedSingular'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@tablenumberedRefCapitalizedSingularLabel"/>
                            <xsl:with-param name="sDefault" select="$sSingular"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@tablenumberedRefDefault='plural'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@tablenumberedRefPluralLabel"/>
                            <xsl:with-param name="sDefault" select="$splural"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$lingPaper/@tablenumberedRefDefault='capitalizedPlural'">
                        <xsl:call-template name="DoItemRefLabel">
                            <xsl:with-param name="sLabel" select="$lingPaper/@tablenumberedRefCapitalizedPluralLabel"/>
                            <xsl:with-param name="sDefault" select="$sPlural"/>
                        </xsl:call-template>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="@textBefore='singular'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@tablenumberedRefSingularLabel"/>
                    <xsl:with-param name="sDefault" select="$ssingular"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='capitalizedSingular'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@tablenumberedRefCapitalizedSingularLabel"/>
                    <xsl:with-param name="sDefault" select="$sSingular"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='plural'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@tablenumberedRefPluralLabel"/>
                    <xsl:with-param name="sDefault" select="$splural"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@textBefore='capitalizedPlural'">
                <xsl:call-template name="DoItemRefLabel">
                    <xsl:with-param name="sLabel" select="$lingPaper/@tablenumberedRefCapitalizedPluralLabel"/>
                    <xsl:with-param name="sDefault" select="$sPlural"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!--
        OutputAuthorFootnoteSymbol
    -->
    <xsl:template name="OutputAuthorFootnoteSymbol">
        <xsl:param name="iAuthorPosition"/>
        <xsl:choose>
            <xsl:when test="$iAuthorPosition=1">
                <xsl:text>*</xsl:text>
            </xsl:when>
            <xsl:when test="$iAuthorPosition=2">
                <xsl:text>†</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>‡</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
                  OutputChapTitle
-->
    <xsl:template name="OutputChapTitle">
        <xsl:param name="sNumber"/>
        <xsl:param name="sTitle"/>
        <p>
            <xsl:attribute name="style">
                <xsl:call-template name="DoType"/>
            </xsl:attribute>
            <big>
                <big>
                    <big>
                        <b>
                            <xsl:element name="a">
                                <xsl:attribute name="name">
                                    <xsl:value-of select="@id"/>
                                </xsl:attribute>
                                <xsl:if test="$sNumber">
                                    <xsl:value-of select="$sNumber"/>
                                    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                                </xsl:if>
                                <xsl:value-of select="$sTitle"/>
                            </xsl:element>
                        </b>
                    </big>
                </big>
            </big>
        </p>
    </xsl:template>
    <!--  
                  OutputExampleNumber
-->
    <xsl:template name="OutputExampleNumber">
        <xsl:element name="a">
            <xsl:attribute name="name">
                <xsl:value-of select="../../@num"/>
            </xsl:attribute>
            <xsl:text>(</xsl:text>
            <xsl:call-template name="GetExampleNumber">
                <xsl:with-param name="example" select="."/>
            </xsl:call-template>
            <xsl:text>)</xsl:text>
        </xsl:element>
    </xsl:template>
    <!--  
        OutputFigureLabelAndCaption
    -->
    <xsl:template name="OutputFigureLabelAndCaption">
        <xsl:param name="bDoBold" select="'Y'"/>
        <xsl:param name="bDoStyles" select="'Y'"/>
        <span>
            <xsl:if test="$bDoBold='Y'">
                <xsl:attribute name="style">
                    <xsl:text>font-weight:bold;</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:call-template name="OutputFigureLabel"/>
            <xsl:apply-templates select="." mode="figure"/>
            <xsl:text>&#xa0;</xsl:text>
        </span>
        <xsl:choose>
            <xsl:when test="$bDoStyles='Y'">
                <xsl:apply-templates select="caption" mode="show"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="caption" mode="contents"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
                   OutputIndexedItemsRange
-->
    <xsl:template name="OutputIndexedItemsRange">
        <xsl:param name="sIndexedItemID"/>
        <xsl:variable name="sBeginSectionNumber">
            <!-- output section number of lowest-level section containing the indexedItem -->
            <xsl:call-template name="OutputIndexedItemsSectionNumber"/>
        </xsl:variable>
        <a href="#{$sIndexedItemID}">
            <xsl:value-of select="$sBeginSectionNumber"/>
        </a>
        <xsl:if test="name()='indexedRangeBegin'">
            <xsl:variable name="sBeginId" select="@id"/>
            <!-- only use first one because that's all there should be -->
            <xsl:variable name="indexedRangeEnd" select="//indexedRangeEnd[@begin=$sBeginId][1]"/>
            <xsl:variable name="sEndSectionNumber">
                <xsl:for-each select="$indexedRangeEnd">
                    <xsl:call-template name="OutputIndexedItemsSectionNumber"/>
                </xsl:for-each>
            </xsl:variable>
            <xsl:if test="$sEndSectionNumber != $sBeginSectionNumber">
                <!-- only output range if the start and end differ -->
                <xsl:text>-</xsl:text>
                <xsl:variable name="sIndexedEndItemID">
                    <xsl:for-each select="$indexedRangeEnd">
                        <xsl:call-template name="CreateIndexedItemID">
                            <xsl:with-param name="sTermId" select="@begin"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:variable>
                <a href="#{$sIndexedEndItemID}">
                    <xsl:value-of select="$sEndSectionNumber"/>
                </a>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <!--
                   OutputIndexedItemsSectionNumber
-->
    <xsl:template name="OutputIndexedItemsSectionNumber">
        <xsl:choose>
            <xsl:when test="ancestor::section6">
                <xsl:for-each select="ancestor::section6">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section5">
                <xsl:for-each select="ancestor::section5">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section4">
                <xsl:for-each select="ancestor::section4">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section3">
                <xsl:for-each select="ancestor::section3">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section2">
                <xsl:for-each select="ancestor::section2">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::section1">
                <xsl:for-each select="ancestor::section1">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::chapter">
                <xsl:apply-templates select="ancestor::chapter" mode="number"/>
            </xsl:when>
            <xsl:when test="ancestor::chapterBeforePart">
                <xsl:text>0</xsl:text>
            </xsl:when>
            <xsl:when test="ancestor::appendix">
                <xsl:for-each select="ancestor::appendix">
                    <xsl:call-template name="OutputSectionNumber"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="ancestor::part">
                <xsl:apply-templates select="ancestor::part" mode="numberPart"/>
            </xsl:when>
        </xsl:choose>
        <xsl:if test="ancestor::endnote">
            <xsl:text>n</xsl:text>
        </xsl:if>
    </xsl:template>
    <!--
                   OutputIndexTerms
-->
    <xsl:template name="OutputIndexTerms">
        <xsl:param name="sIndexKind"/>
        <xsl:param name="lang"/>
        <xsl:param name="terms"/>
        <xsl:variable name="indexTermsToShow" select="$terms/indexTerm[@kind=$sIndexKind or @kind='subject' and $sIndexKind='common' or count(//index)=1]"/>
        <xsl:if test="$indexTermsToShow">
            <div style="margin-left: 0.5in; margin-right: 0.5in">
                <!-- force line break so we can more effectively use a line-oriented differences tool -->
                <xsl:text>&#xA;</xsl:text>
                <xsl:for-each select="$indexTermsToShow">
                    <xsl:sort lang="{$lang}" select="term[@lang=$lang or position()=1 and not (following-sibling::term[@lang=$lang])]"/>
                    <xsl:variable name="sTermId" select="@id"/>
                    <!-- if a nested index term is cited, we need to be sure to show its parents, even if they are not cited -->
                    <xsl:variable name="bHasCitedDescendant">
                        <xsl:for-each select="descendant::indexTerm">
                            <xsl:variable name="sDescendantTermId" select="@id"/>
                            <xsl:if test="//indexedItem[@term=$sDescendantTermId] or //indexedRangeBegin[@term=$sDescendantTermId]">
                                <xsl:text>Y</xsl:text>
                            </xsl:if>
                            <xsl:if test="@see">
                                <xsl:call-template name="CheckSeeTargetIsCitedOrItsDescendantIsCited"/>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:variable>
                    <xsl:variable name="indexedItems" select="//indexedItem[@term=$sTermId] | //indexedRangeBegin[@term=$sTermId]"/>
                    <xsl:variable name="bHasSeeAttribute">
                        <xsl:if test="string-length(@see) &gt; 0">
                            <xsl:text>Y</xsl:text>
                        </xsl:if>
                    </xsl:variable>
                    <xsl:variable name="bSeeTargetIsCitedOrItsDescendantIsCited">
                        <xsl:if test="$bHasSeeAttribute='Y'">
                            <xsl:call-template name="CheckSeeTargetIsCitedOrItsDescendantIsCited"/>
                        </xsl:if>
                    </xsl:variable>
                    <xsl:choose>
                        <xsl:when test="$indexedItems or contains($bHasCitedDescendant,'Y')">
                            <!-- this term or one its descendants is cited; show it -->
                            <a>
                                <xsl:attribute name="name">
                                    <xsl:call-template name="CreateIndexTermID">
                                        <xsl:with-param name="sTermId" select="$sTermId"/>
                                    </xsl:call-template>
                                </xsl:attribute>
                                <xsl:call-template name="OutputIndexTermsTerm">
                                    <xsl:with-param name="lang" select="$lang"/>
                                    <xsl:with-param name="indexTerm" select="."/>
                                </xsl:call-template>
                                <xsl:text>&#xa0;&#xa0;</xsl:text>
                            </a>
                            <xsl:for-each select="$indexedItems">
                                <!-- show each reference -->
                                <xsl:variable name="sIndexedItemID">
                                    <xsl:call-template name="CreateIndexedItemID">
                                        <xsl:with-param name="sTermId" select="$sTermId"/>
                                    </xsl:call-template>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="@main='yes' and count($indexedItems) &gt; 1">
                                        <b>
                                            <xsl:call-template name="OutputIndexedItemsRange">
                                                <xsl:with-param name="sIndexedItemID" select="$sIndexedItemID"/>
                                            </xsl:call-template>
                                        </b>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:call-template name="OutputIndexedItemsRange">
                                            <xsl:with-param name="sIndexedItemID" select="$sIndexedItemID"/>
                                        </xsl:call-template>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:if test="position()!=last()">
                                    <xsl:text>, </xsl:text>
                                </xsl:if>
                            </xsl:for-each>
                            <xsl:if test="$bHasSeeAttribute='Y' and contains($bSeeTargetIsCitedOrItsDescendantIsCited, 'Y')">
                                <!-- this term also has a @see attribute which refers to a term that is cited or whose descendant is cited -->
                                <xsl:call-template name="OutputIndexTermSeeBefore">
                                    <xsl:with-param name="indexedItems" select="$indexedItems"/>
                                </xsl:call-template>
                                <a>
                                    <xsl:attribute name="href">
                                        <xsl:text>#</xsl:text>
                                        <xsl:call-template name="CreateIndexTermID">
                                            <xsl:with-param name="sTermId" select="@see"/>
                                        </xsl:call-template>
                                    </xsl:attribute>
                                    <xsl:apply-templates select="key('IndexTermID',@see)/term[@lang=$lang or position()=1 and not (following-sibling::term[@lang=$lang])]" mode="InIndex"/>
                                </a>
                                <xsl:call-template name="OutputIndexTermSeeAfter">
                                    <xsl:with-param name="indexedItems" select="$indexedItems"/>
                                </xsl:call-template>
                            </xsl:if>
                            <br/>
                            <xsl:call-template name="OutputIndexTerms">
                                <xsl:with-param name="sIndexKind" select="$sIndexKind"/>
                                <xsl:with-param name="lang" select="$lang"/>
                                <xsl:with-param name="terms" select="indexTerms"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="$bHasSeeAttribute='Y' and contains($bSeeTargetIsCitedOrItsDescendantIsCited, 'Y')">
                            <!-- neither this term nor its decendants are cited, but it has a @see attribute which refers to a term that is cited or for which one of its descendants is cited -->
                            <!--                            <xsl:apply-templates select="term[1]" mode="InIndex"/>-->
                            <xsl:apply-templates select="term[@lang=$lang or position()=1 and not (following-sibling::term[@lang=$lang])]" mode="InIndex"/>
                            <xsl:call-template name="OutputIndexTermSeeAloneBefore"/>
                            <a>
                                <xsl:attribute name="href">
                                    <xsl:text>#</xsl:text>
                                    <xsl:call-template name="CreateIndexTermID">
                                        <xsl:with-param name="sTermId" select="@see"/>
                                    </xsl:call-template>
                                </xsl:attribute>
                                <xsl:call-template name="OutputIndexTermsTerm">
                                    <xsl:with-param name="lang" select="$lang"/>
                                    <xsl:with-param name="indexTerm" select="key('IndexTermID',@see)"/>
                                </xsl:call-template>
                            </a>
                            <xsl:call-template name="OutputIndexTermSeeAloneAfter"/>
                            <br/>
                            <!-- force line break so we can more effectively use a line-oriented differences tool -->
                            <xsl:text>&#xA;</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    <!--  
                  OutputInterlinearTextReference
-->
    <xsl:template name="OutputInterlinearTextReference">
        <xsl:param name="sRef"/>
        <xsl:param name="sSource"/>
        <xsl:if test="string-length(normalize-space($sRef)) &gt; 0 or $sSource">
            <td>
                <xsl:text disable-output-escaping="yes">&#xa0;&#xa0;</xsl:text>
                <!--            <xsl:text disable-output-escaping="no">&#xa0;&#xa0;</xsl:text>-->
            </td>
            <td>
                <xsl:text>[</xsl:text>
                <xsl:choose>
                    <xsl:when test="$sSource">
                        <!--                  <xsl:value-of select="$sSource"/>-->
                        <xsl:apply-templates select="$sSource" mode="contents"/>
                    </xsl:when>
                    <xsl:when test="string-length(normalize-space($sRef)) &gt; 0">
                        <xsl:call-template name="DoInterlinearRefCitation">
                            <xsl:with-param name="sRef" select="$sRef"/>
                        </xsl:call-template>
                    </xsl:when>
                </xsl:choose>
                <xsl:text>]</xsl:text>
            </td>
        </xsl:if>
    </xsl:template>
    <!--  
                  OutputSection
-->
    <xsl:template name="OutputSection">
        <xsl:attribute name="style">
            <xsl:call-template name="DoType"/>
        </xsl:attribute>
        <xsl:element name="a">
            <xsl:attribute name="name">
                <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:call-template name="OutputSectionNumberAndTitle"/>
        </xsl:element>
    </xsl:template>
    <!--  
                  OutputSectionNumber
-->
    <xsl:template name="OutputSectionNumber">
        <xsl:choose>
            <xsl:when test="name()='appendix' or ancestor::appendix">
                <xsl:apply-templates select="." mode="numberAppendix"/>
                <xsl:if test="name()='appendix'">
                    <xsl:text>.</xsl:text>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="number"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
      OutputSectionNumberAndTitle
   -->
    <xsl:template name="OutputSectionNumberAndTitle">
        <xsl:call-template name="OutputSectionNumber"/>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        <xsl:apply-templates select="secTitle"/>
    </xsl:template>
    <!--  
      OutputSectionNumberAndTitleInContents
   -->
    <xsl:template name="OutputSectionNumberAndTitleInContents">
        <xsl:call-template name="OutputSectionNumber"/>
        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        <xsl:apply-templates select="secTitle" mode="contents"/>
    </xsl:template>
    <!--  
                  OutputAllChapterTOC
-->
    <xsl:template name="OutputAllChapterTOC">
        <xsl:param name="nLevel" select="3"/>
        <li>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:call-template name="OutputChapterNumber"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                <xsl:apply-templates select="secTitle"/>
            </xsl:element>
            <ul>
                <xsl:call-template name="OutputAllSectionTOC">
                    <xsl:with-param name="nLevel">
                        <xsl:value-of select="$nLevel"/>
                    </xsl:with-param>
                    <xsl:with-param name="nodesSection1" select="section1"/>
                </xsl:call-template>
            </ul>
        </li>
    </xsl:template>
    <!--  
                  OutputAllSectionTOC
-->
    <xsl:template name="OutputAllSectionTOC">
        <xsl:param name="nLevel" select="3"/>
        <xsl:param name="nodesSection1"/>
        <xsl:if test="$nLevel!=0">
        <xsl:for-each select="$nodesSection1">
            <xsl:call-template name="OutputSectionTOC"/>
            <xsl:if test="section2 and $nLevel>=2">
                <ul>
                    <xsl:for-each select="section2">
                        <xsl:call-template name="OutputSectionTOC"/>
                        <xsl:if test="section3 and $nLevel>=3">
                            <ul>
                                <xsl:for-each select="section3">
                                    <xsl:call-template name="OutputSectionTOC"/>
                                    <xsl:if test="section4 and $nLevel>=4">
                                        <ul>
                                            <xsl:for-each select="section4">
                                                <xsl:call-template name="OutputSectionTOC"/>
                                                <xsl:if test="section5 and $nLevel>=5">
                                                    <ul>
                                                        <xsl:for-each select="section5">
                                                            <xsl:call-template name="OutputSectionTOC"/>
                                                            <xsl:if test="section6 and $nLevel>=6">
                                                                <ul>
                                                                    <xsl:for-each select="section6">
                                                                        <xsl:call-template name="OutputSectionTOC"/>
                                                                    </xsl:for-each>
                                                                </ul>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                    </ul>
                                                </xsl:if>
                                            </xsl:for-each>
                                        </ul>
                                    </xsl:if>
                                </xsl:for-each>
                            </ul>
                        </xsl:if>
                    </xsl:for-each>
                </ul>
            </xsl:if>
        </xsl:for-each>
        </xsl:if>
    </xsl:template>
    <!--  
                  OutputSectionTOC
-->
    <xsl:template name="OutputSectionTOC">
        <li>
            <xsl:element name="a">
                <xsl:attribute name="href">
                    <xsl:text>#</xsl:text>
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:call-template name="OutputSectionNumberAndTitleInContents"/>
            </xsl:element>
        </li>
    </xsl:template>
    <!--  
                  OutputTableCells
-->
    <xsl:template name="OutputTableCells">
        <xsl:param name="sList"/>
        <xsl:param name="language"/>
        <xsl:variable name="sNewList" select="concat(normalize-space($sList),' ')"/>
        <xsl:variable name="sFirst" select="substring-before($sNewList,' ')"/>
        <xsl:variable name="sRest" select="substring-after($sNewList,' ')"/>
        <xsl:element name="td">
            <xsl:attribute name="style">
                <xsl:call-template name="OutputFontAttributes">
                    <xsl:with-param name="language" select="key('LanguageID',$language)"/>
                </xsl:call-template>
                <xsl:value-of select="$sExampleCellPadding"/>
            </xsl:attribute>
            <xsl:value-of select="$sFirst"/>
        </xsl:element>
        <xsl:if test="$sRest">
            <xsl:call-template name="OutputTableCells">
                <xsl:with-param name="sList" select="$sRest"/>
                <xsl:with-param name="language" select="$language"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <!--  
        OutputTableNumberedLabel
    -->
    <xsl:template name="OutputTableNumberedLabel">
        <xsl:variable name="label" select="$lingPaper/@tablenumberedLabel"/>
        <xsl:choose>
            <xsl:when test="string-length($label) &gt; 0">
                <xsl:value-of select="$label"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Table </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
        OutputTableNumberedLabelAndCaption
    -->
    <xsl:template name="OutputTableNumberedLabelAndCaption">
        <xsl:param name="bDoBold" select="'Y'"/>
        <xsl:param name="bDoStyles" select="'Y'"/>
        <span>
            <xsl:if test="$bDoBold='Y'">
                <xsl:attribute name="style">
                    <xsl:text>font-weight:bold;</xsl:text>
                </xsl:attribute>
            </xsl:if>
            <xsl:call-template name="OutputTableNumberedLabel"/>
            <xsl:apply-templates select="." mode="tablenumbered"/>
            <xsl:text>&#xa0;</xsl:text>
        </span>
        <xsl:choose>
            <xsl:when test="$bDoStyles='Y'">
                <xsl:apply-templates select="table/caption | table/endCaption" mode="show"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="table/caption | table/endCaption" mode="contents"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  
                  ReverseContents
-->
    <xsl:template name="ReverseContents">
        <xsl:param name="sList"/>
        <xsl:variable name="sNewList" select="concat(normalize-space($sList),' ')"/>
        <xsl:variable name="sFirst" select="substring-before($sNewList,' ')"/>
        <xsl:variable name="sRest" select="substring-after($sNewList,' ')"/>
        <xsl:if test="$sRest">
            <xsl:call-template name="ReverseContents">
                <xsl:with-param name="sList" select="$sRest"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:value-of select="$sFirst"/>
        <xsl:text>&#x20;</xsl:text>
    </xsl:template>
    <xsl:template match="interlinearSource" mode="contents">
        <xsl:apply-templates/>
    </xsl:template>
    <!-- ===========================================================
      ELEMENTS TO IGNORE
      =========================================================== -->
    <xsl:template match="language"/>
    <xsl:template match="comment"/>
    <xsl:template match="interlinearSource"/>
    <xsl:template match="shortTitle"/>
    <xsl:template match="styles"/>
    <xsl:template match="style"/>
    <xsl:template match="term"/>
    <xsl:template match="type"/>
</xsl:stylesheet>
